package com.instabug.fatalhangs.configuration

import com.instabug.commons.preferences.PrefSpecs
import com.instabug.commons.preferences.crashPref
import com.instabug.crash.Constants
import com.instabug.crash.di.CrashesServiceLocator
import com.instabug.crash.utils.CrashReportingUtility
import com.instabug.library.IBGFeature
import com.instabug.library.core.InstabugCore
import com.instabug.library.visualusersteps.ReproConfigurationsProvider
import com.instabug.library.visualusersteps.ReproProxyAuthID

interface FatalHangsConfigurationProvider: ReproConfigurationsProvider {
    /**
     * References the Availability of fatal hangs
     */
    var isFatalHangsAvailable: Boolean

    /**
     * References the sensitivity of detecting fatal hangs
     */
    var fatalHangsSensitivity: Long

    /**
     * Gets current state of fatal hangs
     * @return true if enabled, false otherwise
     */
    fun isFatalHangsEnabled(): Boolean
}

class FatalHangsConfigurationProviderImpl : FatalHangsConfigurationProvider {

    override var isFatalHangsAvailable: Boolean
            by crashPref(Constants.Preferences.FATAL_HANGS_AVAILABILITY)

    override var fatalHangsSensitivity: Long
            by crashPref(Constants.Preferences.FATAL_HANGS_SENSITIVITY)

    override fun isFatalHangsEnabled(): Boolean =
        CrashReportingUtility.isCrashReportingEnabled() && isFatalHangsAvailable

    override var isReproScreenShotsEnabledSDK: Boolean = true

    override var isReproStepsEnabledSDK: Boolean = true
    override val reproProxyAuthId: Int
        get() = ReproProxyAuthID.AppHangs
    override val isReproStepsEnabled: Boolean
        get() = isReproStepsEnabledSDK && isFatalHangsEnabled()
    override val isReproScreenshotsEnabled: Boolean
        get() = isReproScreenShotsEnabledSDK && isReproScreenshotsAvailable && isReproFeaturesAvailable && isFatalHangsEnabled()

    private val isReproFeaturesAvailable: Boolean
        get() = InstabugCore.isFeatureAvailable(IBGFeature.REPRO_STEPS)

    override var isReproScreenshotsAvailable: Boolean = true
    get() = CrashReportingUtility.isReproScreenshotsAvailable()

}