package com.instabug.crash.utils;


import com.instabug.commons.di.CommonsLocator;
import com.instabug.crash.Constants;
import com.instabug.crash.di.CrashesServiceLocator;
import com.instabug.library.Instabug;
import com.instabug.library.util.InstabugSDKLogger;

public class CrashReportingUtility {

    public static boolean isCrashReportingEnabled() {
        boolean isCrashReportingEnabled = CrashesServiceLocator.getCrashConfigurationProvider().isCrashReportingEnabled();
        return Instabug.isEnabled() && isCrashReportingEnabled;
    }

    public static boolean isNonFatalReportingEnabled() {
        boolean isNonFatalEnabled =
                CrashesServiceLocator.getCrashConfigurationProvider().isNonFatalReportingEnabled();
        return Instabug.isEnabled() && isNonFatalEnabled;
    }

    public static boolean isReproScreenshotsAvailable() {
        return CommonsLocator.getConfigurationsProvider().isReproScreenshotsAvailable();
    }
}
