package com.instabug.commons.session

import androidx.annotation.IntDef
import com.instabug.commons.models.Incident.Type

data class SessionIncident constructor(
    val sessionId: String,
    val incidentId: String?,
    val incidentType: Type,
    @ValidationStatus val validationStatus: Int = ValidationStatus.UNVALIDATED,
    val id: Long = System.currentTimeMillis()
) {

    fun isValidated() = validationStatus > ValidationStatus.UNVALIDATED

    @Retention(AnnotationRetention.RUNTIME)
    @IntDef(ValidationStatus.UNVALIDATED, ValidationStatus.VALIDATED)
    annotation class ValidationStatus {
        companion object {
            const val UNVALIDATED = 0
            const val VALIDATED = 1
        }
    }
}
