package com.instabug.commons.metadata

import com.instabug.commons.di.CommonsLocator
import com.instabug.crash.Constants.LOG_TAG
import com.instabug.crash.OnCrashSentCallback
import com.instabug.crash.di.CrashesServiceLocator
import com.instabug.crash.models.CrashMetadata
import com.instabug.library.util.InstabugSDKLogger
import com.instabug.library.util.threading.PoolProvider

object OnCrashSentCallbackWrapper : OnCrashSentCallback {
    private val userCallback
        get() = CommonsLocator.userCrashMetadataCallback
    private val configurationsProvider
        get() = CrashesServiceLocator.crashConfigurationProvider

    override fun onCrashSent(crashMetaData: CrashMetadata) {
        PoolProvider.postIOTask {
            kotlin.runCatching {
                takeIf { configurationsProvider.isCrashMetaDataCallbackEnabled }
                    ?.userCallback
                    ?.onCrashSent(crashMetaData)
            }.onFailure {
                InstabugSDKLogger.e(
                    LOG_TAG, "Something went wrong while calling OnCrashSentCallback", it
                )
            }
        }
    }
}