package com.instabug.commons.diagnostics.reporter

import androidx.annotation.VisibleForTesting
import com.instabug.commons.diagnostics.di.DiagnosticsLocator
import com.instabug.commons.diagnostics.event.DiagnosticEvent
import com.instabug.commons.utils.isAtLeastRunningR
import com.instabug.commons.logging.logVerbose
import com.instabug.library.diagnostics.IBGDiagnostics

@VisibleForTesting
const val REPORTER_LOG_MESSAGE_FORMAT = "SDK diagnostic event %s reported."

class DefaultDiagnosticsReporter : DiagnosticsReporter {

    private val isDiagnosticsEnabled: Boolean
        get() = DiagnosticsLocator.configProvider.isDiagnosticsEnabled

    override fun report(event: DiagnosticEvent) {
        //Reporting only if operating on Android API 30+ for compatibility with ExitInfo
        if (!isAtLeastRunningR) return
        //Should only report if diagnostics flag is enabled for crashes
        if (!isDiagnosticsEnabled) return
        //Should respect event special predicates which for now includes specific feature state checks
        if (!event.reportingPredicate()) return
        IBGDiagnostics.logEventImmediately(event.key, event.count)
        REPORTER_LOG_MESSAGE_FORMAT.format(event.toString()).logVerbose()
    }
}