package com.instabug.commons.diagnostics

import android.content.Context
import com.instabug.commons.DefaultOSExitInfoExtractor
import com.instabug.commons.OSExitInfo
import com.instabug.commons.PluginDelegate
import com.instabug.commons.configurations.ConfigurationsHandler
import com.instabug.commons.diagnostics.DiagnosticsConstants.Preferences
import com.instabug.commons.diagnostics.di.DiagnosticsLocator
import com.instabug.commons.diagnostics.event.CalibrationDiagnosticEvent
import com.instabug.commons.utils.isAtLeastRunningR
import com.instabug.library.Instabug
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent

class DiagnosticsPluginDelegate : PluginDelegate {

    private val configHandler: ConfigurationsHandler
        get() = DiagnosticsLocator.configHandler

    override fun init(context: Context) {
        // No-Op
    }

    override fun start(context: Context) {
        // No-Op
    }

    override fun wake() {
        Instabug.getApplicationContext()?.let { ctx -> reportOSExitDiagnostics(ctx) }
    }

    override fun sleep() {
        // No-Op
    }

    override fun stop() {
        // No-Op
    }

    override fun handleSDKCoreEvent(sdkCoreEvent: IBGSdkCoreEvent) {
        if (sdkCoreEvent is IBGSdkCoreEvent.FeaturesFetched)
            configHandler.handleConfiguration(sdkCoreEvent.response)
    }

    private fun reportOSExitDiagnostics(ctx: Context): Unit = with(DiagnosticsLocator) {
        if (!isAtLeastRunningR) return
        DefaultOSExitInfoExtractor().extract(ctx, Preferences.exitInfoBaselineSpecs).infoList
            .asSequence()
            .map(OSExitInfo::internalReason)
            .map(::CalibrationDiagnosticEvent)
            .forEach(reporter::report)
    }
}
