package com.instabug.terminations.configuration

import com.instabug.commons.preferences.PrefSpecs
import com.instabug.commons.preferences.crashPref
import com.instabug.crash.Constants.Preferences.TERMINATIONS_AVAILABILITY
import com.instabug.crash.Constants.Preferences.TERMINATIONS_STATE_RATIO
import com.instabug.crash.Constants.Preferences.TERMINATIONS_THRESHOLD
import com.instabug.crash.di.CrashesServiceLocator
import com.instabug.crash.utils.CrashReportingUtility
import com.instabug.library.IBGFeature
import com.instabug.library.core.InstabugCore
import com.instabug.library.visualusersteps.ReproConfigurationsProvider
import com.instabug.library.visualusersteps.ReproProxyAuthID

interface TerminationsConfigurationProvider : ReproConfigurationsProvider {

    /**
     * References the availability of app terminations feature
     */
    var isAvailable: Boolean

    /**
     * References threshold of collecting app terminations
     * if relaunching app time < threshold, App termination should be detected
     */
    var threshold: Long

    /**
     * References the percentage of state object that will be collected
     * when app termination is captured
     */
    var stateRatio: Float

    /**
     * /**
     * Gets current state of App terminations feature
     * @return true if enabled, false otherwise
    */
     */
    fun isEnabled(): Boolean
}

class TerminationsConfigurationProviderImpl : TerminationsConfigurationProvider {

    override var isAvailable: Boolean
            by crashPref(TERMINATIONS_AVAILABILITY)

    override var threshold: Long
            by crashPref(TERMINATIONS_THRESHOLD)

    override var stateRatio: Float
            by crashPref(TERMINATIONS_STATE_RATIO)

    override fun isEnabled(): Boolean =
        CrashReportingUtility.isCrashReportingEnabled() && isAvailable

    override var isReproScreenShotsEnabledSDK: Boolean = true

    override var isReproStepsEnabledSDK: Boolean = true

    override var isReproScreenshotsAvailable: Boolean = true
        get() = CrashReportingUtility.isReproScreenshotsAvailable()
    override val reproProxyAuthId: Int
        get() = ReproProxyAuthID.ForceRestarts
    override val isReproStepsEnabled: Boolean
        get() = isReproStepsEnabledSDK && isAvailable && CrashReportingUtility.isCrashReportingEnabled()

    override var isReproScreenshotsEnabled: Boolean = true
        get() = isReproScreenShotsEnabledSDK && isReproScreenshotsAvailable && isReproFeaturesAvailable
                && isAvailable && CrashReportingUtility.isCrashReportingEnabled()

    private val isReproFeaturesAvailable: Boolean
        get() = InstabugCore.isFeatureAvailable(IBGFeature.REPRO_STEPS)

}