package com.instabug.commons.diagnostics.configurations

import com.instabug.commons.configurations.ConfigurationsHandler
import com.instabug.commons.diagnostics.di.DiagnosticsLocator
import com.instabug.commons.logging.getOrReportError
import org.json.JSONObject

private const val CRASHES_RESPONSE_KEY = "crashes"
private const val DIAGNOSTICS_RESPONSE_KEY = "exit_info"
private const val ENABLED_RESPONSE_KEY = "enabled"

class DiagnosticsConfigurationsHandler : ConfigurationsHandler {

    override fun handleConfiguration(configuration: String?) {
        configuration?.runCatching {
            JSONObject(this)
                .optJSONObject(CRASHES_RESPONSE_KEY)
                ?.optJSONObject(DIAGNOSTICS_RESPONSE_KEY)
                ?.optBoolean(ENABLED_RESPONSE_KEY)
                ?.also { isEnabled -> updateAvailability(isEnabled) }; Unit
        }?.getOrReportError("Something went wrong parsing crash diagnostics response")
    }

    override fun migrateCurrentConfiguration() {
        //No-Op
    }

    private fun updateAvailability(isAvailable: Boolean) = run {
        DiagnosticsLocator.configProvider.isDiagnosticsAvailable = isAvailable
    }
}