package com.instabug.commons

import android.net.Uri
import androidx.annotation.VisibleForTesting
import com.instabug.commons.logging.logWarning
import com.instabug.library.model.Attachment
import com.instabug.library.model.Attachment.Type

interface AttachmentsHolder {
    val attachments: List<Attachment>

    fun addAttachment(uri: Uri?, type: Type, isEncrypted: Boolean = false)

    fun setAttachments(attachments: List<Attachment>)
}

@VisibleForTesting
const val WARNING_NULL_URI = "Adding attachment with a null Uri, ignored."

class BasicAttachmentsHolder : AttachmentsHolder {

    private var internalAttachments: MutableList<Attachment> = mutableListOf()

    override val attachments: List<Attachment>
        get() = internalAttachments

    override fun addAttachment(uri: Uri?, type: Type, isEncrypted: Boolean) {
        uri ?: run {
            WARNING_NULL_URI.logWarning()
            return
        }
        Attachment()
            .apply { uri.lastPathSegment?.let { lastSegment -> name = lastSegment } }
            .apply { uri.path?.let { path -> localPath = path } }
            .apply { setType(type) }
            .apply { setEncrypted(isEncrypted) }
            .also(internalAttachments::add)
    }

    override fun setAttachments(attachments: List<Attachment>) {
        internalAttachments = attachments.toMutableList()
    }
}