/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.settings;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import com.instabug.commons.preferences.CrashPrefPropertyKt;
import com.instabug.library.Instabug;

public class PersistableSettings {
    private static PersistableSettings persistableSettings;
    @Nullable
    private SharedPreferences sharedPreferences = CrashPrefPropertyKt.getCrashesPreferences();

    private PersistableSettings() {
    }

    public static void init() {
        persistableSettings = new PersistableSettings();
    }

    public static PersistableSettings getInstance() {
        if (persistableSettings == null && Instabug.getApplicationContext() != null) {
            PersistableSettings.init();
        }
        return persistableSettings;
    }

    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    public static void release() {
        persistableSettings = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setLastCrashTime(long time) {
        void var1_1;
        PersistableSettings this_ = this_.sharedPreferences;
        if (this_ == null) {
            return;
        }
        this_.edit().putLong("last_crash_time", (long)var1_1).apply();
    }

    public long getLastCrashTime() {
        PersistableSettings this_ = this_.sharedPreferences;
        if (this_ == null) {
            return 0L;
        }
        return this_.getLong("last_crash_time", 0L);
    }

    public boolean isFirstRunAfterEncryptorUpdate() {
        PersistableSettings this_ = this_.sharedPreferences;
        if (this_ == null) {
            return true;
        }
        return this_.getBoolean("ib_first_run_after_updating_encryptor", true);
    }

    /*
     * WARNING - void declaration
     */
    public void setFirstRunAfterEncryptorUpdate(boolean isFirstRun) {
        void var1_1;
        PersistableSettings this_ = this_.sharedPreferences;
        if (this_ == null) {
            return;
        }
        this_.edit().putBoolean("ib_first_run_after_updating_encryptor", (boolean)var1_1).apply();
    }

    /*
     * WARNING - void declaration
     */
    public void setLastCrashRequestStartedAt(long time) {
        void var1_1;
        PersistableSettings this_ = this_.sharedPreferences;
        if (this_ == null) {
            return;
        }
        this_.edit().putLong("last_crash_request_started_at", (long)var1_1).apply();
    }

    public long getLastCrashRequestStartedAt() {
        PersistableSettings this_ = this_.sharedPreferences;
        return this_ == null ? 0L : this_.getLong("last_crash_request_started_at", 0L);
    }

    /*
     * WARNING - void declaration
     */
    public void setCrashesLimitedUntil(int period) {
        void var1_2;
        if (this.sharedPreferences == null) {
            return;
        }
        PersistableSettings persistableSettings = this;
        long l = persistableSettings.getLastCrashRequestStartedAt() + (long)var1_2 * 1000L;
        persistableSettings.sharedPreferences.edit().putLong("crashes_rate_limited_until", l).apply();
    }

    public long getCrashesLimitedUntil() {
        PersistableSettings this_ = this_.sharedPreferences;
        return this_ == null ? 0L : this_.getLong("crashes_rate_limited_until", 0L);
    }
}

