/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.commons.session;

import com.instabug.commons.models.Incident;
import com.instabug.commons.session.SessionIncident;
import com.instabug.library.model.v3Session.IBGSessionData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=2, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a'\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\n\u0010\u000b\u001a-\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\f\u0010\u000b\u001aC\u0010\u0010\u001a\u0012\u0012\b\u0012\u00060\u0002j\u0002`\u000e\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u000e0\u0005\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u001b\u0010\u0012\u001a\u00020\t2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a%\u0010\u0014\u001a\u00020\t*\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a)\u0010\u0017\u001a\u00020\u00162\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a7\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\b*\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a+\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\b*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/instabug/commons/models/Incident$Type;", "type", "", "incidentToRequestKey", "(Lcom/instabug/commons/models/Incident$Type;)Ljava/lang/String;", "", "Lcom/instabug/commons/session/SessionIncident;", "incidents", "", "Lcom/instabug/library/model/v3Session/IBGSessionData;", "incidentsToSessionsData", "(Ljava/util/List;)Ljava/util/Map;", "groupIncidentsBySessionsIds", "linkedSessions", "Lcom/instabug/library/sessionV3/providers/SessionID;", "fullSessions", "complementSessionsMap", "(Ljava/util/Map;Ljava/util/List;)Ljava/util/Map;", "extractSessionData", "(Ljava/util/List;)Lcom/instabug/library/model/v3Session/IBGSessionData;", "toSessionData", "(Ljava/util/Map;)Lcom/instabug/library/model/v3Session/IBGSessionData;", "Lorg/json/JSONObject;", "constructCrashesJsonObject", "(Ljava/util/Map;)Lorg/json/JSONObject;", "mapValuesToIncidentsIds", "(Ljava/util/Map;)Ljava/util/Map;", "groupByIncidentsType", "instabug-crash_defaultUiRelease"}, xi=48)
@SourceDebugExtension(value={"SMAP\nSessionsIncidentMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionsIncidentMapper.kt\ncom/instabug/commons/session/SessionsIncidentMapperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,70:1\n1#2:71\n1#2:114\n442#3:72\n392#3:73\n361#3,7:82\n442#3:100\n392#3:101\n361#3,7:122\n457#3:132\n403#3:133\n1238#4,4:74\n1477#4:78\n1502#4,3:79\n1505#4,3:89\n1271#4,2:92\n1285#4,4:94\n1238#4,2:102\n1603#4,9:104\n1855#4:113\n1856#4:115\n1612#4:116\n1241#4:117\n1477#4:118\n1502#4,3:119\n1505#4,3:129\n1238#4,4:134\n215#5,2:98\n*S KotlinDebug\n*F\n+ 1 SessionsIncidentMapper.kt\ncom/instabug/commons/session/SessionsIncidentMapperKt\n*L\n65#1:114\n34#1:72\n34#1:73\n37#1:82,7\n65#1:100\n65#1:101\n68#1:122,7\n69#1:132\n69#1:133\n34#1:74,4\n37#1:78\n37#1:79,3\n37#1:89,3\n43#1:92,2\n43#1:94,4\n65#1:102,2\n65#1:104,9\n65#1:113\n65#1:115\n65#1:116\n65#1:117\n68#1:118\n68#1:119,3\n68#1:129,3\n69#1:134,4\n57#1:98,2\n*E\n"})
public abstract class SessionsIncidentMapperKt {
    private static final String incidentToRequestKey(Incident.Type type) {
        String string;
        Incident.Type type2;
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 7: {
                string = "ats";
                break;
            }
            case 6: {
                string = "ndkc";
                break;
            }
            case 5: {
                string = "nf";
                break;
            }
            case 4: {
                string = "f";
                break;
            }
            case 3: {
                string = "fh";
                break;
            }
            case 2: {
                string = "bg_anr";
                break;
            }
            case 1: {
                string = "anr";
            }
        }
        return string;
    }

    @NotNull
    public static final Map<String, IBGSessionData> incidentsToSessionsData(@NotNull List<SessionIncident> incidents) {
        LinkedHashMap<String, IBGSessionData> linkedHashMap;
        List<SessionIncident> list = incidents;
        Intrinsics.checkNotNullParameter(list, (String)"incidents");
        Iterator iterator = SessionsIncidentMapperKt.groupIncidentsBySessionsIds(list);
        LinkedHashMap<String, IBGSessionData> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<String, IBGSessionData>(MapsKt.mapCapacity((int)iterator.size()));
        for (Map.Entry entry : iterator.entrySet()) {
            linkedHashMap2.put((String)entry.getKey(), SessionsIncidentMapperKt.extractSessionData((List)entry.getValue()));
        }
        return linkedHashMap2;
    }

    @NotNull
    public static final Map<String, List<SessionIncident>> groupIncidentsBySessionsIds(@NotNull List<SessionIncident> incidents) {
        LinkedHashMap linkedHashMap;
        List<SessionIncident> list = incidents;
        Intrinsics.checkNotNullParameter(list, (String)"incidents");
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        for (Object t : list) {
            String string = ((SessionIncident)t).getSessionId();
            Object object = linkedHashMap2.get(string);
            if (object == null) {
                ArrayList arrayList;
                object = arrayList;
                arrayList = new ArrayList();
                linkedHashMap2.put(string, object);
            }
            ((List)object).add(t);
        }
        return linkedHashMap2;
    }

    @NotNull
    public static final Map<String, IBGSessionData> complementSessionsMap(@NotNull Map<String, IBGSessionData> linkedSessions, @NotNull List<String> fullSessions) {
        LinkedHashMap linkedHashMap;
        Object object;
        Map<String, IBGSessionData> map2;
        Intrinsics.checkNotNullParameter(map2, (String)"linkedSessions");
        Intrinsics.checkNotNullParameter((Object)object, (String)"fullSessions");
        object = CollectionsKt.minus(fullSessions, map2.keySet());
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10)), (int)16));
        object = object.iterator();
        while (object.hasNext()) {
            JSONObject jSONObject;
            IBGSessionData iBGSessionData;
            Object e = object.next();
            String cfr_ignored_0 = (String)e;
            IBGSessionData iBGSessionData2 = iBGSessionData;
            JSONObject jSONObject2 = jSONObject;
            jSONObject = new JSONObject();
            iBGSessionData = new IBGSessionData("cd", jSONObject2);
            linkedHashMap2.put(e, iBGSessionData2);
        }
        return MapsKt.plus(linkedHashMap2, map2);
    }

    @NotNull
    public static final IBGSessionData extractSessionData(@NotNull List<SessionIncident> incidents) {
        List<SessionIncident> list = incidents;
        Intrinsics.checkNotNullParameter(list, (String)"incidents");
        return SessionsIncidentMapperKt.toSessionData(SessionsIncidentMapperKt.mapValuesToIncidentsIds(SessionsIncidentMapperKt.groupByIncidentsType(list)));
    }

    private static final IBGSessionData toSessionData(Map<String, ? extends List<String>> $this$toSessionData) {
        JSONObject jSONObject = SessionsIncidentMapperKt.constructCrashesJsonObject($this$toSessionData);
        return new IBGSessionData("cd", jSONObject);
    }

    private static final JSONObject constructCrashesJsonObject(Map<String, ? extends List<String>> incidents) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        for (Map.Entry<String, ? extends List<String>> entry : incidents.entrySet()) {
            List<String> list = entry.getValue();
            if (list.isEmpty()) {
                list = null;
            }
            if (list == null) continue;
            jSONObject2.put(entry.getKey(), (Object)new JSONArray(list));
        }
        return jSONObject2;
    }

    private static final Map<String, List<String>> mapValuesToIncidentsIds(Map<String, ? extends List<SessionIncident>> $this$mapValuesToIncidentsIds) {
        Object object;
        LinkedHashMap<String, List<String>> linkedHashMap;
        LinkedHashMap<String, List<String>> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<String, List<String>>(MapsKt.mapCapacity((int)object.size()));
        for (Map.Entry entry : $this$mapValuesToIncidentsIds.entrySet()) {
            ArrayList<String> arrayList;
            Object k = entry.getKey();
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>();
            Iterator iterator = ((Iterable)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                String string = ((SessionIncident)iterator.next()).getIncidentId();
                if (string == null) continue;
                arrayList2.add(string);
            }
            linkedHashMap2.put((String)k, (List<String>)arrayList2);
        }
        return linkedHashMap2;
    }

    private static final Map<String, List<SessionIncident>> groupByIncidentsType(List<SessionIncident> $this$groupByIncidentsType) {
        LinkedHashMap linkedHashMap;
        LinkedHashMap linkedHashMap2;
        Iterator iterator = linkedHashMap2;
        linkedHashMap2 = new LinkedHashMap();
        for (Object object : $this$groupByIncidentsType) {
            Incident.Type type = ((SessionIncident)object).getIncidentType();
            Object object2 = iterator.get((Object)type);
            if (object2 == null) {
                ArrayList arrayList;
                object2 = arrayList;
                arrayList = new ArrayList();
                iterator.put(type, object2);
            }
            ((List)object2).add(object);
        }
        LinkedHashMap linkedHashMap3 = linkedHashMap;
        linkedHashMap = new LinkedHashMap(MapsKt.mapCapacity((int)iterator.size()));
        for (Map.Entry entry : iterator.entrySet()) {
            String string = SessionsIncidentMapperKt.incidentToRequestKey((Incident.Type)((Object)entry.getKey()));
            linkedHashMap3.put(string, entry.getValue());
        }
        return linkedHashMap3;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public abstract class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Incident.Type.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[Incident.Type.ANR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Incident.Type.BG_ANR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Incident.Type.FatalHang.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Incident.Type.FatalCrash.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Incident.Type.NonFatalCrash.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Incident.Type.NDKCrash.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Incident.Type.Termination.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

