/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.anr;

import android.app.ActivityManager;
import android.os.Debug;
import com.instabug.anr.AnrListener;
import com.instabug.anr.ProcessStateHelper;
import com.instabug.anr.di.AnrServiceLocator;
import com.instabug.anr.diagnostics.ANRIncidentType;
import com.instabug.anr.model.Anr;
import com.instabug.commons.di.CommonsLocator;
import com.instabug.commons.diagnostics.di.DiagnosticsLocator;
import com.instabug.commons.diagnostics.event.CalibrationDiagnosticEvent;
import com.instabug.commons.models.Incident;
import com.instabug.commons.models.IncidentMetadata;
import com.instabug.library.Instabug;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.DefensiveRunnableKt;
import java.io.IOException;
import org.json.JSONException;

public class InstabugAnrDetectorThread
extends Thread {
    private boolean isAnrReported = false;
    private boolean isInterrupted = false;
    private AnrListener anrListener;
    private Anr.Factory anrFactory;
    private ProcessStateHelper processStateHelper;

    /*
     * WARNING - void declaration
     */
    public InstabugAnrDetectorThread(AnrListener anrListener, Anr.Factory anrFactory, ProcessStateHelper processStateHelper) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.anrListener = var1_1;
        this.anrFactory = var2_2;
        this.processStateHelper = var3_3;
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.isInterrupted = true;
    }

    @Override
    public void run() {
        InstabugAnrDetectorThread instabugAnrDetectorThread = this;
        instabugAnrDetectorThread.setName("Instabug ANR detector thread");
        DefensiveRunnableKt.runDefensive(() -> {
            while (Instabug.isEnabled() && !this.isInterrupted() && !this.isInterrupted) {
                block12: {
                    boolean bl;
                    Object object;
                    block13: {
                        block9: {
                            JSONException jSONException2;
                            block11: {
                                if (Debug.isDebuggerConnected() || Debug.waitingForDebugger()) break block12;
                                InstabugAnrDetectorThread instabugAnrDetectorThread = this;
                                object = instabugAnrDetectorThread.processStateHelper.getProcessErrorState();
                                bl = instabugAnrDetectorThread.isAnrReported;
                                if (bl || this.anrListener == null) break block13;
                                if (object == null || object.condition != 2) break block12;
                                DiagnosticsLocator.getReporter().report(new CalibrationDiagnosticEvent(new ANRIncidentType(), "captured"));
                                AnrServiceLocator.getAnrDetectorListener().onDetection("Anr");
                                object = this.anrFactory.createAnr(object.shortMsg, this.processStateHelper.getLongMessageForAnr((ActivityManager.ProcessErrorStateInfo)object), IncidentMetadata.Factory.create());
                                if (object == null) break block9;
                                try {
                                    CommonsLocator.getSessionLinker().link((Incident)object, 1);
                                    this.anrListener.onAnrDetected((Anr)object);
                                    break block9;
                                }
                                catch (IOException iOException) {
                                }
                                catch (JSONException jSONException2) {
                                    break block11;
                                }
                                InstabugSDKLogger.e((String)"IBG-CR", (String)"Couldn't create a new ANR object due to an IO exception", (Throwable)iOException);
                                break block9;
                            }
                            InstabugSDKLogger.e((String)"IBG-CR", (String)"Couldn't create a new ANR object due to a JSON exception", (Throwable)jSONException2);
                        }
                        this.isAnrReported = true;
                        break block12;
                    }
                    if (object == null) {
                        if (bl) {
                            AnrServiceLocator.getAnrDetectorListener().onDetection("Anr Recovery");
                        }
                        this.isAnrReported = false;
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }).run();
    }
}

