package com.instabug.early_crash.model

import com.instabug.library.map.Mapper
import com.instabug.library.model.State
import com.instabug.library.model.State.StateItem
import org.json.JSONObject

class EarlyCrashToJsonMapper: Mapper<EarlyCrash, JSONObject> {

    companion object {
        private const val REPORTED_AT_KEY = State.KEY_REPORTED_AT
        private const val TITLE_KEY = "title"
        private const val HANDLED_KEY = "handled"
        private const val THREAD_DETAILS_KEY = "threads_details"
    }

    override fun map(from: EarlyCrash): JSONObject =
        JSONObject().apply {
            from.state?.let { fillFromState(it) }
            from.id.takeIf { (from.state?.reportedAt ?: 0L) == 0L }
                ?.let { put(REPORTED_AT_KEY, it) }
            from.message?.let { put(TITLE_KEY, it) }
            from.threadsDetails?.let { put(THREAD_DETAILS_KEY, it) }
            put(HANDLED_KEY, false)

        }

    private fun JSONObject.fillFromState(state: State) =
        state.earlyStateItems.forEach { fillWithStateItem(it) }

    private fun <T>JSONObject.fillWithStateItem(item: StateItem<T>) {
        item.key?.let { key ->
            item.value?.let { value ->
                put(key, value)
            }
        }
    }
}