package com.instabug.early_crash.configurations

import android.content.Context
import android.content.SharedPreferences
import com.instabug.crash.BuildConfig

/**
 * This class is used only in content providers as it is a light weight class
 * that holds minimal amount of information
 */
class EarlyCrashesConfigPersistence(private val context: Context?) {

    companion object {
        private const val SHARED_PREFERENCES_NAME = "instabug_crash_minimal"
        private const val IS_EARLY_CAPTURE_ENABLED_KEY = "an_crash_early_capture"
    }

    private val sharedPreferences: SharedPreferences? by lazy {
        context?.getSharedPreferences(
            SHARED_PREFERENCES_NAME,
            Context.MODE_PRIVATE
        )
    }

    private val editor: SharedPreferences.Editor? by lazy { sharedPreferences?.edit() }

    /**
     * Caches the value of EarlyCrashCaptureEnable
     * @param enabled value to cache
     */
    fun setEarlyCrashCaptureEnabled(enabled: Boolean) {
        editor?.putBoolean(IS_EARLY_CAPTURE_ENABLED_KEY, enabled)?.apply()
    }

    /**
     * Gets cached value of EarlyCrashCaptureEnable
     * @return cached boolean value
     */
    fun isEarlyCrashCaptureEnabled() =
        sharedPreferences?.getBoolean(
            IS_EARLY_CAPTURE_ENABLED_KEY,
            BuildConfig.CAPTURE_EARLY_CRASHES
        ) ?: BuildConfig.CAPTURE_EARLY_CRASHES
}