package com.instabug.commons

import androidx.annotation.StringDef

@StringDef(Detection.Crash, Detection.Anr, Detection.AnrRecovery)
annotation class Detection {
    companion object {
        const val Crash = "Crash"
        const val Anr = "Anr"
        const val AnrRecovery = "Anr Recovery"
    }
}

interface IncidentDetectorsListener {
    fun onDetection(@Detection detection: String)
}

interface IncidentDetectorsListenersRegistry : IncidentDetectorsListener {
    fun register(listener: IncidentDetectorsListener)
    fun unregister(listener: IncidentDetectorsListener)
}

class DefaultDetectorsListenersRegistry : IncidentDetectorsListenersRegistry {
    private val listeners: MutableList<IncidentDetectorsListener> = mutableListOf()

    override fun register(listener: IncidentDetectorsListener) {
        listeners += listener
    }

    override fun unregister(listener: IncidentDetectorsListener) {
        listeners -= listener
    }

    override fun onDetection(@Detection detection: String) {
        listeners.forEach { listener -> listener.onDetection(detection) }
    }
}
