/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.terminations;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.instabug.commons.PluginDelegate;
import com.instabug.commons.diagnostics.event.CalibrationDiagnosticEvent;
import com.instabug.commons.diagnostics.event.DiagnosticEvent;
import com.instabug.commons.logging.ExtensionsKt;
import com.instabug.commons.models.Incident;
import com.instabug.commons.session.SessionLinker;
import com.instabug.commons.snapshot.CaptorsRegistry;
import com.instabug.commons.snapshot.StateSnapshotCaptor;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.eventbus.eventpublisher.Subscriber;
import com.instabug.library.sessionV3.sync.SessionBatchingFilter;
import com.instabug.library.sessionV3.sync.SessionBatchingFilterKt;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.ReproCapturingProxy;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import com.instabug.terminations.AbstractTerminationSnapshotCaptor;
import com.instabug.terminations.MigrationResult;
import com.instabug.terminations.TerminationsPluginDelegate;
import com.instabug.terminations.di.ServiceLocator;
import com.instabug.terminations.diagnostics.TerminationIncidentType;
import com.instabug.terminations.model.Termination;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0003J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u000eH\u0002J\u001c\u0010\u0016\u001a\u00020\u000e2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0003J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0004H\u0003J\b\u0010#\u001a\u00020$H\u0003J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020$H\u0003J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\u00020\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0,H\u0002J\b\u0010-\u001a\u00020\u000eH\u0002J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020$H\u0003J\b\u0010/\u001a\u00020\u000eH\u0016J\u0010\u00100\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u00101\u001a\u00020\u000eH\u0003J\b\u00102\u001a\u00020\u000eH\u0002J\b\u00103\u001a\u00020\u000eH\u0016J\u0010\u00104\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0004H\u0003J\b\u00105\u001a\u00020\u000eH\u0002J\b\u00106\u001a\u00020\u000eH\u0003J\u0010\u00107\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020$H\u0003J\b\u00108\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u00069"}, d2={"Lcom/instabug/terminations/TerminationsPluginDelegate;", "Lcom/instabug/commons/PluginDelegate;", "()V", "isLastEnabled", "", "lifecycleDisposable", "Lcom/instabug/library/core/eventbus/eventpublisher/IBGDisposable;", "reproProxy", "Lcom/instabug/library/visualusersteps/ReproCapturingProxy;", "getReproProxy", "()Lcom/instabug/library/visualusersteps/ReproCapturingProxy;", "reproProxy$delegate", "Lkotlin/Lazy;", "addMutualDirsWatcher", "", "consentOnMutualDirsCleansing", "createSessionWeakLink", "handleFeaturesFetched", "featuresResponse", "", "handleFeaturesFetchedEvent", "handleNetworkActivated", "handleReproStateConfigurations", "modesMap", "", "", "handleSDKCoreEvent", "sdkCoreEvent", "Lcom/instabug/library/core/eventbus/coreeventbus/IBGSdkCoreEvent;", "handleTerminationStateChanged", "init", "context", "Landroid/content/Context;", "internalStop", "stopTrmCaptor", "migrateAndSync", "Lcom/instabug/terminations/MigrationResult;", "notifyDataReadiness", "result", "onActivityEvent", "event", "Lcom/instabug/library/tracking/ActivityLifeCycleEvent;", "operateOnExec", "operation", "Lkotlin/Function0;", "removeMutualDirsWatcher", "reportedDiagnosticsCapture", "sleep", "start", "startSnapshotCaptorsIfPossible", "startSyncingIfPossible", "stop", "stopSnapshotCaptors", "subscribeToActivityLifecycleEvents", "validateCurrentSessionWeakLink", "validateWeakLinks", "wake", "instabug-crash_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nTerminationsPluginDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminationsPluginDelegate.kt\ncom/instabug/terminations/TerminationsPluginDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,267:1\n1#2:268\n1855#3,2:269\n1855#3,2:271\n1549#3:273\n1620#3,3:274\n1855#3,2:277\n*S KotlinDebug\n*F\n+ 1 TerminationsPluginDelegate.kt\ncom/instabug/terminations/TerminationsPluginDelegate\n*L\n212#1:269,2\n215#1:271,2\n231#1:273\n231#1:274,3\n236#1:277,2\n*E\n"})
public final class TerminationsPluginDelegate
implements PluginDelegate {
    @Nullable
    private IBGDisposable lifecycleDisposable;
    private boolean isLastEnabled;
    @NotNull
    private final Lazy reproProxy$delegate = LazyKt.lazy((Function0)reproProxy.2.INSTANCE);

    private final ReproCapturingProxy getReproProxy() {
        return (ReproCapturingProxy)this.reproProxy$delegate.getValue();
    }

    private final void handleFeaturesFetchedEvent() {
        Function0<Unit> function0;
        ExtensionsKt.logVerbose("Terminations received features");
        Function0<Unit> function02 = function0;
        function0 = new Function0<Unit>((Object)this){
            {
                void var1_1;
            }

            public final void invoke() {
                TerminationsPluginDelegate.access$handleTerminationStateChanged((TerminationsPluginDelegate)this.receiver);
            }
        };
        this.operateOnExec(function02);
    }

    private final void handleNetworkActivated() {
        ExtensionsKt.logVerbose("Terminations received network activated");
        this.startSyncingIfPossible();
    }

    /*
     * WARNING - void declaration
     */
    private final void handleFeaturesFetched(String featuresResponse) {
        void var1_1;
        Function0<Unit> function0;
        ExtensionsKt.logVerbose("Terminations received features fetched");
        Function0<Unit> function02 = function0;
        function0 = new Function0<Unit>(this, (String)var1_1){
            final /* synthetic */ TerminationsPluginDelegate this$0;
            final /* synthetic */ String $featuresResponse;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$featuresResponse = var2_2;
                super(0);
            }

            public final void invoke() {
                handleFeaturesFetched.1 v0 = this;
                ServiceLocator serviceLocator = ServiceLocator.INSTANCE;
                TerminationsPluginDelegate.access$getReproProxy(v0.this$0).evaluate((ReproConfigurationsProvider)serviceLocator.getTerminationsConfigurationProvider());
                serviceLocator.getTerminationsConfigurationHandler().handleConfiguration(this.$featuresResponse);
                TerminationsPluginDelegate.access$handleTerminationStateChanged(v0.this$0);
            }
        };
        this.operateOnExec(function02);
    }

    /*
     * WARNING - void declaration
     */
    private final void operateOnExec(Function0<Unit> operation) {
        void var1_1;
        ServiceLocator.INSTANCE.getOrderedExecutor().execute("trm-lifecycle-ops-exec", () -> TerminationsPluginDelegate.operateOnExec$lambda$2((Function0)var1_1));
    }

    private final void subscribeToActivityLifecycleEvents() {
        this.lifecycleDisposable = ServiceLocator.INSTANCE.getCurrentActivityLifeCycleEventBus().subscribe(new Subscriber(this){
            final /* synthetic */ TerminationsPluginDelegate $tmp0;
            {
                void var1_1;
                this.$tmp0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final void onNewEvent(@NotNull ActivityLifeCycleEvent p0) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"p0");
                TerminationsPluginDelegate.access$onActivityEvent(this.$tmp0, (ActivityLifeCycleEvent)var1_1);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return new FunctionReferenceImpl(1, (Object)this.$tmp0, TerminationsPluginDelegate.class, "onActivityEvent", "onActivityEvent(Lcom/instabug/library/tracking/ActivityLifeCycleEvent;)V", 0);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean equals(@Nullable Object other) {
                void var1_1;
                return other instanceof Subscriber && var1_1 instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)var1_1).getFunctionDelegate()) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    private final void onActivityEvent(ActivityLifeCycleEvent event) {
        Function0<Unit> function0;
        Function0<Unit> function02;
        ExtensionsKt.logVerbose("Terminations received lifecycle event " + function02);
        if (event != ActivityLifeCycleEvent.STARTED) {
            return;
        }
        TerminationsPluginDelegate terminationsPluginDelegate = this;
        function02 = function0;
        function0 = new Function0<Unit>((Object)this){
            {
                void var1_1;
            }

            public static final /* synthetic */ Object access$getReceiver$p(onActivityEvent.1 $this) {
                return $this.receiver;
            }

            public final void invoke() {
                TerminationsPluginDelegate.access$migrateAndSync((TerminationsPluginDelegate)onActivityEvent.1.access$getReceiver$p(this));
            }
        };
        terminationsPluginDelegate.operateOnExec(function02);
        function02 = terminationsPluginDelegate.lifecycleDisposable;
        if (function02 != null) {
            function02.dispose();
        }
        this.lifecycleDisposable = null;
    }

    @WorkerThread
    private final void handleTerminationStateChanged() {
        ServiceLocator serviceLocator = ServiceLocator.INSTANCE;
        if (serviceLocator.getTerminationsConfigurationProvider().isEnabled() == this.isLastEnabled) {
            return;
        }
        if (serviceLocator.getTerminationsConfigurationProvider().isEnabled()) {
            TerminationsPluginDelegate terminationsPluginDelegate = this;
            terminationsPluginDelegate.isLastEnabled = true;
            ExtensionsKt.logVerbose("Terminations is enabled");
            terminationsPluginDelegate.createSessionWeakLink();
            terminationsPluginDelegate.startSnapshotCaptorsIfPossible();
            terminationsPluginDelegate.addMutualDirsWatcher();
            terminationsPluginDelegate.migrateAndSync();
            return;
        }
        ServiceLocator serviceLocator2 = serviceLocator;
        TerminationsPluginDelegate terminationsPluginDelegate = this;
        terminationsPluginDelegate.isLastEnabled = false;
        ExtensionsKt.logVerbose("Terminations is disabled, clearing..");
        terminationsPluginDelegate.validateCurrentSessionWeakLink();
        terminationsPluginDelegate.internalStop(true);
        serviceLocator2.getTerminationsCacheDir().deleteFileDir();
        Context context = serviceLocator2.getAppCtx();
        if (context != null) {
            serviceLocator.getCachingManager().clear(context);
        }
        this.removeMutualDirsWatcher();
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final void internalStop(boolean stopTrmCaptor) {
        void var1_1;
        TerminationsPluginDelegate terminationsPluginDelegate = this;
        terminationsPluginDelegate.stopSnapshotCaptors((boolean)var1_1);
        IBGDisposable iBGDisposable = terminationsPluginDelegate.lifecycleDisposable;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
        }
        this.lifecycleDisposable = null;
    }

    @WorkerThread
    private final void startSnapshotCaptorsIfPossible() {
        if (!this.isLastEnabled) {
            return;
        }
        CaptorsRegistry captorsRegistry2 = ServiceLocator.INSTANCE.getCaptorsRegistry();
        captorsRegistry2.start(2, StateSnapshotCaptor.Factory.invoke$default(null, null, null, null, 15, null));
        captorsRegistry2.start(2, AbstractTerminationSnapshotCaptor.Factory.invoke$default(AbstractTerminationSnapshotCaptor.Factory.INSTANCE, null, null, null, 7, null));
    }

    @WorkerThread
    private final void stopSnapshotCaptors(boolean stopTrmCaptor) {
        CaptorsRegistry captorsRegistry2 = ServiceLocator.INSTANCE.getCaptorsRegistry();
        captorsRegistry2.stop(2, 1);
        if (!stopTrmCaptor) {
            return;
        }
        captorsRegistry2.stop(2, 2);
    }

    @WorkerThread
    private final MigrationResult migrateAndSync() {
        MigrationResult migrationResult = ServiceLocator.INSTANCE.getTerminationsMigrator().invoke();
        ExtensionsKt.logVerbose("Trm migration result " + migrationResult);
        if (!(migrationResult instanceof MigrationResult.Migrated)) {
            migrationResult = null;
        }
        if (migrationResult != null) {
            TerminationsPluginDelegate terminationsPluginDelegate = this;
            terminationsPluginDelegate.consentOnMutualDirsCleansing();
            terminationsPluginDelegate.reportedDiagnosticsCapture(migrationResult);
            terminationsPluginDelegate.validateWeakLinks(migrationResult);
            terminationsPluginDelegate.notifyDataReadiness(migrationResult);
            terminationsPluginDelegate.startSyncingIfPossible();
        } else {
            migrationResult = MigrationResult.Failed.INSTANCE;
        }
        return migrationResult;
    }

    @WorkerThread
    private final void createSessionWeakLink() {
        TerminationsPluginDelegate terminationsPluginDelegate = InstabugCore.getRunningSession();
        if (terminationsPluginDelegate != null) {
            SessionLinker sessionLinker2 = ServiceLocator.INSTANCE.getSessionLinker();
            String string = terminationsPluginDelegate.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"session.id");
            sessionLinker2.weakLink(string, Incident.Type.Termination);
        }
    }

    @WorkerThread
    private final void validateCurrentSessionWeakLink() {
        TerminationsPluginDelegate terminationsPluginDelegate = InstabugCore.getRunningSession();
        if (terminationsPluginDelegate != null) {
            ServiceLocator.INSTANCE.getSessionLinker().validateWeakLink(terminationsPluginDelegate.getId(), null, Incident.Type.Termination);
        }
    }

    @WorkerThread
    private final void validateWeakLinks(MigrationResult result2) {
        Iterator iterator;
        if (!(result2 instanceof MigrationResult.Migrated)) {
            return;
        }
        Iterator iterator2 = (MigrationResult.Migrated)((Object)iterator);
        for (Termination termination : ((MigrationResult.Migrated)((Object)iterator2)).getIncidents()) {
            String string = termination.getSessionId();
            String string2 = termination.getMetadata().getUuid();
            Incident.Type type = termination.getType();
            ServiceLocator.INSTANCE.getSessionLinker().validateWeakLink(string, string2, type);
        }
        iterator2 = ((MigrationResult.Migrated)((Object)iterator2)).getMigratedSessions().iterator();
        while (iterator2.hasNext()) {
            ServiceLocator.INSTANCE.getSessionLinker().validateWeakLink((String)iterator2.next(), null, Incident.Type.Termination);
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final void notifyDataReadiness(MigrationResult result2) {
        void var1_1;
        if (!(result2 instanceof MigrationResult.Migrated)) {
            return;
        }
        Object object = ((MigrationResult.Migrated)var1_1).getIncidents().size();
        if (((Number)object).intValue() <= 0) {
            object = null;
        }
        if (object == null || (object = SessionBatchingFilterKt.getNoneFilter()) == null) {
            object = SessionBatchingFilterKt.getAllFilter();
        }
        InstabugCore.notifyV3SessionDataReadiness((SessionBatchingFilter)object);
    }

    @WorkerThread
    private final void reportedDiagnosticsCapture(MigrationResult result2) {
        ArrayList<CalibrationDiagnosticEvent> arrayList;
        Object object;
        if (!(result2 instanceof MigrationResult.Migrated)) {
            return;
        }
        Object object2 = ((MigrationResult.Migrated)object).getIncidents();
        object = arrayList;
        arrayList = new ArrayList<CalibrationDiagnosticEvent>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Termination cfr_ignored_0 = (Termination)object2.next();
            object.add(new CalibrationDiagnosticEvent(new TerminationIncidentType(), "captured"));
        }
        object2 = ServiceLocator.INSTANCE.getDiagnosticsReporter();
        object = object.iterator();
        while (object.hasNext()) {
            object2.report((DiagnosticEvent)object.next());
        }
    }

    private final void startSyncingIfPossible() {
        if (!this.isLastEnabled) {
            return;
        }
        ServiceLocator.INSTANCE.getSyncJob().start();
    }

    private final void addMutualDirsWatcher() {
        ServiceLocator serviceLocator = ServiceLocator.INSTANCE;
        serviceLocator.getCrashesCacheDir().addWatcher(2);
        serviceLocator.getReproScreenshotsCacheDir().addWatcher(2);
        serviceLocator.getHubDataWatcher().addWatcher(2);
    }

    private final void removeMutualDirsWatcher() {
        ServiceLocator serviceLocator = ServiceLocator.INSTANCE;
        serviceLocator.getCrashesCacheDir().removeWatcher(2);
        serviceLocator.getReproScreenshotsCacheDir().removeWatcher(2);
        serviceLocator.getHubDataWatcher().removeWatcher(2);
    }

    private final void consentOnMutualDirsCleansing() {
        ServiceLocator serviceLocator = ServiceLocator.INSTANCE;
        serviceLocator.getCrashesCacheDir().consentOnCleansing(2);
        serviceLocator.getReproScreenshotsCacheDir().consentOnCleansing(2);
        serviceLocator.getHubDataWatcher().consentOnCleansing(2);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleReproStateConfigurations(Map<Integer, Integer> modesMap) {
        void var1_1;
        TerminationsPluginDelegate terminationsPluginDelegate = this_;
        ServiceLocator this_ = ServiceLocator.INSTANCE;
        this_.getTerminationsConfigurationHandler().handle((Map)var1_1);
        terminationsPluginDelegate.getReproProxy().evaluate((ReproConfigurationsProvider)this_.getTerminationsConfigurationProvider());
    }

    private static final void start$lambda$1(TerminationsPluginDelegate this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SettingsManager settingsManager = SettingsManager.getInstance();
        if (settingsManager != null && (settingsManager = settingsManager.getReproConfigurations()) != null) {
            TerminationsPluginDelegate terminationsPluginDelegate;
            terminationsPluginDelegate.handleReproStateConfigurations(settingsManager.getModesMap());
        }
    }

    private static final void operateOnExec$lambda$2(Function0 $tmp0) {
        Function0 function0 = $tmp0;
        Intrinsics.checkNotNullParameter((Object)function0, (String)"$tmp0");
        function0.invoke();
    }

    public static final /* synthetic */ void access$startSnapshotCaptorsIfPossible(TerminationsPluginDelegate $this) {
        $this.startSnapshotCaptorsIfPossible();
    }

    public static final /* synthetic */ void access$createSessionWeakLink(TerminationsPluginDelegate $this) {
        $this.createSessionWeakLink();
    }

    public static final /* synthetic */ MigrationResult access$migrateAndSync(TerminationsPluginDelegate $this) {
        return $this.migrateAndSync();
    }

    public static final /* synthetic */ void access$subscribeToActivityLifecycleEvents(TerminationsPluginDelegate $this) {
        $this.subscribeToActivityLifecycleEvents();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$internalStop(TerminationsPluginDelegate $this, boolean stopTrmCaptor) {
        void var1_1;
        $this.internalStop((boolean)var1_1);
    }

    public static final /* synthetic */ void access$consentOnMutualDirsCleansing(TerminationsPluginDelegate $this) {
        $this.consentOnMutualDirsCleansing();
    }

    public static final /* synthetic */ void access$handleTerminationStateChanged(TerminationsPluginDelegate $this) {
        $this.handleTerminationStateChanged();
    }

    public static final /* synthetic */ ReproCapturingProxy access$getReproProxy(TerminationsPluginDelegate $this) {
        return $this.getReproProxy();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$onActivityEvent(TerminationsPluginDelegate $this, ActivityLifeCycleEvent event) {
        void var1_1;
        $this.onActivityEvent((ActivityLifeCycleEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@NotNull Context context) {
        void var1_1;
        TerminationsPluginDelegate terminationsPluginDelegate = this_;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        terminationsPluginDelegate.addMutualDirsWatcher();
        ServiceLocator this_ = ServiceLocator.INSTANCE;
        this_.getTerminationsConfigurationHandler().migrateCurrentConfiguration();
        terminationsPluginDelegate.getReproProxy().evaluate((ReproConfigurationsProvider)this_.getTerminationsConfigurationProvider());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start(@NotNull Context context) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        PoolProvider.postIOTaskWithCheck(() -> TerminationsPluginDelegate.start$lambda$1(this));
        this.isLastEnabled = ServiceLocator.INSTANCE.getTerminationsConfigurationProvider().isEnabled();
        if (!this.isLastEnabled) {
            this.removeMutualDirsWatcher();
        }
    }

    @Override
    public void wake() {
        Function0<Unit> function0;
        if (!this.isLastEnabled) {
            return;
        }
        Function0<Unit> function02 = function0;
        function0 = new Function0<Unit>(this){
            final /* synthetic */ TerminationsPluginDelegate this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final void invoke() {
                wake.1 v0 = this;
                TerminationsPluginDelegate.access$startSnapshotCaptorsIfPossible(v0.this$0);
                TerminationsPluginDelegate.access$createSessionWeakLink(v0.this$0);
                if (TerminationsPluginDelegate.access$migrateAndSync(v0.this$0) instanceof MigrationResult.Failed) {
                    ExtensionsKt.logVerbose("Terminations migration failed on wake, subscribing to lifecycle");
                    TerminationsPluginDelegate.access$subscribeToActivityLifecycleEvents(this.this$0);
                }
            }
        };
        this.operateOnExec(function02);
    }

    @Override
    public void sleep() {
        Function0<Unit> function0;
        Function0<Unit> function02 = function0;
        function0 = new Function0<Unit>(this){
            final /* synthetic */ TerminationsPluginDelegate this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final void invoke() {
                TerminationsPluginDelegate.access$internalStop(this.this$0, false);
            }
        };
        this.operateOnExec(function02);
    }

    @Override
    public void stop() {
        Function0<Unit> function0;
        Function0<Unit> function02 = function0;
        function0 = new Function0<Unit>(this){
            final /* synthetic */ TerminationsPluginDelegate this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final void invoke() {
                stop.1 v0 = this;
                TerminationsPluginDelegate.access$internalStop(v0.this$0, true);
                TerminationsPluginDelegate.access$consentOnMutualDirsCleansing(v0.this$0);
            }
        };
        this.operateOnExec(function02);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleSDKCoreEvent(@NotNull IBGSdkCoreEvent sdkCoreEvent) {
        void var1_1;
        IBGSdkCoreEvent iBGSdkCoreEvent = sdkCoreEvent;
        Intrinsics.checkNotNullParameter((Object)iBGSdkCoreEvent, (String)"sdkCoreEvent");
        if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.FeaturesFetched) {
            this.handleFeaturesFetched(((IBGSdkCoreEvent.FeaturesFetched)var1_1).getResponse());
        } else if (Intrinsics.areEqual((Object)var1_1, (Object)IBGSdkCoreEvent.NetworkActivated.INSTANCE)) {
            this.handleNetworkActivated();
        } else if (var1_1 instanceof IBGSdkCoreEvent.Features) {
            this.handleFeaturesFetchedEvent();
        } else if (var1_1 instanceof IBGSdkCoreEvent.ReproState) {
            this.handleReproStateConfigurations(((IBGSdkCoreEvent.ReproState)var1_1).getModesMap());
        }
    }
}

