/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.utils;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.WorkerThread;
import com.instabug.anr.cache.AnrReportsDbHelper;
import com.instabug.crash.cache.CrashReportsDbHelper;
import com.instabug.crash.models.Crash;
import com.instabug.library.Instabug;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.AttachmentsDbHelper;
import com.instabug.library.internal.storage.operation.DeleteUriDiskOperation;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.model.Attachment;
import com.instabug.library.util.FileUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public abstract class CrashCleanupUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public static synchronized void cleanStaleStateFiles() {
        List<String> list = FileUtils.getStateFiles((String)"files:crash_state:");
        if (!list.isEmpty()) {
            List<String> list2 = list;
            InstabugSDKLogger.v((String)"IBG-CR", (String)("Found " + list.size() + " stale crash state files on disk, cleaning ..."));
            list = CrashReportsDbHelper.getCrashesStateFiles();
            block2: for (File file : list2) {
                Exception exception2;
                block6: {
                    try {
                        Iterator<String> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            if (!iterator.next().contains(file.getName().substring(file.getName().indexOf("crash_state") + 12))) continue;
                            continue block2;
                        }
                    }
                    catch (Exception exception2) {
                        break block6;
                    }
                    if (file.delete()) {
                        InstabugSDKLogger.v((String)"IBG-CR", (String)("file " + file.getName() + " is deleted"));
                        continue;
                    }
                    InstabugSDKLogger.v((String)"IBG-CR", (String)("file " + file.getName() + " is not deleted"));
                    continue;
                }
                InstabugSDKLogger.e((String)"IBG-CR", (String)("Error: " + exception2.getMessage() + " while cleaning stale ANR state files"));
                IBGDiagnostics.reportNonFatal((Throwable)exception2, (String)"can't clean Stale Crashes State Files");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void cleanStaleANRStateFiles() {
        List<String> list = FileUtils.getStateFiles((String)"files:anr_state:");
        if (!list.isEmpty()) {
            List<String> list2 = list;
            InstabugSDKLogger.v((String)"IBG-CR", (String)("Found " + list.size() + " stale ANR state files on disk, cleaning ..."));
            list = AnrReportsDbHelper.getANRsStateFiles();
            block3: for (File file : list2) {
                try {
                    Iterator<String> iterator = list.iterator();
                    while (true) {
                        String string;
                        if (iterator.hasNext()) {
                            string = iterator.next();
                            if (string == null) continue;
                        } else {
                            if (file.delete()) {
                                InstabugSDKLogger.v((String)"IBG-CR", (String)("file " + file.getName() + " is deleted"));
                                continue block3;
                            }
                            InstabugSDKLogger.v((String)"IBG-CR", (String)("file " + file.getName() + " is not deleted"));
                            continue block3;
                        }
                        if (string.contains(file.getName().substring(file.getName().indexOf("anr_state") + 10))) break;
                    }
                    continue;
                }
                catch (Exception exception) {}
                InstabugSDKLogger.e((String)"IBG-CR", (String)("Error: " + exception.getMessage() + " while cleaning stale ANR state files"));
                IBGDiagnostics.reportNonFatal((Throwable)exception, (String)"can't clean Stale ANR State Files");
            }
        }
    }

    public static synchronized void deleteAllCrashesAsync() {
        PoolProvider.postIOTask(() -> {
            if (Instabug.getApplicationContext() != null) {
                List<String> list = CrashReportsDbHelper.retrieveIds();
                while (list.size() > 0) {
                    String string = list.get(0);
                    Crash crash = CrashReportsDbHelper.retrieveById(string, Instabug.getApplicationContext());
                    if (crash == null) {
                        InstabugSDKLogger.e((String)"IBG-CR", (String)("Something went wrong while retrieving crash " + string + " while deleting all crashes"));
                        list.remove(0);
                        continue;
                    }
                    if (crash.getState() != null && crash.getState().getUri() != null) {
                        CrashCleanupUtils.deleteCrashStateUriFile(crash.getState().getUri());
                    }
                    Crash crash2 = crash;
                    CrashCleanupUtils.deleteCrashAttachments(crash2);
                    if (crash2.getId() != null) {
                        CrashReportsDbHelper.delete(crash.getId());
                    }
                    list.remove(0);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public static synchronized void deleteCrashStateUriFile(Uri uri) {
        Context context = Instabug.getApplicationContext();
        if (context == null) return;
        try {
            Uri uri2;
            DiskUtils.with((Context)context).deleteOperation((DiskOperation)new DeleteUriDiskOperation(uri2)).execute();
            return;
        }
        catch (OutOfMemoryError throwable) {
        }
        catch (Exception throwable) {
            // empty catch block
        }
        IBGDiagnostics.reportNonFatal((Throwable)throwable, (String)"crash state file couldn't be removed");
    }

    @WorkerThread
    public static synchronized void deleteCrashAttachments(Crash crash) {
        for (Attachment attachment : crash.getAttachments()) {
            Crash crash2;
            if (attachment.getLocalPath() == null || attachment.getName() == null) continue;
            new File(attachment.getLocalPath()).delete();
            if (attachment.getId() != -1L) {
                AttachmentsDbHelper.delete((long)attachment.getId());
                continue;
            }
            if (crash2.getId() != null) {
                AttachmentsDbHelper.delete((String)attachment.getName(), (String)crash2.getId());
                continue;
            }
            InstabugSDKLogger.e((String)"CrashCleanupUtils", (String)"Couldn't delete attachments: crash.getId() is null");
        }
    }
}

