/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.network;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.commons.di.CommonsLocator;
import com.instabug.crash.models.Crash;
import com.instabug.crash.models.IBGNonFatalException;
import com.instabug.crash.utils.DeleteCrashUtilsKt;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.featuresflags.EnhancementRequestBodyParams;
import com.instabug.library.featuresflags.di.FeaturesFlagServiceLocator;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RateLimitedException;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.FileToUpload;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestExtKt;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashesService {
    @Nullable
    private static CrashesService INSTANCE;
    private final NetworkManager networkManager = NetworkManager.newInstance();

    private CrashesService() {
    }

    public static CrashesService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CrashesService();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateReportedAtIfNeeded(Request.Builder builder, Crash crash) {
        Exception exception2;
        block4: {
            RequestParameter requestParameter;
            String string;
            long l;
            CrashesService crashesService = crash.getState();
            if (crashesService != null && !crashesService.isMinimalState() && crashesService.getReportedAt() != 0L) {
                return;
            }
            try {
                void var2_2;
                l = var2_2.getId() != null ? Long.parseLong(var2_2.getId()) : 0L;
            }
            catch (Exception exception2) {
                break block4;
            }
            if (l == 0L) return;
            void v1 = string;
            crashesService = requestParameter;
            {
                string = "reported_at";
                requestParameter = new RequestParameter(string, (Object)l);
                v1.addParameter((RequestParameter)crashesService);
            }
            return;
        }
        IBGDiagnostics.reportNonFatal((Throwable)exception2, (String)"Failed to update reported_at in crash reporting request.");
    }

    /*
     * WARNING - void declaration
     */
    public void reportCrash(Crash crash, Request.Callbacks<String, Throwable> reportingCrashCallbacks) throws JSONException {
        void var2_2;
        void var1_1;
        this.reportCrash((Crash)var1_1, (Request.Callbacks<String, Throwable>)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public void reportCrash(Crash crash, Request.Callbacks<String, Throwable> reportingCrashCallbacks, boolean canWriteToCache) throws JSONException {
        void var3_3;
        void var2_2;
        Request.Callbacks<RequestResponse, Throwable> callbacks2;
        void var1_1;
        CrashesService crashesService = this;
        InstabugSDKLogger.d((String)"IBG-CR", (String)("Reporting crash with crash message: " + var1_1.getCrashMessage()));
        Request request = crashesService.buildCrashReportingRequest((Crash)var1_1);
        Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){
            final /* synthetic */ Request.Callbacks val$reportingCrashCallbacks;
            final /* synthetic */ boolean val$canWriteToCache;
            final /* synthetic */ Crash val$crash;
            final /* synthetic */ CrashesService this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$reportingCrashCallbacks = callbacks2;
                this.val$canWriteToCache = bl;
                this.val$crash = crash;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onSucceeded(RequestResponse requestResponse) {
                JSONException jSONException2;
                block3: {
                    void var1_1;
                    InstabugSDKLogger.d((String)"IBG-CR", (String)("reportingCrashRequest Succeeded, Response code: " + var1_1.getResponseCode()));
                    InstabugSDKLogger.v((String)"IBG-CR", (String)("reportingCrashRequest Succeeded, Response body: " + var1_1.getResponseBody()));
                    try {
                        if (requestResponse.getResponseBody() != null) {
                            this.val$reportingCrashCallbacks.onSucceeded((Object)new JSONObject((String)var1_1.getResponseBody()).getString("id"));
                            return;
                        }
                    }
                    catch (JSONException jSONException2) {
                        break block3;
                    }
                    this.val$reportingCrashCallbacks.onFailed((Object)new JSONException("requestResponse.getResponseBody() returned null"));
                    return;
                }
                jSONException2.printStackTrace();
                this.val$reportingCrashCallbacks.onFailed((Object)jSONException2);
            }

            /*
             * WARNING - void declaration
             */
            public void onFailed(Throwable error) {
                void var1_1;
                if (error instanceof RateLimitedException) {
                    this.val$reportingCrashCallbacks.onFailed((Object)var1_1);
                    return;
                }
                void v0 = var1_1;
                IBGDiagnostics.reportNonFatalAndLog((Throwable)v0, (String)("Reporting crash got error: " + var1_1.getMessage()), (String)"IBG-CR");
                InstabugSDKLogger.e((String)"CrashesService", (String)"reportingCrashRequest got error: ", (Throwable)var1_1);
                InstabugCore.reportError((Throwable)v0, (String)("Reporting crash got error: " + var1_1.getMessage()));
                if (this.val$canWriteToCache) {
                    AttachmentsUtility.encryptAttachmentsAndUpdateDb(this.val$crash.getAttachments());
                }
                this.val$reportingCrashCallbacks.onFailed((Object)var1_1);
            }
        };
        crashesService.networkManager.doRequestOnSameThread(1, request, (Request.Callbacks)callbacks3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @VisibleForTesting
    public Request buildCrashReportingRequest(Crash crash) throws JSONException {
        Object object3;
        Object object;
        void var1_1;
        String string = "/crashes";
        if (crash.isHandled()) {
            string = "/crashes/non_fatal";
        }
        string = new Request.Builder().endpoint(string).method("POST");
        RequestExtKt.getTokenFromState((Request.Builder)string, (State)var1_1.getState());
        if (var1_1.getMetadata().getUuid() != null) {
            string.addHeader(new RequestParameter("id", (Object)var1_1.getMetadata().getUuid()));
        }
        if ((object = var1_1.getState()) != null) {
            EnhancementRequestBodyParams enhancementRequestBodyParams;
            boolean bl = CommonsLocator.getConfigurationsProvider().getUserIdentificationEnabled();
            EnhancementRequestBodyParams enhancementRequestBodyParams2 = enhancementRequestBodyParams;
            enhancementRequestBodyParams2();
            object = enhancementRequestBodyParams.getModifiedStateItemsList(object.getStateItems(bl), FeaturesFlagServiceLocator.getFeaturesFlagsConfigsProvider().getMode()).entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry object2;
                Map.Entry entry = object2 = (Map.Entry)object.next();
                String jSONObject2 = (String)entry.getKey();
                string.addParameter(new RequestParameter(jSONObject2, entry.getValue()));
            }
        }
        ((CrashesService)object3).updateReportedAtIfNeeded((Request.Builder)string, (Crash)var1_1);
        object3 = var1_1.getCrashMessage();
        if (object3 != null) {
            RequestParameter requestParameter;
            object = requestParameter;
            requestParameter = new RequestParameter("title", object3);
            string.addParameter((RequestParameter)object);
        }
        string.addParameter(new RequestParameter("handled", (Object)var1_1.isHandled()));
        object3 = var1_1.getThreadsDetails();
        if (object3 != null) {
            RequestParameter requestParameter;
            object = requestParameter;
            requestParameter = new RequestParameter("threads_details", object3);
            string.addParameter((RequestParameter)object);
        }
        if ((object3 = var1_1.getFingerprint()) != null) {
            JSONObject jSONObject;
            RequestParameter requestParameter;
            object = requestParameter;
            JSONObject jSONObject2 = jSONObject;
            jSONObject = new JSONObject((String)object3);
            requestParameter = new RequestParameter("grouping_string", (Object)jSONObject2);
            string.addParameter((RequestParameter)object);
        }
        if ((object3 = var1_1.getLevel()) != null) {
            string.addParameter(new RequestParameter("level", (Object)((IBGNonFatalException.Level)((Object)object3)).getSeverity()));
        }
        if ((object3 = var1_1.getMetadata().getUuid()) != null) {
            RequestParameter requestParameter;
            object = requestParameter;
            requestParameter = new RequestParameter("id", object3);
            string.addParameter((RequestParameter)object);
        }
        if (var1_1.getAttachments() != null && var1_1.getAttachments().size() > 0) {
            string.addParameter(new RequestParameter("attachments_count", (Object)var1_1.getAttachments().size()));
        }
        return string.build();
    }

    /*
     * WARNING - void declaration
     */
    public void uploadCrashAttachments(Crash crash, Request.Callbacks<Boolean, Crash> uploadCrashAttachmentsCallbacks) throws JSONException {
        void var1_1;
        void var2_2;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        if (crash.getAttachments().size() == 0) {
            var2_2.onSucceeded((Object)Boolean.TRUE);
            return;
        }
        for (int i = 0; i < var1_1.getAttachments().size(); ++i) {
            Attachment attachment = var1_1.getAttachments().get(i);
            if (AttachmentsUtility.decryptAttachmentAndUpdateDb((Attachment)attachment)) {
                Request request = this.buildCrashSingleAttachmentRequest((Crash)var1_1, attachment);
                if (attachment.getLocalPath() != null) {
                    File file;
                    Object object = file;
                    if (new File(attachment.getLocalPath()).exists() && ((File)object).length() > 0L) {
                        Request.Callbacks<RequestResponse, Throwable> callbacks2;
                        attachment.setAttachmentState(Attachment.AttachmentState.SYNCED);
                        object = callbacks2;
                        callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){
                            final /* synthetic */ Attachment val$attachment;
                            final /* synthetic */ Crash val$crash;
                            final /* synthetic */ List val$synced;
                            final /* synthetic */ Request.Callbacks val$uploadCrashAttachmentsCallbacks;
                            final /* synthetic */ CrashesService this$0;
                            {
                                void var1_1;
                                this.this$0 = var1_1;
                                this.val$attachment = attachment;
                                this.val$crash = crash;
                                this.val$synced = list;
                                this.val$uploadCrashAttachmentsCallbacks = callbacks2;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void onSucceeded(RequestResponse requestResponse) {
                                void var1_1;
                                InstabugSDKLogger.d((String)"IBG-CR", (String)("uploadingCrashAttachmentRequest succeeded, Response code:" + var1_1.getResponseCode()));
                                InstabugSDKLogger.v((String)"IBG-CR", (String)("uploadingCrashAttachmentRequest succeeded, Response body:" + var1_1.getResponseBody()));
                                if (this.val$attachment.getLocalPath() != null) {
                                    2 v0 = this;
                                    DeleteCrashUtilsKt.deleteAttachment(v0.val$attachment, this.val$crash.getId());
                                    v0.val$synced.add(this.val$attachment);
                                }
                                if (this.val$synced.size() == this.val$crash.getAttachments().size()) {
                                    this.val$uploadCrashAttachmentsCallbacks.onSucceeded((Object)Boolean.TRUE);
                                }
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void onFailed(Throwable error) {
                                void var1_1;
                                InstabugSDKLogger.e((String)"IBG-CR", (String)("uploadingCrashAttachmentRequest got error: " + var1_1.getMessage()));
                                this.val$uploadCrashAttachmentsCallbacks.onFailed((Object)this.val$crash);
                            }
                        };
                        this.networkManager.doRequestOnSameThread(2, request, (Request.Callbacks)object);
                        continue;
                    }
                    InstabugSDKLogger.w((String)"IBG-CR", (String)("Skipping attachment file of type " + attachment.getType() + " because it's either not found or empty file"));
                    continue;
                }
                InstabugSDKLogger.w((String)"IBG-CR", (String)("Skipping attachment file of type " + attachment.getType() + " because it's either not found or empty file"));
                continue;
            }
            InstabugSDKLogger.w((String)"IBG-CR", (String)("Skipping attachment file of type " + attachment.getType() + " because it was not decrypted successfully"));
        }
    }

    @NonNull
    @VisibleForTesting
    public Request buildCrashSingleAttachmentRequest(Crash crash, Attachment attachment) throws JSONException {
        String string;
        String string2;
        CrashesService crashesService = new Request.Builder().method("POST").type(2);
        RequestExtKt.getTokenFromState((Request.Builder)crashesService, (State)((Crash)((Object)string2)).getState());
        if (crash.getTemporaryServerToken() != null) {
            string2 = ((Crash)((Object)string2)).getTemporaryServerToken();
            crashesService.endpoint("/crashes/:crash_token/attachments".replaceAll(":crash_token", string2));
        }
        if (string.getType() != null) {
            RequestParameter requestParameter;
            string2 = requestParameter;
            requestParameter = new RequestParameter("metadata[file_type]", (Object)string.getType());
            crashesService.addParameter((RequestParameter)string2);
        }
        if (string.getType() == Attachment.Type.AUDIO && string.getDuration() != null) {
            RequestParameter requestParameter;
            string2 = requestParameter;
            requestParameter = new RequestParameter("metadata[duration]", (Object)string.getDuration());
            crashesService.addParameter((RequestParameter)string2);
        }
        if (string.getName() != null && string.getLocalPath() != null) {
            FileToUpload fileToUpload;
            string2 = fileToUpload;
            void v3 = string;
            string = v3.getName();
            String string3 = v3.getLocalPath();
            String string4 = v3.getFileType();
            fileToUpload = new FileToUpload("file", string, string3, string4);
            crashesService.fileToUpload((FileToUpload)string2);
        }
        return crashesService.build();
    }

    /*
     * WARNING - void declaration
     */
    public void uploadCrashLogs(Crash crash, Request.Callbacks<Boolean, Crash> callbacks2) {
        void var2_3;
        Request.Callbacks<RequestResponse, Throwable> callbacks3;
        void var1_2;
        CrashesService crashesService = this;
        InstabugSDKLogger.d((String)"IBG-CR", (String)("START uploading all logs related to this crash id = " + var1_2.getId()));
        Object object = crashesService.buildCrashLogsRequest((Crash)var1_2);
        NetworkManager networkManager2 = crashesService.networkManager;
        Request request = object;
        object = callbacks3;
        try {
            callbacks3 = new Request.Callbacks<RequestResponse, Throwable>(){
                final /* synthetic */ Request.Callbacks val$callbacks;
                final /* synthetic */ Crash val$crash;
                final /* synthetic */ CrashesService this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$callbacks = callbacks2;
                    this.val$crash = crash;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onSucceeded(RequestResponse requestResponse) {
                    void var1_1;
                    InstabugSDKLogger.d((String)"IBG-CR", (String)("Uploading crash logs succeeded, Response code: " + var1_1.getResponseCode()));
                    InstabugSDKLogger.v((String)"IBG-CR", (String)("uploading crash logs onNext, Response body: " + var1_1.getResponseBody()));
                    this.val$callbacks.onSucceeded((Object)Boolean.TRUE);
                }

                /*
                 * WARNING - void declaration
                 */
                public void onFailed(Throwable error) {
                    void var1_1;
                    InstabugSDKLogger.e((String)"IBG-CR", (String)("uploading crash logs got error: " + var1_1.getMessage()));
                    this.val$callbacks.onFailed((Object)this.val$crash);
                }
            };
            networkManager2.doRequestOnSameThread(1, request, (Request.Callbacks)object);
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)("uploading crash logs got Json error: " + jSONException.getMessage()));
            var2_3.onFailed((Object)var1_2);
        }
    }

    @NonNull
    @VisibleForTesting
    public Request buildCrashLogsRequest(Crash crash) throws JSONException {
        Object object;
        Request.Builder builder;
        CrashesService crashesService = builder;
        builder = new Request.Builder();
        Object object2 = "/crashes/:crash_token/state_logs";
        String string = ":crash_token";
        String string2 = crash.getTemporaryServerToken() != null ? ((Crash)object).getTemporaryServerToken() : "";
        crashesService = crashesService.endpoint(((String)object2).replaceAll(string, string2)).method("POST");
        RequestExtKt.getTokenFromState((Request.Builder)crashesService, (State)((Crash)object).getState());
        object = ((Crash)object).getState();
        if (object != null && (object = object.getLogsItems()) != null && ((ArrayList)object).size() > 0) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                object2 = (State.StateItem)object.next();
                if (object2.getKey() == null) continue;
                String string3 = object2;
                string2 = string3.getKey();
                object2 = string3.getValue() != null ? object2.getValue() : "";
                string = new RequestParameter(string2, object2);
                crashesService.addParameter((RequestParameter)string);
            }
        }
        return crashesService.build();
    }
}

