package com.instabug.commons.utils

import android.content.SharedPreferences

object SharedPreferencesUtils {

    fun readBoolean(key: String, defValue: Boolean, preferences: SharedPreferences?): Boolean =
        preferences?.getBoolean(key, defValue) ?: defValue

    fun writeBoolean(key: String, value: Boolean, preferences: SharedPreferences?) {
        preferences?.edit()?.run {
            putBoolean(key, value)
            apply()
        }
    }

    fun readLong(key: String, defValue: Long, preferences: SharedPreferences?): Long =
        preferences?.getLong(key, defValue) ?: defValue

    fun readFloat(key: String, defValue: Float, preferences: SharedPreferences?): Float =
        preferences?.getFloat(key, defValue) ?: defValue
}