package com.instabug.commons.diagnostics.configurations

import com.instabug.commons.diagnostics.DiagnosticsConstants
import com.instabug.commons.preferences.crashPref
import com.instabug.crash.utils.CrashReportingUtility
import com.instabug.library.Instabug

class DefaultDiagnosticsConfigProvider : DiagnosticsConfigProvider {
    override var isDiagnosticsAvailable: Boolean
            by crashPref(DiagnosticsConstants.Preferences.CRASH_DIAGNOSTICS_AVAILABILITY)

    override val isDiagnosticsEnabled: Boolean
        get() = Instabug.isEnabled()
                && CrashReportingUtility.isCrashReportingEnabled()
                && isDiagnosticsAvailable
}