package com.instabug.anr.configuration

import com.instabug.library.visualusersteps.ReproConfigurationsProvider

interface AnrConfigurationProvider: ReproConfigurationsProvider {

    /**
     * References local state of ANR detection
     */
    var anrLocallyEnabled: Boolean

    /**
     * References the availability of ANR detection feature
     */
    var isAnrAvailable: Boolean

    /**
     * Gets the currents state of ANR detection
     * @return true if isAnrAvailable = true, anrLocallyEnabled = true and crash reporting is enabled
     * False otherwise
     */
    fun isAnrEnabled(): Boolean

    /*
    * Gets last migration time in Millis
    * the default value is 0
    * */
    var lastEarlyAnrMigrationMillis: Long

    /**
     * References the availability of ANR v2 detection feature
     */
    var isAnrV2Available: Boolean

    /**
     * Gets the currents state of ANR v2 detection
     * @return true if isAnrV2Available=true, isAnrAvailable = true, anrLocallyEnabled = true and crash reporting is enabled
     * False otherwise
     */
    val isAnrV2Enabled: Boolean
}
