/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.terminations.sync;

import android.annotation.SuppressLint;
import com.instabug.commons.di.CommonsLocator;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.featuresflags.EnhancementRequestBodyParams;
import com.instabug.library.featuresflags.di.FeaturesFlagServiceLocator;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.networkv2.request.FileToUpload;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestExtKt;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.terminations.di.ServiceLocator;
import com.instabug.terminations.model.Termination;
import com.instabug.terminations.sync.TerminationRequestBuilderKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lcom/instabug/terminations/sync/TerminationRequestBuilder;", "", "()V", "reportRequest", "Lcom/instabug/library/networkv2/request/Request;", "termination", "Lcom/instabug/terminations/model/Termination;", "singleAttachmentRequest", "attachment", "Lcom/instabug/library/model/Attachment;", "updateReportedAtIfNeeded", "", "builder", "Lcom/instabug/library/networkv2/request/Request$Builder;", "uploadLogsRequest", "instabug-crash_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nTerminationRequestBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminationRequestBuilder.kt\ncom/instabug/terminations/sync/TerminationRequestBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1#2:141\n819#3:142\n847#3,2:143\n1855#3,2:145\n*S KotlinDebug\n*F\n+ 1 TerminationRequestBuilder.kt\ncom/instabug/terminations/sync/TerminationRequestBuilder\n*L\n110#1:142\n110#1:143,2\n111#1:145,2\n*E\n"})
public final class TerminationRequestBuilder {
    /*
     * WARNING - void declaration
     */
    private final void updateReportedAtIfNeeded(Request.Builder builder, Termination termination) {
        void var1_1;
        Object object = termination.getState();
        if (object != null && !object.isMinimalState() && object.getReportedAt() != 0L) {
            return;
        }
        void v0 = var1_1;
        try {
            void var2_2;
            object = Result.constructor-impl((Object)v0.addParameter(new RequestParameter("reported_at", (Object)var2_2.getId())));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object = Result.exceptionOrNull-impl((Object)object);
        if (object != null) {
            IBGDiagnostics.reportNonFatal((Throwable)object, (String)"Failed to update reported_at in termination reporting request.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"WrongConstant"})
    @NotNull
    public final Request reportRequest(@NotNull Termination termination) {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        TerminationRequestBuilder terminationRequestBuilder;
        EnhancementRequestBodyParams enhancementRequestBodyParams;
        Object object;
        void var1_1;
        Termination termination2 = termination;
        Intrinsics.checkNotNullParameter((Object)termination2, (String)"termination");
        Request.Builder builder = new Request.Builder().endpoint("/crashes/android_user_termination").method("POST");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder()\n            .e\u2026ethod(RequestMethod.POST)");
        Request.Builder builder2 = RequestExtKt.getTokenFromState((Request.Builder)builder, (State)var1_1.getState());
        String string = termination2.getMetadata().getUuid();
        if (string != null) {
            RequestParameter requestParameter;
            RequestParameter requestParameter2;
            Request.Builder builder3 = builder2;
            object = requestParameter2;
            requestParameter2 = new RequestParameter("id", (Object)string);
            builder3.addHeader(object);
            object = requestParameter;
            requestParameter = new RequestParameter("id", (Object)string);
            builder3.addParameter(object);
        }
        boolean bl = CommonsLocator.getConfigurationsProvider().getUserIdentificationEnabled();
        object = enhancementRequestBodyParams;
        enhancementRequestBodyParams = new EnhancementRequestBodyParams();
        Object object2 = var1_1.getState();
        List list = object2 != null ? object2.getStateItems(bl) : null;
        Map map2 = MapsKt.toMutableMap((Map)object.getModifiedStateItemsList(list, FeaturesFlagServiceLocator.getFeaturesFlagsConfigsProvider().getMode()));
        map2.remove("current_activity");
        for (Map.Entry entry : map2.entrySet()) {
            RequestParameter requestParameter;
            object = (String)entry.getKey();
            object2 = entry.getValue();
            if (object2 == null) continue;
            RequestParameter requestParameter3 = requestParameter;
            requestParameter = new RequestParameter((String)object, object2);
            builder2.addParameter(requestParameter3);
        }
        Request.Builder builder4 = builder2;
        terminationRequestBuilder.updateReportedAtIfNeeded(builder2, (Termination)var1_1);
        terminationRequestBuilder = jSONObject2;
        jSONObject2 = new JSONObject();
        builder2 = jSONObject;
        new JSONObject().put("name", (Object)"User Termination");
        long l = ServiceLocator.INSTANCE.getTerminationsConfigurationProvider().getThreshold() / (long)1000;
        StringBuilder stringBuilder = new StringBuilder().append("User Termination: ");
        Object object3 = l;
        String string2 = String.format("The user terminated the app then relaunched it within %d seconds", Arrays.copyOf(new Object[]{object3}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        builder2.put("exception", (Object)stringBuilder.append(string2).toString());
        object3 = l;
        object3 = String.format("The user terminated the app then relaunched it within %d seconds", Arrays.copyOf(new Object[]{object3}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"format(this, *args)");
        builder2.put("message", object3);
        builder2.put("stackTrace", (Object)"");
        jSONObject2.put("error", (Object)builder2);
        builder4.addParameter(new RequestParameter("title", (Object)terminationRequestBuilder.toString()));
        builder4.addParameter(new RequestParameter("attachments_count", (Object)var1_1.getAttachments().size()));
        Request request = builder4.build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"builder.build()");
        return request;
    }

    @NotNull
    public final Request uploadLogsRequest(@NotNull Termination termination) {
        Object object;
        Request.Builder builder;
        Termination termination2 = termination;
        Intrinsics.checkNotNullParameter((Object)termination2, (String)"termination");
        TerminationRequestBuilder terminationRequestBuilder = builder;
        builder = new Request.Builder();
        Object object2 = termination2.getTemporaryServerToken();
        object2 = object2 != null ? new Regex(":crash_token").replace((CharSequence)"/crashes/:crash_token/state_logs", (String)object2) : null;
        Request.Builder builder2 = terminationRequestBuilder.endpoint((String)object2).method("POST");
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"Builder()\n            .e\u2026ethod(RequestMethod.POST)");
        terminationRequestBuilder = RequestExtKt.getTokenFromState((Request.Builder)builder2, (State)((Termination)object).getState());
        object = ((Termination)object).getState();
        if (object != null && (object = object.getLogsItems()) != null) {
            Object object3;
            ArrayList arrayList;
            Object object4 = object;
            object = arrayList;
            arrayList = new ArrayList();
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object3 = object2.next();
                if (((State.StateItem)object3).getKey() == null) continue;
                object.add(object3);
            }
            object = object.iterator();
            while (object.hasNext()) {
                State.StateItem stateItem = (State.StateItem)object.next();
                Intrinsics.checkNotNullExpressionValue((Object)stateItem, (String)"(key, value)");
                object2 = TerminationRequestBuilderKt.access$component1(stateItem);
                object3 = TerminationRequestBuilderKt.access$component2(stateItem);
                if (object3 == null) {
                    object3 = "";
                }
                RequestParameter requestParameter = new RequestParameter((String)object2, object3);
                terminationRequestBuilder.addParameter(requestParameter);
            }
        }
        Request request = terminationRequestBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"builder.build()");
        return request;
    }

    @Nullable
    public final Request singleAttachmentRequest(@NotNull Termination termination, @NotNull Attachment attachment) {
        Request request;
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"termination");
        Intrinsics.checkNotNullParameter((Object)string, (String)"attachment");
        Object object2 = termination.getTemporaryServerToken();
        if (object2 != null) {
            Object object3;
            object2 = new Regex(":crash_token").replace((CharSequence)"/crashes/:crash_token/attachments", (String)object2);
            Request.Builder builder = new Request.Builder().endpoint((String)object2).method("POST").type(2);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder()\n              \u2026e(RequestType.MULTI_PART)");
            object2 = RequestExtKt.getTokenFromState((Request.Builder)builder, (State)object.getState());
            object = string.getType();
            if (object != null) {
                RequestParameter requestParameter;
                object3 = requestParameter;
                requestParameter = new RequestParameter("metadata[file_type]", object);
                object2.addParameter(object3);
            }
            if ((object = string.getDuration()) != null) {
                if (string.getType() != Attachment.Type.AUDIO) {
                    object = null;
                }
                if (object != null) {
                    RequestParameter requestParameter;
                    object3 = requestParameter;
                    requestParameter = new RequestParameter("metadata[duration]", object);
                    object2.addParameter(object3);
                }
            }
            object = string.getName();
            object3 = string.getLocalPath();
            if (object != null && object3 != null) {
                FileToUpload fileToUpload;
                FileToUpload fileToUpload2 = fileToUpload;
                string = string.getFileType();
                fileToUpload = new FileToUpload("file", (String)object, (String)object3, string);
                object2.fileToUpload(fileToUpload2);
            }
            request = object2.build();
        } else {
            request = null;
        }
        return request;
    }
}

