/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.network;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.commons.di.CommonsLocator;
import com.instabug.commons.diagnostics.di.DiagnosticsLocator;
import com.instabug.commons.diagnostics.event.CalibrationDiagnosticEvent;
import com.instabug.commons.utils.RateLimiterUtilsKt;
import com.instabug.crash.cache.CrashReportsDbHelper;
import com.instabug.crash.di.CrashesServiceLocator;
import com.instabug.crash.diagnostics.CrashIncidentType;
import com.instabug.crash.models.Crash;
import com.instabug.crash.network.CrashesService;
import com.instabug.crash.settings.CrashSettings;
import com.instabug.crash.utils.DeleteCrashUtilsKt;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugNetworkJob;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.cache.AttachmentsDbHelper;
import com.instabug.library.internal.video.InstabugVideoUtils;
import com.instabug.library.model.Attachment;
import com.instabug.library.networkv2.RateLimitedException;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;

public class InstabugCrashesUploaderJob
extends InstabugNetworkJob {
    @Nullable
    private static InstabugCrashesUploaderJob INSTANCE;

    private InstabugCrashesUploaderJob() {
    }

    public static synchronized InstabugCrashesUploaderJob getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstabugCrashesUploaderJob();
        }
        return INSTANCE;
    }

    private static void trimScreenRecordsIfAny(@NonNull Context context) throws IOException {
        if (!SettingsManager.getInstance().isAutoScreenRecordingEnabled()) {
            return;
        }
        int n = SettingsManager.getInstance().autoScreenRecordingMaxDuration();
        block0: for (String string : CrashReportsDbHelper.retrieveIds()) {
            Context context2;
            Crash crash = CrashReportsDbHelper.retrieveById(string, context2);
            if (crash == null) {
                InstabugSDKLogger.e((String)"IBG-CR", (String)("Something went wrong while retrieving crash " + string + " for screen records trimming"));
                continue;
            }
            if (crash.getCrashState() != Crash.CrashState.WAITING_FOR_SCREEN_RECORDING_TO_BE_TRIMMED) continue;
            Object object = crash.getAttachments().iterator();
            while (object.hasNext()) {
                ContentValues contentValues;
                Attachment attachment = object.next();
                if (attachment.isEncrypted()) {
                    Attachment attachment2 = attachment;
                    attachment2.setEncrypted(AttachmentsUtility.decryptAttachmentAndUpdateDb((Attachment)attachment2));
                }
                if (attachment.getType() == null || !attachment.getType().toString().equalsIgnoreCase(Attachment.Type.AUTO_SCREEN_RECORDING_VIDEO.toString()) || attachment.getLocalPath() == null) continue;
                object = InstabugVideoUtils.startTrim((File)new File(attachment.getLocalPath()), (File)AttachmentManager.getAutoScreenRecordingFile((Context)context2), (int)n);
                Uri uri = Uri.fromFile((File)object);
                if (uri.getLastPathSegment() != null) {
                    attachment.setName(uri.getLastPathSegment());
                }
                if (uri.getPath() != null) {
                    attachment.setLocalPath(uri.getPath());
                }
                Crash.CrashState crashState = Crash.CrashState.READY_TO_BE_SENT;
                crash.setCrashState(crashState);
                ContentValues contentValues2 = new ContentValues();
                contentValues2.put("crash_state", crashState.name());
                CrashReportsDbHelper.update(string, contentValues2);
                ContentValues contentValues3 = contentValues;
                contentValues3();
                contentValues.put("local_path", ((File)object).getPath());
                AttachmentsDbHelper.update((long)attachment.getId(), (ContentValues)contentValues3);
                continue block0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void uploadCrashes(@NonNull Context context) throws JSONException {
        List<String> list = CrashReportsDbHelper.retrieveIds();
        InstabugSDKLogger.d((String)"IBG-CR", (String)("Found " + list.size() + " crashes in cache"));
        for (String string : list) {
            Context context2;
            final Crash crash = CrashReportsDbHelper.retrieveById(string, context2);
            if (crash == null) {
                InstabugSDKLogger.e((String)"IBG-CR", (String)("Something went wrong retrieving crash with id " + string));
                continue;
            }
            if (((Object)((Object)crash.getCrashState())).equals((Object)Crash.CrashState.READY_TO_BE_SENT)) {
                Request.Callbacks<String, Throwable> callbacks2;
                if (CrashSettings.getInstance().isRateLimited()) {
                    InstabugCrashesUploaderJob.deleteCrash(context2, crash);
                    InstabugCrashesUploaderJob.logRateIsLimited();
                    continue;
                }
                if (InstabugCrashesUploaderJob.isCrashTypeNotEnabled(crash)) {
                    void var2_6;
                    InstabugCrashesUploaderJob.deleteCrash(context2, crash);
                    if (crash.isHandled()) {
                        String string2 = "handled";
                    } else {
                        String string3 = "unhandled";
                    }
                    InstabugSDKLogger.d((String)"IBG-CR", (String)("Cannot sync " + (String)var2_6 + " exception as the feature seems to be disabled"));
                    continue;
                }
                CrashSettings.getInstance().setLastRequestStartedAt(System.currentTimeMillis());
                InstabugSDKLogger.d((String)"IBG-CR", (String)("Uploading crash: " + crash.getId() + " is handled: " + crash.isHandled()));
                Request.Callbacks<String, Throwable> callbacks3 = callbacks2;
                callbacks2 = new Request.Callbacks<String, Throwable>(){

                    /*
                     * WARNING - void declaration
                     */
                    public void onSucceeded(@Nullable String crashID) {
                        void var1_1;
                        if (crashID == null) {
                            InstabugSDKLogger.v((String)"IBG-CR", (String)"Crash uploading response was null, aborting...");
                            return;
                        }
                        if (RateLimiterUtilsKt.hasRateLimitedPrefix((String)var1_1)) {
                            1 v0 = this;
                            InstabugCrashesUploaderJob.access$000(v0.crash, (String)var1_1);
                            InstabugCrashesUploaderJob.deleteCrash(v0.context2, crash);
                        } else {
                            ContentValues contentValues;
                            1 v1 = this;
                            InstabugCrashesUploaderJob.access$000(v1.crash, (String)var1_1);
                            ContentValues contentValues2 = contentValues;
                            new ContentValues().put("temporary_server_token", (String)var1_1);
                            contentValues2.put("crash_state", Crash.CrashState.LOGS_READY_TO_BE_UPLOADED.name());
                            CrashReportsDbHelper.update(v1.crash.getId(), contentValues2);
                            InstabugCrashesUploaderJob.access$100(v1.crash, context2);
                            InstabugCrashesUploaderJob.updateLastCrashTime();
                        }
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onFailed(Throwable throwable) {
                        if (throwable instanceof RateLimitedException) {
                            void var1_1;
                            1 v0 = crash2;
                            Crash crash2 = v0.crash;
                            InstabugCrashesUploaderJob.access$300((RateLimitedException)var1_1, crash2, v0.context2);
                        } else {
                            InstabugSDKLogger.d((String)"IBG-CR", (String)"Something went wrong while uploading crash");
                        }
                    }
                };
                CrashesService.getInstance().reportCrash(crash, callbacks3);
                continue;
            }
            if (((Object)((Object)crash.getCrashState())).equals((Object)Crash.CrashState.LOGS_READY_TO_BE_UPLOADED)) {
                InstabugSDKLogger.v((String)"IBG-CR", (String)("crash: " + crash.getId() + " already uploaded but has unsent logs, uploading now"));
                InstabugCrashesUploaderJob.uploadCrashLogs(crash, context2);
                continue;
            }
            if (!((Object)((Object)crash.getCrashState())).equals((Object)Crash.CrashState.ATTACHMENTS_READY_TO_BE_UPLOADED)) continue;
            InstabugSDKLogger.d((String)"IBG-CR", (String)("crash: " + crash.getId() + " already uploaded but has unsent attachments, uploading now"));
            InstabugCrashesUploaderJob.uploadAttachments(crash, context2);
        }
    }

    private static boolean isCrashTypeNotEnabled(Crash crash) {
        return crash.isHandled() && !CrashesServiceLocator.getCrashConfigurationProvider().isNonFatalReportingEnabled();
    }

    private static void onCrashSent(Crash crash) {
        Crash crash2;
        CommonsLocator.getCrashMetadataCallback().onCrashSent(CommonsLocator.getCrashMetadataMapper().toMetadata(crash2));
    }

    /*
     * WARNING - void declaration
     */
    private static void handleRateLimitedException(RateLimitedException exception, @NonNull Crash crash, Context context) {
        void var1_1;
        RateLimitedException rateLimitedException;
        CrashSettings.getInstance().setLimitedUntil(rateLimitedException.getPeriod());
        InstabugCrashesUploaderJob.logRateIsLimited();
        InstabugCrashesUploaderJob.deleteCrash(context, (Crash)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public static void deleteCrash(Context context, @NonNull Crash crash) {
        void var1_1;
        DeleteCrashUtilsKt.deleteCrash(context, (Crash)var1_1);
    }

    private static void logRateIsLimited() {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "Crashes";
        InstabugSDKLogger.d((String)"IBG-CR", (String)String.format("You've reached the maximum number of requests in %s. You can read more about our rate limiting policy at this link: https://docs.instabug.com/docs/rate-limits", objectArray2));
    }

    /*
     * WARNING - void declaration
     */
    private static void uploadCrashLogs(Crash crash, @NonNull Context context) {
        void var1_1;
        Crash crash2;
        Request.Callbacks<Boolean, Crash> callbacks2;
        Request.Callbacks<Boolean, Crash> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<Boolean, Crash>(){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            public void onSucceeded(@Nullable Boolean isSucceeded) {
                ContentValues contentValues;
                2 v0 = this;
                Object object = Crash.CrashState.ATTACHMENTS_READY_TO_BE_UPLOADED;
                v0.crash2.setCrashState((Crash.CrashState)((Object)object));
                ContentValues contentValues2 = contentValues;
                contentValues2();
                contentValues.put("crash_state", object.name());
                object = v0.crash2.getId();
                if (object != null) {
                    CrashReportsDbHelper.update((String)object, contentValues2);
                }
                try {
                    InstabugCrashesUploaderJob.access$400(crash2, this.val$context);
                }
                catch (JSONException jSONException) {}
            }

            public void onFailed(Crash failedCrash) {
            }
        };
        CrashesService.getInstance().uploadCrashLogs(crash2, callbacks3);
    }

    private static void uploadAttachments(Crash crash, @NonNull Context context) throws JSONException {
        Request.Callbacks<Boolean, Crash> callbacks2;
        Crash crash2;
        InstabugSDKLogger.d((String)"IBG-CR", (String)("Found " + crash2.getAttachments().size() + " attachments related to crash"));
        Request.Callbacks<Boolean, Crash> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<Boolean, Crash>(){

            public void onSucceeded(@Nullable Boolean isSucceeded) {
                InstabugSDKLogger.d((String)"IBG-CR", (String)"Crash attachments uploaded successfully");
                Context context = Instabug.getApplicationContext();
                if (context != null) {
                    DeleteCrashUtilsKt.deleteCrash(context, crash2);
                } else {
                    InstabugSDKLogger.v((String)"IBG-CR", (String)("unable to delete state file for crash with id: " + crash2.getId() + "due to null context reference"));
                }
                DiagnosticsLocator.getReporter().report(new CalibrationDiagnosticEvent(new CrashIncidentType(), "synced"));
                InstabugCrashesUploaderJob.updateLastCrashTime();
            }

            public void onFailed(Crash failedCrash) {
                InstabugSDKLogger.e((String)"IBG-CR", (String)"Something went wrong while uploading crash attachments");
            }
        };
        CrashesService.getInstance().uploadCrashAttachments(crash2, callbacks3);
    }

    private static void updateLastCrashTime() {
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        InstabugSDKLogger.v((String)"IBG-CR", (String)("Updating last_crash_time to " + calendar.getTime()));
        CrashSettings.getInstance().setLastCrashTime(calendar.getTime().getTime());
    }

    /*
     * WARNING - void declaration
     */
    private static void onCrashSentSetup(Crash crash, String crashID) {
        void var1_1;
        Crash crash2 = crash;
        CrashSettings.getInstance().setLastRequestStartedAt(0L);
        InstabugSDKLogger.d((String)"IBG-CR", (String)"crash uploaded successfully");
        crash2.setTemporaryServerToken((String)var1_1);
        crash2.setCrashState(Crash.CrashState.LOGS_READY_TO_BE_UPLOADED);
        InstabugCrashesUploaderJob.onCrashSent(crash2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Crash x0, String x1) {
        void var1_1;
        InstabugCrashesUploaderJob.onCrashSentSetup(x0, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(Crash x0, Context x1) {
        void var1_1;
        InstabugCrashesUploaderJob.uploadCrashLogs(x0, (Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(RateLimitedException x0, Crash x1, Context x2) {
        void var2_2;
        void var1_1;
        InstabugCrashesUploaderJob.handleRateLimitedException(x0, (Crash)var1_1, (Context)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(Crash x0, Context x1) throws JSONException {
        void var1_1;
        InstabugCrashesUploaderJob.uploadAttachments(x0, (Context)var1_1);
    }

    public void start() {
        this.enqueueJob("CRASH", () -> {
            if (Instabug.getApplicationContext() != null) {
                try {
                    InstabugCrashesUploaderJob.trimScreenRecordsIfAny(Instabug.getApplicationContext());
                    InstabugCrashesUploaderJob.uploadCrashes(Instabug.getApplicationContext());
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-CR", (String)("Error " + exception.getMessage() + "occurred while uploading crashes"), (Throwable)exception);
                }
            } else {
                InstabugSDKLogger.d((String)"IBG-CR", (String)"Context was null while uploading Crashes");
            }
        });
    }
}

