/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.instabug.commons.PluginDelegate;
import com.instabug.commons.configurations.ConfigurationsHandler;
import com.instabug.commons.di.CommonsLocator;
import com.instabug.crash.CrashPluginDelegate;
import com.instabug.crash.InstabugUncaughtExceptionHandler;
import com.instabug.crash.cache.CrashReportsDbHelper;
import com.instabug.crash.configurations.NonFatalsConfigurationProvider;
import com.instabug.crash.configurations.NonFatalsReproConfigurationHandler;
import com.instabug.crash.di.CrashesServiceLocator;
import com.instabug.crash.network.InstabugCrashesUploaderJob;
import com.instabug.crash.settings.CrashSettings;
import com.instabug.crash.settings.PersistableSettings;
import com.instabug.crash.utils.CrashCleanupUtils;
import com.instabug.crash.utils.CrashReportingUtility;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0003J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\u00020\u00162\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010$\u001a\u00020\u0016H\u0002J\b\u0010%\u001a\u00020\u0016H\u0016J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010'\u001a\u00020\u0016H\u0002J\b\u0010(\u001a\u00020\u0016H\u0003J\b\u0010)\u001a\u00020\u0016H\u0016J\b\u0010*\u001a\u00020\u0016H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006+"}, d2={"Lcom/instabug/crash/CrashPluginDelegate;", "Lcom/instabug/commons/PluginDelegate;", "()V", "context", "Landroid/content/Context;", "crashConfigurationHandler", "Lcom/instabug/commons/configurations/ConfigurationsHandler;", "getCrashConfigurationHandler", "()Lcom/instabug/commons/configurations/ConfigurationsHandler;", "crashConfigurationHandler$delegate", "Lkotlin/Lazy;", "nonFatalsConfigurationsProvider", "Lcom/instabug/crash/configurations/NonFatalsConfigurationProvider;", "getNonFatalsConfigurationsProvider", "()Lcom/instabug/crash/configurations/NonFatalsConfigurationProvider;", "nonFatalsConfigurationsProvider$delegate", "nonFatalsReproConfigurationsHandler", "Lcom/instabug/crash/configurations/NonFatalsReproConfigurationHandler;", "getNonFatalsReproConfigurationsHandler", "()Lcom/instabug/crash/configurations/NonFatalsReproConfigurationHandler;", "nonFatalsReproConfigurationsHandler$delegate", "checkEncryptorVersion", "", "clearOldCrashesIfNeeded", "clearUserActivities", "handleFeaturesFetched", "featuresResponse", "", "handleReproStateConfigurations", "modesMap", "", "", "handleSDKCoreEvent", "sdkCoreEvent", "Lcom/instabug/library/core/eventbus/coreeventbus/IBGSdkCoreEvent;", "init", "setExceptionHandler", "sleep", "start", "startCrashesUploaderService", "startUploaderServices", "stop", "wake", "instabug-crash_defaultUiRelease"})
public final class CrashPluginDelegate
implements PluginDelegate {
    @Nullable
    private Context context;
    @NotNull
    private final Lazy crashConfigurationHandler$delegate = LazyKt.lazy((Function0)crashConfigurationHandler.2.INSTANCE);
    @NotNull
    private final Lazy nonFatalsConfigurationsProvider$delegate = LazyKt.lazy((Function0)nonFatalsConfigurationsProvider.2.INSTANCE);
    @NotNull
    private final Lazy nonFatalsReproConfigurationsHandler$delegate = LazyKt.lazy((Function0)nonFatalsReproConfigurationsHandler.2.INSTANCE);

    private final ConfigurationsHandler getCrashConfigurationHandler() {
        return (ConfigurationsHandler)this.crashConfigurationHandler$delegate.getValue();
    }

    private final NonFatalsConfigurationProvider getNonFatalsConfigurationsProvider() {
        return (NonFatalsConfigurationProvider)this.nonFatalsConfigurationsProvider$delegate.getValue();
    }

    private final NonFatalsReproConfigurationHandler getNonFatalsReproConfigurationsHandler() {
        return (NonFatalsReproConfigurationHandler)this.nonFatalsReproConfigurationsHandler$delegate.getValue();
    }

    @WorkerThread
    private final void startUploaderServices() {
        if (CrashReportingUtility.isCrashReportingEnabled() && CrashReportsDbHelper.getCrashesCount() > 0) {
            InstabugCrashesUploaderJob.getInstance().start();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleFeaturesFetched(String featuresResponse) {
        void var1_1;
        this.getCrashConfigurationHandler().handleConfiguration((String)var1_1);
        CommonsLocator.INSTANCE.getReproProxy().evaluate((ReproConfigurationsProvider)CrashesServiceLocator.getNonFatalsConfigurationsProvider());
    }

    private final void clearOldCrashesIfNeeded(Context context) {
        if (!InstabugCore.isLastSDKStateEnabled((Context)context)) {
            CrashCleanupUtils.deleteAllCrashesAsync();
        }
    }

    private final void setExceptionHandler() {
        Boolean bl = InstabugUncaughtExceptionHandler.isRegistered;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"isRegistered");
        if (bl.booleanValue()) {
            return;
        }
        InstabugSDKLogger.d((String)"IBG-CR", (String)"setting Uncaught Exception Handler com.instabug.crash.InstabugUncaughtExceptionHandler");
        Thread.setDefaultUncaughtExceptionHandler(new InstabugUncaughtExceptionHandler(Instabug.getApplicationContext()));
    }

    @WorkerThread
    private final void checkEncryptorVersion() {
        InstabugSDKLogger.v((String)"IBG-CR", (String)"CrashPlugin checking EncryptorVersion");
        if (CrashSettings.getInstance().isFirstRunAfterEncryptorUpdate()) {
            InstabugSDKLogger.v((String)"IBG-CR", (String)"CrashPlugin checking EncryptorVersion > firstRunAfterEncryptorUpdate");
            CrashReportsDbHelper.deleteAll();
            CrashSettings.getInstance().setFirstRunAfterEncryptorUpdate(false);
        }
    }

    private final void clearUserActivities() {
        if (PersistableSettings.getInstance() == null) {
            return;
        }
        PersistableSettings.getInstance().setLastCrashTime(0L);
    }

    private final void startCrashesUploaderService() {
        if (this.context != null) {
            PoolProvider.postIOTask(CrashPluginDelegate::startCrashesUploaderService$lambda$2);
        } else {
            InstabugSDKLogger.v((String)"IBG-CR", (String)"Context is null.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleReproStateConfigurations(Map<Integer, Integer> modesMap) {
        void var1_1;
        this.getNonFatalsReproConfigurationsHandler().handle((Map<Integer, Integer>)var1_1);
        CommonsLocator.INSTANCE.getReproProxy().evaluate((ReproConfigurationsProvider)this.getNonFatalsConfigurationsProvider());
    }

    private static final void start$lambda$1(CrashPluginDelegate this$0) {
        CrashPluginDelegate crashPluginDelegate;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SettingsManager settingsManager = SettingsManager.getInstance();
        if (settingsManager != null && (settingsManager = settingsManager.getReproConfigurations()) != null) {
            crashPluginDelegate.handleReproStateConfigurations(settingsManager.getModesMap());
        }
        CrashPluginDelegate crashPluginDelegate2 = crashPluginDelegate;
        CrashSettings.init();
        crashPluginDelegate2.checkEncryptorVersion();
        crashPluginDelegate2.startUploaderServices();
    }

    private static final void startCrashesUploaderService$lambda$2() {
        CrashCleanupUtils.cleanStaleStateFiles();
        if (CrashReportsDbHelper.getCrashesCount() > 0) {
            CrashReportsDbHelper.trim();
            InstabugCrashesUploaderJob.getInstance().start();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@NotNull Context context) {
        void var1_1;
        CrashPluginDelegate crashPluginDelegate = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"context");
        this.context = v1;
        this.getCrashConfigurationHandler().migrateCurrentConfiguration();
        crashPluginDelegate.clearOldCrashesIfNeeded((Context)var1_1);
        crashPluginDelegate.setExceptionHandler();
        CommonsLocator.INSTANCE.getReproProxy().evaluate((ReproConfigurationsProvider)this.getNonFatalsConfigurationsProvider());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start(@NotNull Context context) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        InstabugUncaughtExceptionHandler.setEarlyCapturingMode(false);
        PoolProvider.postIOTaskWithCheck(() -> CrashPluginDelegate.start$lambda$1(this));
    }

    @Override
    public void wake() {
    }

    @Override
    public void sleep() {
    }

    @Override
    public void stop() {
        this.context = null;
        CrashSettings.release();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleSDKCoreEvent(@NotNull IBGSdkCoreEvent sdkCoreEvent) {
        void var1_1;
        IBGSdkCoreEvent iBGSdkCoreEvent = sdkCoreEvent;
        Intrinsics.checkNotNullParameter((Object)iBGSdkCoreEvent, (String)"sdkCoreEvent");
        if (Intrinsics.areEqual((Object)iBGSdkCoreEvent, (Object)IBGSdkCoreEvent.NetworkActivated.INSTANCE)) {
            if (CrashReportingUtility.isCrashReportingEnabled()) {
                this.startCrashesUploaderService();
            }
        } else if (Intrinsics.areEqual((Object)var1_1, (Object)IBGSdkCoreEvent.User.LoggedOut.INSTANCE)) {
            this.clearUserActivities();
        } else if (var1_1 instanceof IBGSdkCoreEvent.FeaturesFetched) {
            this.handleFeaturesFetched(((IBGSdkCoreEvent.FeaturesFetched)var1_1).getResponse());
        } else if (var1_1 instanceof IBGSdkCoreEvent.ReproState) {
            this.handleReproStateConfigurations(((IBGSdkCoreEvent.ReproState)var1_1).getModesMap());
        }
    }
}

