/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bganr;

import android.content.Context;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import com.instabug.anr.di.AnrServiceLocator;
import com.instabug.anr.model.Anr;
import com.instabug.bganr.BackgroundAnrCacheDir;
import com.instabug.bganr.BackgroundAnrLocator;
import com.instabug.bganr.BackgroundAnrPluginDelegate;
import com.instabug.bganr.MigrationResult;
import com.instabug.commons.PluginDelegate;
import com.instabug.commons.di.CommonsLocator;
import com.instabug.commons.logging.ExtensionsKt;
import com.instabug.commons.models.Incident;
import com.instabug.commons.session.SessionLinker;
import com.instabug.commons.snapshot.StateSnapshotCaptor;
import com.instabug.commons.utils.BuildHelpersKt;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.sessionV3.sync.SessionBatchingFilter;
import com.instabug.library.sessionV3.sync.SessionBatchingFilterKt;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u000f\u0010\f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0003J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001b\u001a\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0006H\u0003\u00a2\u0006\u0004\b\u001d\u0010\u0003J\u000f\u0010\u001e\u001a\u00020\u0006H\u0003\u00a2\u0006\u0004\b\u001e\u0010\u0003J\u000f\u0010\u001f\u001a\u00020\u0006H\u0003\u00a2\u0006\u0004\b\u001f\u0010\u0003J\u0017\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020\u0004H\u0003\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u0006H\u0003\u00a2\u0006\u0004\b$\u0010\u0003J\u000f\u0010%\u001a\u00020\u0006H\u0003\u00a2\u0006\u0004\b%\u0010\u0003J\u0017\u0010'\u001a\u00020\u00062\u0006\u0010&\u001a\u00020!H\u0003\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010)\u001a\u00020\u00062\u0006\u0010&\u001a\u00020!H\u0003\u00a2\u0006\u0004\b)\u0010(J\u000f\u0010*\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b*\u0010\u0003J\u000f\u0010+\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b+\u0010\u0003J\u000f\u0010,\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b,\u0010\u0003J\u000f\u0010-\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b-\u0010\u0003J#\u00101\u001a\u00020\u00062\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020/0.H\u0002\u00a2\u0006\u0004\b1\u00102R\u0016\u00103\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00065"}, d2={"Lcom/instabug/bganr/BackgroundAnrPluginDelegate;", "Lcom/instabug/commons/PluginDelegate;", "<init>", "()V", "Landroid/content/Context;", "context", "", "init", "(Landroid/content/Context;)V", "start", "wake", "sleep", "stop", "Lcom/instabug/library/core/eventbus/coreeventbus/IBGSdkCoreEvent;", "sdkCoreEvent", "handleSDKCoreEvent", "(Lcom/instabug/library/core/eventbus/coreeventbus/IBGSdkCoreEvent;)V", "", "isAnrV2OrBgAnrEnabled", "()Z", "createCurrentSessionBaseLine", "Ljava/io/File;", "currentSessionDir", "markCurrentSessionWithBaseline", "(Ljava/io/File;)V", "Lkotlin/Function0;", "operation", "operateOnExec", "(Lkotlin/jvm/functions/Function0;)V", "startSnapshotCaptorIfPossible", "stopSnapshotCaptor", "onFeatureStateChange", "ctx", "Lcom/instabug/bganr/MigrationResult;", "migrateAndSync", "(Landroid/content/Context;)Lcom/instabug/bganr/MigrationResult;", "createSessionWeakLink", "validateCurrentSessionWeakLink", "result", "validateWeakLinks", "(Lcom/instabug/bganr/MigrationResult;)V", "notifyDataReadiness", "startSyncingIfPossible", "addMutualDirsWatcher", "removeMutualDirsWatcher", "consentOnMutualDirsCleansing", "", "", "modesMap", "handleReproStateConfigurations", "(Ljava/util/Map;)V", "isLastEnabled", "Z", "instabug-crash_defaultUiRelease"}, xi=48)
@SourceDebugExtension(value={"SMAP\nBackgroundAnrPluginDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundAnrPluginDelegate.kt\ncom/instabug/bganr/BackgroundAnrPluginDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n1#2:280\n1855#3,2:281\n1549#3:283\n1620#3,3:284\n1855#3,2:287\n*S KotlinDebug\n*F\n+ 1 BackgroundAnrPluginDelegate.kt\ncom/instabug/bganr/BackgroundAnrPluginDelegate\n*L\n224#1:281,2\n227#1:283\n227#1:284,3\n228#1:287,2\n*E\n"})
public final class BackgroundAnrPluginDelegate
implements PluginDelegate {
    private boolean isLastEnabled = true;

    @Override
    public void init(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!BuildHelpersKt.isAtLeastRunningR()) {
            ExtensionsKt.logWarning("Instabug Background ANR is disabled because It's supported starting from Android 11.");
            return;
        }
        this.addMutualDirsWatcher();
    }

    @Override
    public void start(@NotNull Context context) {
        Function0<Unit> function0;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!BuildHelpersKt.isAtLeastRunningR()) {
            return;
        }
        Function0<Unit> function02 = function0;
        function0 = new Function0<Unit>(this){
            final /* synthetic */ BackgroundAnrPluginDelegate this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final void invoke() {
                Object object;
                start.1 v0 = this;
                BackgroundAnrPluginDelegate backgroundAnrPluginDelegate = v0.this$0;
                BackgroundAnrPluginDelegate.access$setLastEnabled$p(backgroundAnrPluginDelegate, BackgroundAnrPluginDelegate.access$isAnrV2OrBgAnrEnabled(backgroundAnrPluginDelegate));
                ExtensionsKt.logVerbose("ANRs-V2 -> Initial state = " + BackgroundAnrPluginDelegate.access$isLastEnabled$p(this.this$0));
                if (!BackgroundAnrPluginDelegate.access$isLastEnabled$p(v0.this$0)) {
                    BackgroundAnrPluginDelegate.access$removeMutualDirsWatcher(this.this$0);
                }
                if ((object = SettingsManager.getInstance()) != null && (object = object.getReproConfigurations()) != null) {
                    BackgroundAnrPluginDelegate.access$handleReproStateConfigurations(this.this$0, object.getModesMap());
                }
                if (!((BackgroundAnrLocator)(object = BackgroundAnrLocator.INSTANCE)).getConfigurationsProvider().isAvailable()) {
                    ExtensionsKt.logWarning("Background ANR wasn't enabled as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
                }
                if (((BackgroundAnrLocator)object).getConfigurationsProvider().isAnrV2Enabled() && (object = ((BackgroundAnrLocator)object).getAppCtx()) != null) {
                    BackgroundAnrPluginDelegate.access$migrateAndSync(this.this$0, (Context)object);
                }
            }
        };
        this.operateOnExec(function02);
    }

    @Override
    public void wake() {
        Function0<Unit> function0;
        if (!BuildHelpersKt.isAtLeastRunningR()) {
            return;
        }
        ExtensionsKt.logVerbose("ANRs-V2 -> Plugin is waking..");
        Function0<Unit> function02 = function0;
        function0 = new Function0<Unit>(this){
            final /* synthetic */ BackgroundAnrPluginDelegate this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final void invoke() {
                if (BackgroundAnrPluginDelegate.access$isLastEnabled$p(this.this$0)) {
                    wake.1 v0 = this;
                    BackgroundAnrPluginDelegate.access$createSessionWeakLink(v0.this$0);
                    BackgroundAnrPluginDelegate.access$startSnapshotCaptorIfPossible(v0.this$0);
                    BackgroundAnrPluginDelegate.access$createCurrentSessionBaseLine(v0.this$0);
                    Context context = BackgroundAnrLocator.INSTANCE.getAppCtx();
                    if (context != null) {
                        BackgroundAnrPluginDelegate.access$migrateAndSync(this.this$0, context);
                    }
                }
            }
        };
        this.operateOnExec(function02);
    }

    @Override
    public void sleep() {
    }

    @Override
    public void stop() {
        Function0<Unit> function0;
        if (!BuildHelpersKt.isAtLeastRunningR()) {
            return;
        }
        Function0<Unit> function02 = function0;
        function0 = new Function0<Unit>(this){
            final /* synthetic */ BackgroundAnrPluginDelegate this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final void invoke() {
                stop.1 v0 = this;
                BackgroundAnrPluginDelegate.access$stopSnapshotCaptor(v0.this$0);
                BackgroundAnrPluginDelegate.access$consentOnMutualDirsCleansing(v0.this$0);
            }
        };
        this.operateOnExec(function02);
    }

    @Override
    public void handleSDKCoreEvent(@NotNull IBGSdkCoreEvent sdkCoreEvent) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)sdkCoreEvent, (String)"sdkCoreEvent");
        if (!BuildHelpersKt.isAtLeastRunningR()) {
            return;
        }
        if (function0 instanceof IBGSdkCoreEvent.FeaturesFetched) {
            Function0<Unit> function02;
            ExtensionsKt.logVerbose("ANRs-V2 -> received features fetched");
            Function0<Unit> function03 = function02;
            function02 = new Function0<Unit>((IBGSdkCoreEvent)function0, this){
                final /* synthetic */ IBGSdkCoreEvent $sdkCoreEvent;
                final /* synthetic */ BackgroundAnrPluginDelegate this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.$sdkCoreEvent = var1_1;
                    this.this$0 = var2_2;
                    super(0);
                }

                public final void invoke() {
                    BackgroundAnrLocator.INSTANCE.getConfigurationsHandler().handleConfiguration(((IBGSdkCoreEvent.FeaturesFetched)this.$sdkCoreEvent).getResponse());
                    BackgroundAnrPluginDelegate.access$onFeatureStateChange(this.this$0);
                }
            };
            this.operateOnExec(function03);
        } else if (function0 instanceof IBGSdkCoreEvent.Features) {
            Function0<Unit> function04;
            ExtensionsKt.logVerbose("ANRs-V2 -> received features");
            function0 = function04;
            function04 = new Function0<Unit>((Object)this){
                {
                    void var1_1;
                }

                public final void invoke() {
                    BackgroundAnrPluginDelegate.access$onFeatureStateChange((BackgroundAnrPluginDelegate)this.receiver);
                }
            };
            this.operateOnExec((Function0<Unit>)function0);
        } else if (function0 instanceof IBGSdkCoreEvent.ReproState) {
            this.handleReproStateConfigurations(((IBGSdkCoreEvent.ReproState)function0).getModesMap());
        } else if (function0 instanceof IBGSdkCoreEvent.NetworkActivated) {
            Function0<Unit> function05;
            ExtensionsKt.logVerbose("ANRs-V2 -> received network activated");
            function0 = function05;
            function05 = new Function0<Unit>(this){
                final /* synthetic */ BackgroundAnrPluginDelegate this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    super(0);
                }

                public final void invoke() {
                    BackgroundAnrPluginDelegate.access$startSyncingIfPossible(this.this$0);
                }
            };
            this.operateOnExec((Function0<Unit>)function0);
        }
    }

    private final boolean isAnrV2OrBgAnrEnabled() {
        BackgroundAnrLocator backgroundAnrLocator = BackgroundAnrLocator.INSTANCE;
        return backgroundAnrLocator.getConfigurationsProvider().isEnabled() || backgroundAnrLocator.getConfigurationsProvider().isAnrV2Enabled();
    }

    private final void createCurrentSessionBaseLine() {
        File file = BackgroundAnrLocator.INSTANCE.getCrashesCacheDir().getCurrentSessionDirectory();
        StringBuilder stringBuilder = new StringBuilder().append("ANRs-V2 -> Current session id: ");
        String string = file != null ? file.getName() : null;
        ExtensionsKt.logVerbose(stringBuilder.append(string).toString());
        if (file != null) {
            this.markCurrentSessionWithBaseline(file);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void markCurrentSessionWithBaseline(File currentSessionDir) {
        block3: {
            Object object;
            try {
                // empty try
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                break block3;
            }
            {
                void var1_1;
                ExtensionsKt.logVerbose("ANRs-V2 -> Creating baseline file for session " + var1_1.getName());
                object = Result.constructor-impl((Object)BackgroundAnrCacheDir.Companion.createTraceBaselineFile((File)var1_1));
            }
        }
        ExtensionsKt.runOrReportError$default(object, "ANRs-V2 -> Couldn't create baseline file for current session.", false, 2, null);
    }

    private final void operateOnExec(Function0<Unit> operation) {
        PoolProvider.postOrderedIOTask((String)"bg-anr-op", () -> BackgroundAnrPluginDelegate.operateOnExec$lambda$2(operation));
    }

    @WorkerThread
    private final void startSnapshotCaptorIfPossible() {
        BackgroundAnrLocator.INSTANCE.getCaptorsRegistry().start(3, StateSnapshotCaptor.Factory.invoke$default(null, null, null, null, 15, null));
    }

    @WorkerThread
    private final void stopSnapshotCaptor() {
        BackgroundAnrLocator.INSTANCE.getCaptorsRegistry().stop(3, 1);
    }

    @RequiresApi(value=30)
    @WorkerThread
    private final void onFeatureStateChange() {
        if (((BackgroundAnrPluginDelegate)((Object)this_)).isAnrV2OrBgAnrEnabled() == ((BackgroundAnrPluginDelegate)((Object)this_)).isLastEnabled) {
            return;
        }
        if (((BackgroundAnrPluginDelegate)((Object)this_)).isAnrV2OrBgAnrEnabled()) {
            BackgroundAnrPluginDelegate backgroundAnrPluginDelegate = this_;
            backgroundAnrPluginDelegate.isLastEnabled = true;
            ExtensionsKt.logVerbose("ANRs-V2 -> enabled");
            backgroundAnrPluginDelegate.createSessionWeakLink();
            backgroundAnrPluginDelegate.startSnapshotCaptorIfPossible();
            backgroundAnrPluginDelegate.createCurrentSessionBaseLine();
            Context context = BackgroundAnrLocator.INSTANCE.getAppCtx();
            if (context != null) {
                super.migrateAndSync(context);
            }
            super.addMutualDirsWatcher();
            return;
        }
        BackgroundAnrPluginDelegate backgroundAnrPluginDelegate = this_;
        backgroundAnrPluginDelegate.isLastEnabled = false;
        ExtensionsKt.logVerbose("ANRs-V2 -> disabled");
        backgroundAnrPluginDelegate.validateCurrentSessionWeakLink();
        backgroundAnrPluginDelegate.stopSnapshotCaptor();
        BackgroundAnrLocator this_ = BackgroundAnrLocator.INSTANCE;
        this_.getBackgroundAnrCacheDir().deleteFileDir();
        backgroundAnrPluginDelegate.removeMutualDirsWatcher();
        if (!this_.getConfigurationsProvider().isAvailable()) {
            ExtensionsKt.logWarning("Background ANR wasn't enabled as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=30)
    @WorkerThread
    private final MigrationResult migrateAndSync(Context ctx) {
        void var1_1;
        MigrationResult migrationResult = BackgroundAnrLocator.INSTANCE.getMigrator().invoke((Context)var1_1);
        BackgroundAnrPluginDelegate backgroundAnrPluginDelegate = this;
        ExtensionsKt.logVerbose("ANRs-V2 -> migration result " + migrationResult);
        this.consentOnMutualDirsCleansing();
        this.validateWeakLinks(migrationResult);
        backgroundAnrPluginDelegate.notifyDataReadiness(migrationResult);
        AnrServiceLocator.INSTANCE.getEarlyAnrMigrator().invoke((Context)var1_1, migrationResult.getMigratedTimeStamps());
        backgroundAnrPluginDelegate.startSyncingIfPossible();
        return migrationResult;
    }

    @WorkerThread
    private final void createSessionWeakLink() {
        BackgroundAnrLocator backgroundAnrLocator;
        BackgroundAnrPluginDelegate backgroundAnrPluginDelegate;
        BackgroundAnrPluginDelegate backgroundAnrPluginDelegate2 = InstabugCore.getRunningSession();
        if (backgroundAnrPluginDelegate2 != null && (backgroundAnrPluginDelegate = (backgroundAnrLocator = BackgroundAnrLocator.INSTANCE).getConfigurationsProvider().isEnabled() ? backgroundAnrPluginDelegate2 : null) != null) {
            SessionLinker sessionLinker2 = backgroundAnrLocator.getSessionLinker();
            String string = backgroundAnrPluginDelegate.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"session.id");
            sessionLinker2.weakLink(string, Incident.Type.BG_ANR);
        }
        if (backgroundAnrPluginDelegate2 != null) {
            backgroundAnrLocator = BackgroundAnrLocator.INSTANCE;
            if (!backgroundAnrLocator.getConfigurationsProvider().isAnrV2Enabled()) {
                backgroundAnrPluginDelegate2 = null;
            }
            if (backgroundAnrPluginDelegate2 != null) {
                SessionLinker sessionLinker3 = backgroundAnrLocator.getSessionLinker();
                String string = backgroundAnrPluginDelegate2.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"session.id");
                sessionLinker3.weakLink(string, Incident.Type.ANR);
            }
        }
    }

    @WorkerThread
    private final void validateCurrentSessionWeakLink() {
        BackgroundAnrPluginDelegate backgroundAnrPluginDelegate = InstabugCore.getRunningSession();
        if (backgroundAnrPluginDelegate != null) {
            BackgroundAnrLocator.INSTANCE.getSessionLinker().validateWeakLink(backgroundAnrPluginDelegate.getId(), null, Incident.Type.BG_ANR);
        }
        if (backgroundAnrPluginDelegate != null) {
            BackgroundAnrLocator.INSTANCE.getSessionLinker().validateWeakLink(backgroundAnrPluginDelegate.getId(), null, Incident.Type.ANR);
        }
    }

    @WorkerThread
    private final void validateWeakLinks(MigrationResult result2) {
        ArrayList arrayList;
        String string3;
        Object object;
        for (Anr anr : result2.getIncidents()) {
            object = anr.getSessionId();
            String string2 = anr.getMetadata().getUuid();
            Incident.Type type = anr.getType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"anr.type");
            BackgroundAnrLocator.INSTANCE.getSessionLinker().validateWeakLink((String)object, string2, type);
        }
        Iterator iterator = ((MigrationResult)((Object)string3)).getIncidents();
        object = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterator, (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object.add(((Anr)iterator.next()).getSessionId());
        }
        iterator = CollectionsKt.toSet((Iterable)object);
        for (String string3 : CollectionsKt.minus(((MigrationResult)((Object)string3)).getMigratedSessions(), (Iterable)((Object)iterator))) {
            BackgroundAnrLocator backgroundAnrLocator = BackgroundAnrLocator.INSTANCE;
            backgroundAnrLocator.getSessionLinker().validateWeakLink(string3, null, Incident.Type.BG_ANR);
            backgroundAnrLocator.getSessionLinker().validateWeakLink(string3, null, Incident.Type.ANR);
        }
    }

    @WorkerThread
    private final void notifyDataReadiness(MigrationResult result2) {
        Object object = result2.getIncidents().size();
        if (((Number)object).intValue() <= 0) {
            object = null;
        }
        if (object == null || (object = SessionBatchingFilterKt.getNoneFilter()) == null) {
            object = SessionBatchingFilterKt.getAllFilter();
        }
        InstabugCore.notifyV3SessionDataReadiness((SessionBatchingFilter)object);
    }

    private final void startSyncingIfPossible() {
        if (!this.isLastEnabled) {
            return;
        }
        BackgroundAnrLocator.INSTANCE.getSyncJob().start();
    }

    private final void addMutualDirsWatcher() {
        BackgroundAnrLocator backgroundAnrLocator = BackgroundAnrLocator.INSTANCE;
        backgroundAnrLocator.getCrashesCacheDir().addWatcher(3);
        backgroundAnrLocator.getReproScreenshotsCacheDir().addWatcher(3);
        backgroundAnrLocator.getHubDataWatcher().addWatcher(3);
    }

    private final void removeMutualDirsWatcher() {
        BackgroundAnrLocator backgroundAnrLocator = BackgroundAnrLocator.INSTANCE;
        backgroundAnrLocator.getCrashesCacheDir().removeWatcher(3);
        backgroundAnrLocator.getReproScreenshotsCacheDir().removeWatcher(3);
        backgroundAnrLocator.getHubDataWatcher().removeWatcher(3);
    }

    private final void consentOnMutualDirsCleansing() {
        BackgroundAnrLocator backgroundAnrLocator = BackgroundAnrLocator.INSTANCE;
        backgroundAnrLocator.getCrashesCacheDir().consentOnCleansing(3);
        backgroundAnrLocator.getReproScreenshotsCacheDir().consentOnCleansing(3);
        backgroundAnrLocator.getHubDataWatcher().consentOnCleansing(3);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleReproStateConfigurations(Map<Integer, Integer> modesMap) {
        void var1_1;
        AnrServiceLocator.INSTANCE.getAnrConfigurationHandler().handle((Map)var1_1);
        CommonsLocator.INSTANCE.getReproProxy().evaluate((ReproConfigurationsProvider)AnrServiceLocator.getAnrConfigurationProvider());
    }

    private static final void operateOnExec$lambda$2(Function0 $tmp0) {
        Function0 function0 = $tmp0;
        Intrinsics.checkNotNullParameter((Object)function0, (String)"$tmp0");
        function0.invoke();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setLastEnabled$p(BackgroundAnrPluginDelegate $this, boolean bl) {
        void var1_1;
        $this.isLastEnabled = var1_1;
    }

    public static final /* synthetic */ boolean access$isAnrV2OrBgAnrEnabled(BackgroundAnrPluginDelegate $this) {
        return $this.isAnrV2OrBgAnrEnabled();
    }

    public static final /* synthetic */ boolean access$isLastEnabled$p(BackgroundAnrPluginDelegate $this) {
        return $this.isLastEnabled;
    }

    public static final /* synthetic */ void access$removeMutualDirsWatcher(BackgroundAnrPluginDelegate $this) {
        $this.removeMutualDirsWatcher();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$handleReproStateConfigurations(BackgroundAnrPluginDelegate $this, Map modesMap) {
        void var1_1;
        $this.handleReproStateConfigurations((Map<Integer, Integer>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ MigrationResult access$migrateAndSync(BackgroundAnrPluginDelegate $this, Context ctx) {
        void var1_1;
        return $this.migrateAndSync((Context)var1_1);
    }

    public static final /* synthetic */ void access$createSessionWeakLink(BackgroundAnrPluginDelegate $this) {
        $this.createSessionWeakLink();
    }

    public static final /* synthetic */ void access$startSnapshotCaptorIfPossible(BackgroundAnrPluginDelegate $this) {
        $this.startSnapshotCaptorIfPossible();
    }

    public static final /* synthetic */ void access$createCurrentSessionBaseLine(BackgroundAnrPluginDelegate $this) {
        $this.createCurrentSessionBaseLine();
    }

    public static final /* synthetic */ void access$stopSnapshotCaptor(BackgroundAnrPluginDelegate $this) {
        $this.stopSnapshotCaptor();
    }

    public static final /* synthetic */ void access$consentOnMutualDirsCleansing(BackgroundAnrPluginDelegate $this) {
        $this.consentOnMutualDirsCleansing();
    }

    public static final /* synthetic */ void access$onFeatureStateChange(BackgroundAnrPluginDelegate $this) {
        $this.onFeatureStateChange();
    }

    public static final /* synthetic */ void access$startSyncingIfPossible(BackgroundAnrPluginDelegate $this) {
        $this.startSyncingIfPossible();
    }
}

