/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.anr.model;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.anr.di.AnrServiceLocator;
import com.instabug.bganr.BackgroundAnrTraceFileParser;
import com.instabug.commons.AttachmentsHolder;
import com.instabug.commons.BasicAttachmentsHolder;
import com.instabug.commons.caching.DiskHelper;
import com.instabug.commons.models.Incident;
import com.instabug.commons.models.IncidentMetadata;
import com.instabug.commons.threading.CrashDetailsParser;
import com.instabug.commons.utils.StateExtKt;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributesDbHelper;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.WriteStateToFileDiskOperation;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.Report;
import com.instabug.library.model.State;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ReportHelper;
import com.instabug.library.util.memory.MemoryUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Anr
implements Incident,
AttachmentsHolder {
    private final String id;
    private String mainThreadData;
    private String restOfThreadsData;
    private final AttachmentsHolder attachmentsHolder;
    private int anrState;
    private String temporaryServerToken;
    private State state;
    private String longMessage;
    @NonNull
    private IncidentMetadata metadata;
    @Nullable
    private String sessionId;
    @NonNull
    private Incident.Type type;
    @NonNull
    private String anrVersion;
    private boolean isEarlyAnr;

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
    public Anr(@NonNull String id, @NonNull IncidentMetadata metadata) {
        void var2_2;
        void var1_1;
        Anr anr = this;
        this.type = Incident.Type.ANR;
        this.anrVersion = "v1";
        this.isEarlyAnr = false;
        this.id = var1_1;
        anr.metadata = var2_2;
        anr.attachmentsHolder = new BasicAttachmentsHolder();
    }

    /*
     * WARNING - void declaration
     */
    public Anr(Context context, String mainThreadData, String restOfThreadsData, String longMessage, @NonNull IncidentMetadata metadata) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        State state;
        Anr anr = this_;
        String this_ = String.valueOf(System.currentTimeMillis());
        state = State.getState((Context)state);
        anr(this_, (String)var2_2, (String)var3_3, (String)var4_4, state, (IncidentMetadata)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
    private Anr(String id, String mainThreadData, String restOfThreadsData, String longMessage, State state, @NonNull IncidentMetadata metadata) {
        this((String)var1_1, (IncidentMetadata)var6_6);
        void var4_4;
        void var3_3;
        void var2_2;
        void var5_5;
        void var6_6;
        void var1_1;
        this.state = var5_5;
        this.mainThreadData = var2_2;
        this.restOfThreadsData = var3_3;
        this.longMessage = var4_4;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$102(Anr x0, String x1) {
        void var1_1;
        var0.sessionId = var1_1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Incident.Type access$202(Anr x0, Incident.Type x1) {
        void var1_1;
        var0.type = var1_1;
        return x1;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    public void setMainThreadData(String mainThreadData) {
        void var1_1;
        this.mainThreadData = var1_1;
    }

    public String getMainThreadData() {
        return this.mainThreadData;
    }

    public String getRestOfThreadsData() {
        return this.restOfThreadsData;
    }

    /*
     * WARNING - void declaration
     */
    public void setRestOfThreadsData(String restOfThreadsData) {
        void var1_1;
        this.restOfThreadsData = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Anr addAttachment(Uri attachmentUri) {
        void var1_1;
        Anr anr = this;
        anr.addAttachment((Uri)var1_1, Attachment.Type.ATTACHMENT_FILE, false);
        return anr;
    }

    /*
     * WARNING - void declaration
     */
    public void setState(State state) {
        void var1_1;
        this.state = var1_1;
    }

    public State getState() {
        return this.state;
    }

    public int getAnrState() {
        return this.anrState;
    }

    /*
     * WARNING - void declaration
     */
    public void setAnrState(int anrState) {
        void var1_1;
        this.anrState = var1_1;
    }

    public String getTemporaryServerToken() {
        return this.temporaryServerToken;
    }

    /*
     * WARNING - void declaration
     */
    public void setTemporaryServerToken(String temporaryServerToken) {
        void var1_1;
        this.temporaryServerToken = var1_1;
    }

    public String getLongMessage() {
        return this.longMessage;
    }

    /*
     * WARNING - void declaration
     */
    public void setLongMessage(String longMessage) {
        void var1_1;
        this.longMessage = var1_1;
    }

    @Override
    @NonNull
    public IncidentMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NonNull
    public Incident.Type getType() {
        return this.type;
    }

    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    @NonNull
    public File getSavingDirOnDisk(@NonNull Context ctx) {
        Anr anr = string;
        String string = Incident.Type.ANR.name();
        return DiskHelper.getIncidentSavingDirectory(ctx, string, anr.id);
    }

    @Override
    @NonNull
    public List<Attachment> getAttachments() {
        return this.attachmentsHolder.getAttachments();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addAttachment(@Nullable Uri uri, @NonNull Attachment.Type type, boolean isEncrypted) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.attachmentsHolder.addAttachment((Uri)var1_1, (Attachment.Type)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAttachments(@NonNull List<? extends Attachment> attachments) {
        void var1_1;
        this.attachmentsHolder.setAttachments((List<? extends Attachment>)var1_1);
    }

    @NonNull
    public String getAnrVersion() {
        return this.anrVersion;
    }

    /*
     * WARNING - void declaration
     */
    public void setAnrVersion(@NonNull String anrVersion) {
        void var1_1;
        this.anrVersion = var1_1;
    }

    public boolean isEarlyAnr() {
        return this.isEarlyAnr;
    }

    /*
     * WARNING - void declaration
     */
    public void setEarlyAnr(boolean earlyAnr) {
        void var1_1;
        this.isEarlyAnr = var1_1;
    }

    public static class Factory {
        /*
         * WARNING - void declaration
         */
        private void updateAnrState(Anr anr) {
            void var1_2;
            Factory factory = Instabug.getApplicationContext();
            if (factory != null && !MemoryUtils.isLowMemory((Context)factory) && InstabugCore.getFeatureState((String)"USER_EVENTS") == Feature.State.ENABLED) {
                try {
                    var1_2.getState().updateUserEvents();
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e((String)"IBG-CR", (String)"Got error while parsing user events logs", (Throwable)jSONException);
                }
            }
            if (SettingsManager.getInstance().getOnReportCreatedListener() == null) {
                void v0 = var1_2;
                v0.getState().setTags(InstabugCore.getTagsAsString());
                v0.getState().updateConsoleLog();
                factory = Feature.State.ENABLED;
                if (InstabugCore.getFeatureState((String)"USER_DATA") == factory) {
                    var1_2.getState().setUserData(InstabugCore.getUserData());
                }
                if (InstabugCore.getFeatureState((String)"INSTABUG_LOGS") == factory) {
                    var1_2.getState().setInstabugLog(InstabugLog.getLogs());
                }
            }
            var1_2.getState().setUserAttributes(UserAttributesDbHelper.getSDKUserAttributes());
            if (AnrServiceLocator.getReproConfigurationsProvider().isReproStepsEnabled()) {
                var1_2.getState().updateVisualUserSteps();
            }
            StateExtKt.updateScreenShotAnalytics(var1_2.getState());
        }

        /*
         * WARNING - void declaration
         */
        private void persistAnrState(@NonNull Context ctx, @NonNull State state, @NonNull File savingDir) throws JSONException, IOException {
            void var2_2;
            void var1_1;
            void var3_3;
            File file = DiskHelper.getIncidentStateFile((File)var3_3, "anr_state");
            state.setUri(DiskUtils.with((Context)var1_1).writeOperation((DiskOperation)new WriteStateToFileDiskOperation(file, var2_2.toJson())).execute());
        }

        private void updateStateWithReport(@NonNull State state) {
            ReportHelper.update((State)state, (Report)ReportHelper.getReport((Report.OnReportCreatedListener)InstabugCore.getOnReportCreatedListener()));
        }

        /*
         * WARNING - void declaration
         */
        private void updateAttachmentFiles(@NonNull Context ctx, @NonNull Anr anr) {
            if (InstabugCore.getExtraAttachmentFiles() != null && ((AbstractMap)InstabugCore.getExtraAttachmentFiles()).size() >= 1) {
                for (Map.Entry entry : InstabugCore.getExtraAttachmentFiles().entrySet()) {
                    void var2_2;
                    void var1_1;
                    Uri entry2 = AttachmentsUtility.getNewFileAttachmentUri((Context)var1_1, (Uri)((Uri)entry.getKey()), (String)((String)entry.getValue()));
                    if (entry2 == null) continue;
                    var2_2.addAttachment(entry2);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @WorkerThread
        private void addReproScreenshotsAttachmentIfApplicable(@NonNull Anr anr, @NonNull Context context) {
            void var2_2;
            void var1_1;
            if (!AnrServiceLocator.getReproConfigurationsProvider().isReproScreenshotsEnabled()) {
                return;
            }
            this.addReproScreenshotsAttachment((Anr)var1_1, (Context)var2_2, (File)AnrServiceLocator.getReproScreenshotsCacheDir().getCurrentSpanDirectory());
        }

        /*
         * WARNING - void declaration
         */
        @WorkerThread
        private void addReproScreenshotsAttachment(@NonNull Anr anr, @NonNull Context context, @Nullable File reproScreenshotsDir) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (reproScreenshotsDir == null) {
                return;
            }
            Attachment.Type type = var1_1.getId();
            if ((type = DiskHelper.getReproScreenshotsZipPath((Context)var2_2, (String)type, var1_1.getSavingDirOnDisk((Context)var2_2), (File)var3_3)).getFirst() == null) {
                return;
            }
            Uri uri = Uri.parse((String)((String)type.getFirst()));
            Attachment.Type type2 = type;
            type = Attachment.Type.VISUAL_USER_STEPS;
            var1_1.addAttachment(uri, type, (Boolean)type2.getSecond());
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public Anr createAnr(String anrException, String longMessage, @NonNull IncidentMetadata metadata) throws JSONException, IOException {
            void var3_3;
            State state;
            Anr anr;
            Anr anr2;
            CrashDetailsParser crashDetailsParser;
            Context context = Instabug.getApplicationContext();
            if (context == null) {
                InstabugSDKLogger.e((String)"IBG-CR", (String)"Couldn't create a new instance of ANR due to a null context.");
                return null;
            }
            Object object = crashDetailsParser;
            crashDetailsParser = new CrashDetailsParser(CrashDetailsParser.ThreadParsingStrategy.Main.INSTANCE, new CrashDetailsParser.ErrorParsingStrategy.Main("ANRError: Application Not Responding for at least 5000 ms.", (String)((Object)anr2)));
            anr2 = anr;
            CrashDetailsParser crashDetailsParser2 = object;
            object = crashDetailsParser2.getCrashDetails().toString();
            if (new Anr(context, (String)object, crashDetailsParser2.getThreadsDetails().toString(), (String)state, (IncidentMetadata)var3_3).getState() != null) {
                Anr anr3 = anr2;
                anr3.getState().setAppStatusToForeground();
                this.updateAnrState(anr3);
                this.addReproScreenshotsAttachmentIfApplicable(anr2, context);
                this.updateStateWithReport(anr2.getState());
                state = anr2.getState();
                this.persistAnrState(context, state, anr2.getSavingDirOnDisk(context));
            }
            this.updateAttachmentFiles(context, anr2);
            return anr2;
        }

        /*
         * WARNING - void declaration
         */
        public Anr createOSAnr(@NonNull Context ctx, InputStream traceStream, State state, @NonNull IncidentMetadata metadata, @NonNull String sessionId, @Nullable File reproScreenshotsDir, boolean isBackground) throws JSONException, IOException {
            void var1_1;
            void var5_5;
            void var4_4;
            File file;
            Anr anr;
            State state2;
            void var7_7;
            String string = isBackground ? "An ANR is detected while the app is in the background." : "ANRError: Application Not Responding for at least 5000 ms.";
            Incident.Type type = var7_7 != false ? Incident.Type.BG_ANR : Incident.Type.ANR;
            state2 = new BackgroundAnrTraceFileParser().invoke((InputStream)state2, "ANRError: Application Not Responding for at least 5000 ms.", string);
            Anr anr2 = anr;
            Pair<JSONObject, JSONArray> pair = state2;
            state2 = ((JSONObject)pair.getFirst()).toString();
            anr2(String.valueOf(System.currentTimeMillis()), (String)state2, ((JSONArray)pair.getSecond()).toString(), string, (State)file, (IncidentMetadata)var4_4);
            Anr.access$102(anr2, (String)var5_5);
            Anr.access$202(anr, type);
            if (anr.getState() != null) {
                void var6_6;
                if (type == Incident.Type.BG_ANR) {
                    anr2.getState().setAppStatusToBackground();
                } else {
                    anr2.getState().setAppStatusToForeground();
                }
                Anr anr3 = anr2;
                this.addReproScreenshotsAttachment(anr2, (Context)var1_1, (File)var6_6);
                state2 = anr3.getState();
                file = anr3.getSavingDirOnDisk((Context)var1_1);
                this.persistAnrState((Context)var1_1, state2, file);
            }
            this.updateAttachmentFiles((Context)var1_1, anr2);
            return anr2;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public Anr createEarlyAnr(@NonNull Context ctx, InputStream traceStream, State state, @NonNull IncidentMetadata metadata) throws JSONException, IOException {
            void var1_1;
            void var4_4;
            void var3_3;
            Anr anr;
            State state2;
            state2 = new BackgroundAnrTraceFileParser().invoke((InputStream)state2, "ANRError: Application Not Responding for at least 5000 ms.", "ANRError: Application Not Responding for at least 5000 ms.");
            Anr anr2 = anr;
            Pair<JSONObject, JSONArray> pair = state2;
            state2 = ((JSONObject)pair.getFirst()).toString();
            if (new Anr(String.valueOf(System.currentTimeMillis()), (String)state2, ((JSONArray)pair.getSecond()).toString(), "ANRError: Application Not Responding for at least 5000 ms.", (State)var3_3, (IncidentMetadata)var4_4).getState() != null) {
                Anr anr3 = anr2;
                anr3.getState().setAppStatusToForeground();
                state2 = anr3.getState();
                this.persistAnrState((Context)var1_1, state2, anr2.getSavingDirOnDisk((Context)var1_1));
            }
            Anr anr4 = anr2;
            this.updateAttachmentFiles((Context)var1_1, anr2);
            anr4.setAnrVersion("v2");
            anr4.setEarlyAnr(true);
            anr4.setAnrState(1);
            return anr4;
        }
    }
}

