/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.anr;

import android.content.Context;
import android.os.Build;
import androidx.annotation.WorkerThread;
import com.instabug.anr.AnrListener;
import com.instabug.anr.AnrPluginDelegate;
import com.instabug.anr.InstabugAnrDetectorThread;
import com.instabug.anr.ProcessStateHelper;
import com.instabug.anr.cache.AnrReportsDbHelper;
import com.instabug.anr.configuration.AnrConfigurationProvider;
import com.instabug.anr.model.Anr;
import com.instabug.anr.network.InstabugAnrUploaderJob;
import com.instabug.commons.PluginDelegate;
import com.instabug.commons.configurations.ConfigurationsHandler;
import com.instabug.crash.utils.CrashCleanupUtils;
import com.instabug.library.Instabug;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AppUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.ReproCapturingProxy;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0004J\u000f\u0010\u000f\u001a\u00020\u0005H\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0004J\u000f\u0010\u0010\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0004J\u000f\u0010\u0011\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0011\u0010\tJ\u000f\u0010\u0012\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0012\u0010\tJ#\u0010\u0016\u001a\u00020\u00052\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0004J\u000f\u0010\u001e\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0004J\u000f\u0010\u001f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0004J\u0017\u0010\"\u001a\u00020\u00052\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010&\u001a\u00020\u00052\u0006\u0010%\u001a\u00020$H\u0017\u00a2\u0006\u0004\b&\u0010'R\u0018\u0010)\u001a\u0004\u0018\u00010(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0019\u0010+R\u001b\u00101\u001a\u00020,8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u001b\u00106\u001a\u0002028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010.\u001a\u0004\b4\u00105R\u001b\u0010;\u001a\u0002078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010.\u001a\u0004\b9\u0010:\u00a8\u0006<"}, d2={"Lcom/instabug/anr/AnrPluginDelegate;", "Lcom/instabug/commons/PluginDelegate;", "Lcom/instabug/anr/AnrListener;", "<init>", "()V", "", "handleAnrStateChanged", "", "anrV2Enabled", "()Z", "", "featuresResponse", "handleFeaturesFetched", "(Ljava/lang/String;)V", "startAnrDetection", "startAnrsUploaderService", "startAnrDetectionIfPossible", "canStartAnrDetection", "isAnrEnabled", "", "", "modesMap", "handleReproStateConfigurations", "(Ljava/util/Map;)V", "Landroid/content/Context;", "context", "init", "(Landroid/content/Context;)V", "start", "wake", "sleep", "stop", "Lcom/instabug/library/core/eventbus/coreeventbus/IBGSdkCoreEvent;", "sdkCoreEvent", "handleSDKCoreEvent", "(Lcom/instabug/library/core/eventbus/coreeventbus/IBGSdkCoreEvent;)V", "Lcom/instabug/anr/model/Anr;", "anr", "onAnrDetected", "(Lcom/instabug/anr/model/Anr;)V", "Lcom/instabug/anr/InstabugAnrDetectorThread;", "anrDetectorThread", "Lcom/instabug/anr/InstabugAnrDetectorThread;", "Landroid/content/Context;", "Lcom/instabug/commons/configurations/ConfigurationsHandler;", "anrConfigurationHandler$delegate", "Lkotlin/Lazy;", "getAnrConfigurationHandler", "()Lcom/instabug/commons/configurations/ConfigurationsHandler;", "anrConfigurationHandler", "Lcom/instabug/anr/configuration/AnrConfigurationProvider;", "anrConfigurationProvider$delegate", "getAnrConfigurationProvider", "()Lcom/instabug/anr/configuration/AnrConfigurationProvider;", "anrConfigurationProvider", "Lcom/instabug/library/visualusersteps/ReproCapturingProxy;", "reproProxy$delegate", "getReproProxy", "()Lcom/instabug/library/visualusersteps/ReproCapturingProxy;", "reproProxy", "instabug-crash_defaultUiRelease"}, xi=48)
@SourceDebugExtension(value={"SMAP\nAnrPluginDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnrPluginDelegate.kt\ncom/instabug/anr/AnrPluginDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public final class AnrPluginDelegate
implements PluginDelegate,
AnrListener {
    @Nullable
    private InstabugAnrDetectorThread anrDetectorThread;
    private Context context;
    @NotNull
    private final Lazy anrConfigurationHandler$delegate = LazyKt.lazy((Function0)anrConfigurationHandler.2.INSTANCE);
    @NotNull
    private final Lazy anrConfigurationProvider$delegate = LazyKt.lazy((Function0)anrConfigurationProvider.2.INSTANCE);
    @NotNull
    private final Lazy reproProxy$delegate = LazyKt.lazy((Function0)reproProxy.2.INSTANCE);

    private final ConfigurationsHandler getAnrConfigurationHandler() {
        return (ConfigurationsHandler)this.anrConfigurationHandler$delegate.getValue();
    }

    private final AnrConfigurationProvider getAnrConfigurationProvider() {
        return (AnrConfigurationProvider)this.anrConfigurationProvider$delegate.getValue();
    }

    private final ReproCapturingProxy getReproProxy() {
        return (ReproCapturingProxy)this.reproProxy$delegate.getValue();
    }

    private final void handleAnrStateChanged() {
        AnrPluginDelegate anrPluginDelegate = this;
        anrPluginDelegate.getReproProxy().evaluate((ReproConfigurationsProvider)this.getAnrConfigurationProvider());
        if (!anrPluginDelegate.anrV2Enabled() && this.isAnrEnabled()) {
            this.startAnrDetectionIfPossible();
        } else {
            InstabugAnrDetectorThread instabugAnrDetectorThread = this.anrDetectorThread;
            if (instabugAnrDetectorThread != null) {
                instabugAnrDetectorThread.interrupt();
            }
            this.anrDetectorThread = null;
        }
    }

    private final boolean anrV2Enabled() {
        return Build.VERSION.SDK_INT >= 30 && this.getAnrConfigurationProvider().isAnrV2Enabled();
    }

    /*
     * WARNING - void declaration
     */
    private final void handleFeaturesFetched(String featuresResponse) {
        void var1_1;
        PoolProvider.postIOTask(() -> AnrPluginDelegate.handleFeaturesFetched$lambda$2(this, (String)var1_1));
    }

    private final void startAnrDetection() {
        if (Instabug.isEnabled()) {
            InstabugAnrDetectorThread instabugAnrDetectorThread;
            ProcessStateHelper processStateHelper;
            Anr.Factory factory;
            Anr.Factory factory2 = factory;
            factory = new Anr.Factory();
            ProcessStateHelper processStateHelper2 = processStateHelper;
            processStateHelper = new ProcessStateHelper();
            InstabugAnrDetectorThread instabugAnrDetectorThread2 = instabugAnrDetectorThread;
            instabugAnrDetectorThread2(this, factory2, processStateHelper2);
            this.anrDetectorThread = instabugAnrDetectorThread2;
            instabugAnrDetectorThread.start();
        }
    }

    @WorkerThread
    private final void startAnrsUploaderService() {
        if (!this.getAnrConfigurationProvider().isAnrEnabled()) {
            return;
        }
        CrashCleanupUtils.cleanStaleANRStateFiles();
        if (AnrReportsDbHelper.getAnrsCount() <= 0) {
            return;
        }
        InstabugAnrUploaderJob.getInstance().start();
    }

    private final void startAnrDetectionIfPossible() {
        if (this.canStartAnrDetection()) {
            this.startAnrDetection();
        }
    }

    private final boolean canStartAnrDetection() {
        return this.anrDetectorThread == null && this.isAnrEnabled() && AppUtils.isAppForeground((Context)Instabug.getApplicationContext());
    }

    private final boolean isAnrEnabled() {
        return this.getAnrConfigurationProvider().isAnrEnabled();
    }

    /*
     * WARNING - void declaration
     */
    private final void handleReproStateConfigurations(Map<Integer, Integer> modesMap) {
        void var1_1;
        AnrPluginDelegate anrPluginDelegate = this;
        anrPluginDelegate.getAnrConfigurationHandler().handle((Map)var1_1);
        anrPluginDelegate.getReproProxy().evaluate((ReproConfigurationsProvider)this.getAnrConfigurationProvider());
    }

    private static final void start$lambda$1(AnrPluginDelegate this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SettingsManager settingsManager = SettingsManager.getInstance();
        if (settingsManager != null && (settingsManager = settingsManager.getReproConfigurations()) != null) {
            AnrPluginDelegate anrPluginDelegate;
            anrPluginDelegate.handleReproStateConfigurations(settingsManager.getModesMap());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void handleFeaturesFetched$lambda$2(AnrPluginDelegate this$0, String $featuresResponse) {
        void var1_1;
        AnrPluginDelegate anrPluginDelegate;
        AnrPluginDelegate anrPluginDelegate2 = this$0;
        Intrinsics.checkNotNullParameter((Object)anrPluginDelegate, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"$featuresResponse");
        anrPluginDelegate2.getAnrConfigurationHandler().handleConfiguration((String)var1_1);
        anrPluginDelegate2.handleAnrStateChanged();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@NotNull Context context) {
        void var1_1;
        AnrPluginDelegate anrPluginDelegate = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"context");
        anrPluginDelegate.context = v1;
        anrPluginDelegate.getReproProxy().evaluate((ReproConfigurationsProvider)this.getAnrConfigurationProvider());
        anrPluginDelegate.getAnrConfigurationHandler().migrateCurrentConfiguration();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start(@NotNull Context context) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        if (this.anrV2Enabled()) {
            return;
        }
        PoolProvider.postIOTask(() -> AnrPluginDelegate.start$lambda$1(this));
    }

    @Override
    public void wake() {
        InstabugSDKLogger.d((String)"IBG-CR", (String)"Waking ANR plugin delegate");
        if (this.anrV2Enabled()) {
            return;
        }
        AnrPluginDelegate anrPluginDelegate = this;
        PoolProvider.postIOTask(anrPluginDelegate::startAnrsUploaderService);
        anrPluginDelegate.startAnrDetectionIfPossible();
    }

    @Override
    public void sleep() {
        if (this.anrV2Enabled()) {
            return;
        }
        InstabugAnrDetectorThread instabugAnrDetectorThread = this.anrDetectorThread;
        if (instabugAnrDetectorThread != null) {
            instabugAnrDetectorThread.interrupt();
        }
        this.anrDetectorThread = null;
    }

    @Override
    public void stop() {
        if (this.anrV2Enabled()) {
            return;
        }
        this.anrDetectorThread = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleSDKCoreEvent(@NotNull IBGSdkCoreEvent sdkCoreEvent) {
        void var1_1;
        IBGSdkCoreEvent iBGSdkCoreEvent = sdkCoreEvent;
        Intrinsics.checkNotNullParameter((Object)iBGSdkCoreEvent, (String)"sdkCoreEvent");
        if (Intrinsics.areEqual((Object)iBGSdkCoreEvent, (Object)IBGSdkCoreEvent.NetworkActivated.INSTANCE)) {
            PoolProvider.postIOTask(this::startAnrsUploaderService);
        } else if (var1_1 instanceof IBGSdkCoreEvent.FeaturesFetched) {
            this.handleFeaturesFetched(((IBGSdkCoreEvent.FeaturesFetched)var1_1).getResponse());
        } else if (var1_1 instanceof IBGSdkCoreEvent.Features) {
            this.handleAnrStateChanged();
        } else if (var1_1 instanceof IBGSdkCoreEvent.ReproState) {
            this.handleReproStateConfigurations(((IBGSdkCoreEvent.ReproState)var1_1).getModesMap());
        }
    }

    @Override
    @WorkerThread
    public void onAnrDetected(@NotNull Anr anr) {
        Anr anr2 = anr;
        Intrinsics.checkNotNullParameter((Object)anr2, (String)"anr");
        anr2.setAnrState(1);
        AnrReportsDbHelper.insert(anr2);
    }
}

