package com.instabug.crash.models

import com.instabug.library.Constants
import com.instabug.library.internal.storage.cache.Cacheable
import com.instabug.library.util.InstabugSDKLogger
import org.json.JSONArray
import org.json.JSONObject

data class IgnoredNonFatal(
    var en: String? = null,
    var emRegex: String? = null,
    var appVersions: List<String>? = null,
    var gs: String? = null
) : Cacheable {
    override fun toJson(): String {
        try {
            val jsonObject = JSONObject()
            jsonObject.put("en", en)
            jsonObject.put("em_regex", emRegex)
            jsonObject.put("app_versions", appVersions?.let { JSONArray(it) } ?: JSONArray())
            jsonObject.put("gs", gs)
            return jsonObject.toString()
        } catch (exception: Exception) {
            InstabugSDKLogger.e(
                Constants.LOG_TAG,
                "something went wrong while parsing ignored nonFatal json object"
            )
            return exception.message ?: "unknown error"
        }
    }

    override fun fromJson(modelAsJson: String?) {
        if (modelAsJson != null) {
            try {
                val jsonObject = JSONObject(modelAsJson)
                this.en = jsonObject.optString("en", null)
                this.emRegex = jsonObject.optString("em_regex", null)
                this.gs = jsonObject.optString("gs", null)
                val appVersionsArray = jsonObject.optJSONArray("app_versions")
                this.appVersions = appVersionsArray?.let {
                    List(it.length()) { index -> it.getString(index) }
                }.orEmpty()
            } catch (exception: Exception) {
                this.en = null
                this.emRegex = null
                this.gs = null
                this.appVersions = emptyList()
                InstabugSDKLogger.e(
                    Constants.LOG_TAG,
                    "something went wrong while parsing ignored nonFatal from json object" + exception.message
                )
            }
        } else {
            this.en = null
            this.emRegex = null
            this.gs = null
            this.appVersions = emptyList()
        }
    }
}
