package com.instabug.terminations

import com.instabug.terminations.configuration.TerminationsConfigurationProvider
import com.instabug.terminations.di.ServiceLocator

fun interface TerminationsValidator {
    operator fun invoke(firstFGTime: Long, trmTime: Long): Boolean
}

class DefaultTerminationsValidator(
    private val configProvider: TerminationsConfigurationProvider
) : TerminationsValidator {
    override fun invoke(firstFGTime: Long, trmTime: Long): Boolean {
        val delta = firstFGTime - trmTime
        return delta > 0 && delta <= configProvider.threshold
    }

    object Factory {
        operator fun invoke(
            configProvider: TerminationsConfigurationProvider =
                ServiceLocator.terminationsConfigurationProvider
        ): DefaultTerminationsValidator = DefaultTerminationsValidator(configProvider)
    }
}
