package com.instabug.crash.di

import com.instabug.anr.AnrPluginDelegate
import com.instabug.bganr.BackgroundAnrPluginDelegate
import com.instabug.commons.IncidentDetectorsListener
import com.instabug.commons.configurations.ConfigurationsHandler
import com.instabug.commons.di.CommonsLocator
import com.instabug.commons.diagnostics.DiagnosticsPluginDelegate
import com.instabug.crash.CrashPluginDelegate
import com.instabug.crash.configurations.CrashConfigurationHandlerImpl
import com.instabug.crash.configurations.CrashConfigurationProvider
import com.instabug.crash.configurations.CrashConfigurationProviderImpl
import com.instabug.crash.configurations.NonFatalsConfigurationProvider
import com.instabug.crash.configurations.NonFatalsConfigurationProviderImpl
import com.instabug.crash.configurations.NonFatalsReproConfigurationHandler
import com.instabug.crash.network.CrashMetadataImmediateUploader
import com.instabug.crash.network.CrashMetadataImmediateUploaderImpl
import com.instabug.crash.network.CrashesService
import com.instabug.crash.settings.CrashSettings
import com.instabug.early_crash.EarlyCrashesPluginDelegate
import com.instabug.fatalhangs.FatalHangsPluginDelegate
import com.instabug.library.IBGNetworkWorker
import com.instabug.library.Instabug
import com.instabug.library.SpansCacheDirectory
import com.instabug.library.util.threading.PoolProvider
import com.instabug.library.visualusersteps.ReproConfigurationsProvider
import com.instabug.terminations.TerminationsPluginDelegate

object CrashesServiceLocator {

    @JvmStatic
    val pluginDelegates by lazy {
        listOf(
            CrashPluginDelegate(),
            EarlyCrashesPluginDelegate(),
            AnrPluginDelegate(),
            FatalHangsPluginDelegate(),
            TerminationsPluginDelegate(),
            BackgroundAnrPluginDelegate(),
            DiagnosticsPluginDelegate()
        )
    }

    @JvmStatic
    fun getCrashConfigurationHandler(): ConfigurationsHandler = CrashConfigurationHandlerImpl()

    @JvmStatic
    val crashConfigurationProvider: CrashConfigurationProvider by lazy {
        CrashConfigurationProviderImpl()
    }

    @JvmStatic
    val crashDetectorListener: IncidentDetectorsListener
        get() = CommonsLocator.detectorsListenersRegistry

    @JvmStatic
    val reproConfigurationsProvider: ReproConfigurationsProvider
        get() = CommonsLocator.configurationsProvider

    val reproScreenshotsCacheDir: SpansCacheDirectory
        @JvmStatic get() = CommonsLocator.reproScreenshotsCacheDir

    val immediateCrashMetadataUploader: CrashMetadataImmediateUploader?
        @JvmStatic get() = Instabug.getApplicationContext()?.let { context ->
            CrashMetadataImmediateUploaderImpl(
                PoolProvider.getNetworkingSingleThreadExecutorService(IBGNetworkWorker.CRASH),
                context,
                CrashesService.getInstance(),
                CrashSettings.getInstance()
            )
        }

    @JvmStatic
    val nonFatalsConfigurationsProvider: NonFatalsConfigurationProvider by lazy {
        NonFatalsConfigurationProviderImpl()
    }

    val nonFatalsReproConfigurationsHandler: NonFatalsReproConfigurationHandler by lazy {
        NonFatalsReproConfigurationHandler()
    }

}
