package com.instabug.crash.eventbus;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.library.Feature;
import com.instabug.library.core.eventbus.EventBus;

public class NDKCrashReportingFeatureStateChange extends EventBus<Feature.State> {

    @Nullable
    private static NDKCrashReportingFeatureStateChange ndkCrashReportingFeatureStateChange;

    private NDKCrashReportingFeatureStateChange() {
        super();
    }

    public static synchronized NDKCrashReportingFeatureStateChange getInstance() {
        if (ndkCrashReportingFeatureStateChange == null) {
            ndkCrashReportingFeatureStateChange = new NDKCrashReportingFeatureStateChange();
        }
        return ndkCrashReportingFeatureStateChange;
    }

    @VisibleForTesting
    public static synchronized void reset() {
        ndkCrashReportingFeatureStateChange = null;
    }
}
