package com.instabug.crash.configurations


import com.instabug.commons.preferences.crashPref
import com.instabug.crash.Constants.Preferences.CRASH_METADATA_CALLBACK_ENABLED
import com.instabug.crash.Constants.Preferences.CRASH_REPORTING_AVAILABILITY
import com.instabug.crash.Constants.Preferences.METADATA_IMMEDIATE_SYNC_AVAILABILITY
import com.instabug.crash.Constants.Preferences.NON_FATAL_AVAILABILITY

class CrashConfigurationProviderImpl : CrashConfigurationProvider {


    override var crashReportingLocallyEnabled: Boolean = true
    override var isCrashReportingAvailable: Boolean by crashPref(CRASH_REPORTING_AVAILABILITY)
    override var isCrashMetaDataCallbackEnabled: Boolean by crashPref(CRASH_METADATA_CALLBACK_ENABLED)
    override var isNonFatalReportingAvailable: Boolean by crashPref(NON_FATAL_AVAILABILITY)
    override var isMetadataImmediateSyncAvailable: Boolean by crashPref(METADATA_IMMEDIATE_SYNC_AVAILABILITY)

    override fun isCrashReportingEnabled(): Boolean =
        crashReportingLocallyEnabled and isCrashReportingAvailable

    override fun isNonFatalReportingEnabled(): Boolean =
        isNonFatalReportingAvailable and isCrashReportingEnabled()
}