package com.instabug.commons.snapshot

import com.instabug.commons.logging.getOrReportError
import java.io.File
import java.io.ObjectInputStream
import java.io.ObjectOutputStream
import java.io.Serializable

fun File.writeSerializable(savable: Serializable) {
    runCatching { ObjectOutputStream(outputStream()).use { stream -> stream.writeObject(savable) } }
}

inline fun <reified T> File.readSerializable(): T? =
    runCatching { ObjectInputStream(inputStream()).use { stream -> stream.readObject() as? T } }
        .getOrReportError(null, "Error while reading serialized file.")

fun File.readSerializableAsAny(): Any? =
    runCatching { ObjectInputStream(inputStream()).use { stream -> stream.readObject() } }
        .getOrReportError(null, "Error while reading serialized file.")

inline fun File.ifNotExists(block: File.() -> Unit): File = run {
    takeIf { it.exists() } ?: block(); this
}

fun File.rename(newName: String) =
    parentFile?.let { parent -> renameTo(File("${parent.absolutePath}${File.separator}$newName")) }
