package com.instabug.commons.models

import java.util.*

/**
 * Encapsulates all crashes incidents common metadata
 * @constructor Creates a new metadata object
 * @param uuid The UUID identifier of the incident. Nullable for compatibility
 * with previously recorded incidents.
 */
class IncidentMetadata private constructor(val uuid: String?) {

    object Factory {
        @JvmStatic
        @JvmOverloads
        fun create(
            uuid: String? = UUID.randomUUID().toString()
        ): IncidentMetadata = IncidentMetadata(uuid)
    }
}
