package com.instabug.terminations.model

import androidx.annotation.IntDef
import com.instabug.terminations.model.TerminationState.Companion.ATTACHMENTS_READY_TO_BE_SENT
import com.instabug.terminations.model.TerminationState.Companion.LOGS_READY_TO_BE_UPLOADED
import com.instabug.terminations.model.TerminationState.Companion.READY_TO_BE_SENT
import com.instabug.terminations.model.TerminationState.Companion.SYNCHRONIZED

@Retention(AnnotationRetention.SOURCE)
@IntDef(
    READY_TO_BE_SENT,
    LOGS_READY_TO_BE_UPLOADED,
    ATTACHMENTS_READY_TO_BE_SENT,
    SYNCHRONIZED
)
annotation class TerminationState {
    companion object {
        const val READY_TO_BE_SENT = 1
        const val LOGS_READY_TO_BE_UPLOADED = 2
        const val ATTACHMENTS_READY_TO_BE_SENT = 4
        const val SYNCHRONIZED = 3
    }
}
