/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.commons.caching.DiskHelper;
import com.instabug.commons.di.CommonsLocator;
import com.instabug.commons.threading.a;
import com.instabug.crash.OnCrashSentCallback;
import com.instabug.crash.cache.c;
import com.instabug.crash.eventbus.NDKCrashReportingFeatureStateChange;
import com.instabug.crash.models.IBGNonFatalException;
import com.instabug.crash.models.a;
import com.instabug.crash.settings.d;
import com.instabug.crash.utils.CrashReportingUtility;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventPublisher;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.WriteStateToFileDiskOperation;
import com.instabug.library.internal.video.ScreenRecordingServiceAction;
import com.instabug.library.model.Report;
import com.instabug.library.model.State;
import com.instabug.library.model.UserAttributes;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.MD5Generator;
import com.instabug.library.util.ReportHelper;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashReporting {
    private static final String TAG = "CrashReporting";
    public static final String CRASH_STATE = "crash_state";
    public static final String ANR_STATE = "anr_state";

    public static void report(@NonNull IBGNonFatalException exception) {
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.report", () -> {
            Map<String, String> map;
            IBGNonFatalException iBGNonFatalException = map;
            map = iBGNonFatalException.getUserAttributes();
            String string = iBGNonFatalException.getFingerprint();
            IBGNonFatalException.Level level = iBGNonFatalException.getLevel();
            CrashReporting.reportHandledException(exception.getThrowable(), null, map, string, level);
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void reportHandledException(@NonNull Throwable throwable, @Nullable String exceptionIdentifier, @Nullable Map<String, String> userAttributes, @Nullable String fingerprint, @NonNull IBGNonFatalException.Level level) {
        void var4_4;
        void var2_2;
        void var3_3;
        JSONObject jSONObject;
        Throwable throwable2;
        if (throwable == null) {
            return;
        }
        InstabugSDKLogger.d((String)"IBG-CR", (String)("Reporting handled exception: " + throwable2.getMessage()));
        if (!CrashReportingUtility.isCrashReportingEnabled()) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"CrashReporting is disabled, Couldn't report error");
            return;
        }
        if ((throwable2 = CrashReporting.getFormattedException(throwable2, (String)jSONObject)) == null) {
            return;
        }
        jSONObject = CrashReporting.getFingerprintObject((String)var3_3);
        if (jSONObject == null) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"Grouping string not provided. This crash will be grouped by the default grouping algorithm.");
        }
        CrashReporting.reportException((JSONObject)throwable2, true, (Map<String, String>)var2_2, jSONObject, (IBGNonFatalException.Level)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    private static void reportException(@NonNull JSONObject jsonObject, boolean isHandled) {
        void var1_1;
        CrashReporting.reportException(jsonObject, (boolean)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void reportException(@NonNull JSONObject jsonObject, boolean isHandled, @Nullable Map<String, String> userAttributes) {
        void var2_2;
        void var1_1;
        CrashReporting.reportException(jsonObject, (boolean)var1_1, (Map<String, String>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void reportException(@NonNull JSONObject jsonObject, boolean isHandled, @Nullable Map<String, String> userAttributes, @Nullable JSONObject fingerprint) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object object = IBGNonFatalException.Level.ERROR;
        CrashReporting.reportException(jsonObject, (boolean)var1_1, (Map<String, String>)var2_2, (JSONObject)var3_3, (IBGNonFatalException.Level)((Object)object));
    }

    /*
     * WARNING - void declaration
     */
    private static void reportException(@NonNull JSONObject jsonObject, boolean isHandled, @Nullable Map<String, String> userAttributes, @Nullable JSONObject fingerprint, @NonNull IBGNonFatalException.Level level) {
        void var4_4;
        void var3_3;
        void var2_2;
        JSONObject jSONObject;
        void var1_1;
        if (jsonObject == null) {
            return;
        }
        if (InstabugCore.getPlatform() != 2 && var1_1 == false) {
            CrashReporting.reportCrashingSession();
        }
        if (!CrashReportingUtility.isCrashReportingEnabled()) {
            return;
        }
        String string = InstabugCore.getCurrentView();
        if (com.instabug.crash.screenrecording.a.a().isEnabled() && SettingsManager.getInstance().isAutoScreenRecordingEnabled()) {
            CrashReporting.deleteAutoScreenRecording();
        }
        if (var1_1 != false) {
            PoolProvider.getSingleThreadExecutor((String)"HANDLED_CRASH").execute(() -> CrashReporting.lambda$reportException$1(jSONObject, (Map)var2_2, (JSONObject)var3_3, (IBGNonFatalException.Level)var4_4, string));
        } else {
            CrashReporting.saveAndReportException(jSONObject, false, (Map<String, String>)var2_2, (JSONObject)var3_3, (IBGNonFatalException.Level)var4_4, string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void saveAndReportException(@NonNull JSONObject jsonObject, boolean isHandled, @Nullable Map<String, String> userAttributes, @Nullable JSONObject fingerprint, @NonNull IBGNonFatalException.Level level, String currentView) {
        void var2_2;
        void var4_4;
        com.instabug.crash.models.a a2;
        void var1_1;
        Report report;
        JSONObject jSONObject;
        Context context = Instabug.getApplicationContext();
        if (context == null) {
            return;
        }
        JSONObject jSONObject2 = jSONObject;
        jSONObject = State.getState((Context)context);
        jSONObject.setCurrentView((String)report);
        com.instabug.crash.utils.b.a((State)jSONObject);
        report = ReportHelper.getReport((Report.OnReportCreatedListener)InstabugCore.getOnReportCreatedListener());
        a2 = CrashReporting.getCrash(jSONObject2, (boolean)var1_1, (State)jSONObject, (JSONObject)a2, (IBGNonFatalException.Level)var4_4, context);
        ReportHelper.update((State)a2.g(), (Report)report);
        if (var1_1 == false) {
            jSONObject.updateSessionIdFromLatestSession();
        }
        if (var2_2 != null && !var2_2.isEmpty()) {
            CrashReporting.appendUserAttributes((State)jSONObject, (Map<String, String>)var2_2);
        }
        if (InstabugCore.getExtraAttachmentFiles() != null && ((AbstractMap)InstabugCore.getExtraAttachmentFiles()).size() >= 1) {
            CrashReporting.addCrashAttachments(context, a2);
        }
        com.instabug.crash.models.a a3 = a2;
        CrashReporting.createStateTextFile(context, a3, DiskHelper.getIncidentStateFile(a3.getSavingDirOnDisk(context), CRASH_STATE));
        c.b(a2);
        CommonsLocator.getSessionLinker().a(a2, 1);
        InstabugSDKLogger.d((String)"IBG-CR", (String)("Crash " + a2.getMetadata().getUuid() + "is Linked successfully"));
        InstabugSDKLogger.d((String)"IBG-CR", (String)"Your exception has been reported");
        if (var1_1 != false) {
            com.instabug.crash.network.b.b().start();
        }
        com.instabug.crash.screenrecording.a.a().b();
    }

    /*
     * WARNING - void declaration
     */
    private static void createFormattedException(@NonNull Throwable throwable, @Nullable String identifier) {
        void var1_1;
        CrashReporting.createFormattedException(throwable, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void createFormattedException(@NonNull Throwable throwable, @Nullable String identifier, @Nullable Map<String, String> userAttributes) {
        void var2_2;
        void var1_1;
        Throwable throwable2;
        if (throwable == null) {
            return;
        }
        InstabugSDKLogger.v((String)"IBG-CR", (String)("Creating formatted exception for error: " + throwable2.getClass().getCanonicalName()));
        CrashReporting.reportException(new com.instabug.commons.threading.a(a.b.c.a, new a.a.a(throwable2, (String)var1_1)).a(), true, (Map<String, String>)var2_2);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void appendUserAttributes(@NonNull State state, Map<String, String> userAttributesMap) {
        var2_2 = 90;
        var3_3 = 100;
        var4_5 = v0;
        v0 = new UserAttributes();
        try {
            ** if (state.getUserAttributes() == null) goto lbl-1000
        }
        catch (JSONException var5_7) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"Error while appending user attributes to crash report", (Throwable)var5_7);
        }
lbl-1000:
        // 1 sources

        {
            var5_6 = v1;
            var6_8 = new JSONObject(var0.getUserAttributes()).keys();
            while (true) {
                ** if (!var6_8.hasNext()) goto lbl21
lbl-1000:
                // 1 sources

                {
                    v2 = var4_5;
                    v3 /* !! */  = var5_6;
                    var7_9 = (String)var6_8.next();
                    v2.put(var7_9, v3 /* !! */ .getString(var7_9));
                    continue;
                }
lbl21:
                // 1 sources

                ** GOTO lbl25
                break;
            }
        }
lbl-1000:
        // 1 sources

        {
        }
lbl25:
        // 3 sources

        if (var1_1.size() > var3_3) {
            InstabugSDKLogger.w((String)"IBG-CR", (String)("Some old user attributes were removed. Max allowed user attributes reached. Please note that you can add up to " + var3_3 + " user attributes."));
            var5_6 = v4;
            v4 = new LinkedHashMap<K, V>(var1_1);
            var6_8 = var1_1.entrySet().iterator();
            while (var6_8.hasNext()) {
                v5 = var5_6;
                v5.remove(var6_8.next().getKey());
                if (v5.size() > var3_3) continue;
            }
            v6 = var1_1;
            v6.clear();
            v6.putAll(var5_6);
        }
        for (Object var5_6 : var1_1.entrySet()) {
            if (var1_1.get(var5_6.getKey()) == null) continue;
            if (((String)var5_6.getKey()).length() <= var2_2 && ((String)var5_6.getValue()).length() <= var2_2) {
                var4_5.put((String)var5_6.getKey(), (String)var5_6.getValue());
                continue;
            }
            InstabugSDKLogger.w((String)"IBG-CR", (String)("Some user attributes weren't added. Max allowed user attributes characters limit is reached. Please note that you can add user attributes (key, value) with characters count up to " + var2_2 + " characters."));
        }
        var0.setUserAttributes(var4_5.toString());
    }

    private static void reportCrashingSession() {
        InstabugSDKLogger.d((String)"IBG-CR", (String)"Report crashing session");
        IBGCoreEventPublisher.post((IBGSdkCoreEvent)IBGSdkCoreEvent.CrossPlatformCrashed.INSTANCE);
        d.a().a(true);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void createStateTextFile(@NonNull Context context, @NonNull com.instabug.crash.models.a crash, @NonNull File file) {
        void var1_2;
        if (file == null) return;
        if (var1_2 == null) return;
        if (var1_2.g() == null) {
            return;
        }
        InstabugSDKLogger.v((String)"IBG-CR", (String)("Creating state file for crash: " + var1_2.d()));
        try {
            void var2_3;
            Context context2;
            context2 = DiskUtils.with((Context)context2).writeOperation((DiskOperation)new WriteStateToFileDiskOperation((File)var2_3, var1_2.g().toJson())).execute();
            if (context2 != null) {
                var1_2.g().setUri((Uri)context2);
            }
            AttachmentsUtility.encryptAttachments((List)var1_2.getAttachments());
            return;
        }
        catch (Throwable throwable) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"error while creating state text file", (Throwable)throwable);
        }
    }

    public static void deleteAutoScreenRecording() {
        AutoScreenRecordingEventBus.getInstance().post((Object)ScreenRecordingServiceAction.CustomeActions.STOP_DELETE);
    }

    /*
     * WARNING - void declaration
     */
    public static void addCrashAttachments(@NonNull Context context, com.instabug.crash.models.a crash) {
        void var1_1;
        if (context != null && var1_1 != null) {
            if (InstabugCore.getExtraAttachmentFiles() != null) {
                for (Map.Entry entry : InstabugCore.getExtraAttachmentFiles().entrySet()) {
                    Context context2;
                    Uri uri = AttachmentsUtility.getNewFileAttachmentUri((Context)context2, (Uri)((Uri)entry.getKey()), (String)((String)entry.getValue()));
                    if (uri == null) continue;
                    var1_1.a(uri);
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @VisibleForTesting
    public static JSONObject getFormattedException(@NonNull Throwable throwable, @Nullable String identifier) {
        void var1_1;
        Throwable throwable2;
        if (throwable == null) {
            return null;
        }
        InstabugSDKLogger.v((String)"IBG-CR", (String)("Creating formatted exception for error: " + throwable2.getClass().getCanonicalName()));
        throwable2 = new com.instabug.commons.threading.a(a.b.c.a, new a.a.a(throwable2, (String)var1_1)).a();
        if (throwable2.length() == 0) {
            throwable2 = null;
        }
        return throwable2;
    }

    @Nullable
    @VisibleForTesting
    public static JSONObject getFingerprintObject(@Nullable String fingerprint) {
        block13: {
            JSONObject jSONObject;
            String string;
            block14: {
                JSONObject jSONObject2;
                String string2;
                if (fingerprint == null) {
                    return null;
                }
                if ((string = string.trim()).length() == 0) {
                    return null;
                }
                try {
                    string2 = string;
                }
                catch (Throwable throwable) {
                    InstabugSDKLogger.e((String)"IBG-CR", (String)"Failed to process fingerprint", (Throwable)throwable);
                    return null;
                }
                jSONObject = jSONObject2;
                jSONObject2 = new JSONObject();
                String string3 = MD5Generator.generateMD5((String)string2.toLowerCase(Locale.getDefault()));
                if (string3 == null) break block13;
                if (string3.isEmpty()) break block13;
                String string4 = string;
                JSONObject jSONObject3 = jSONObject;
                String string5 = string;
                jSONObject.put("md5", (Object)string3);
                string3 = "length";
                jSONObject3.put(string3, string5.length());
                if (string4.length() <= 40) break block14;
                InstabugSDKLogger.w((String)"IBG-CR", (String)"Grouping string exceeds the defined maximum characters limit (40) so it will be trimmed");
                string = string.substring(0, 40);
            }
            JSONObject jSONObject4 = jSONObject;
            JSONObject jSONObject5 = jSONObject4;
            jSONObject4.put("original", (Object)string);
            return jSONObject5;
        }
        throw new IllegalStateException("Couldn't generate MD5 for fingerprint");
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    private static com.instabug.crash.models.a getCrash(JSONObject jsonObject, boolean handled, State state, @Nullable JSONObject fingerprint, @NonNull IBGNonFatalException.Level level, @NonNull Context context) {
        void var3_3;
        void var4_4;
        Object object;
        void var1_1;
        void var5_5;
        com.instabug.crash.models.a a2;
        a.b b2;
        a.b b3 = b2;
        b3();
        com.instabug.crash.models.a a3 = a2 = b2.a((State)a2, (Context)var5_5, (boolean)var1_1);
        a3.a(object.toString());
        a3.a(a.a.b);
        a2.a((boolean)var1_1);
        a2.a((IBGNonFatalException.Level)var4_4);
        a2.d(new com.instabug.commons.threading.a(a.b.c.a, a.a.c.a).b().toString());
        object = fingerprint != null ? var3_3.toString() : null;
        com.instabug.crash.models.a a4 = a2;
        a4.b((String)object);
        return a4;
    }

    private static void reportUncaughtException(@NonNull JSONObject jsonObject) {
        JSONObject jSONObject;
        if (jsonObject == null) {
            return;
        }
        CrashReporting.reportException(jSONObject, false);
    }

    public static void setState(@NonNull Feature.State state) {
        VoidRunnable voidRunnable;
        Feature.State state2;
        InstabugSDKLogger.d((String)"IBG-CR", (String)("CrashReporting setState:" + state2));
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (this_.state2 == Feature.State.ENABLED && !com.instabug.crash.di.a.b().b()) {
                    InstabugSDKLogger.e((String)"Instabug-CrashReporting", (String)"crash reporting wasn't enabled as it seems to be disabled for your Instabug company account. Please, contact support to switch it on for you.");
                    return;
                }
                a a2 = this_;
                com.instabug.crash.configurations.b this_ = com.instabug.crash.di.a.b();
                boolean bl = a2.state2 == Feature.State.ENABLED;
                this_.b(bl);
                IBGCoreEventPublisher.post((IBGSdkCoreEvent)IBGSdkCoreEvent.Features.Updated.INSTANCE);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.setState", (VoidRunnable)voidRunnable2);
    }

    public static void setAnrState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (this_.state2 == Feature.State.ENABLED && !CrashReportingUtility.isCrashReportingEnabled()) {
                    InstabugSDKLogger.w((String)"IBG-CR", (String)"Can not enable ANR reporting while Crash reporting is disabled");
                    return;
                }
                b b2 = this_;
                com.instabug.anr.configuration.b this_ = com.instabug.anr.di.a.b();
                boolean bl = b2.state2 == Feature.State.ENABLED;
                this_.b(bl);
                IBGCoreEventPublisher.post((IBGSdkCoreEvent)IBGSdkCoreEvent.Features.Updated.INSTANCE);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.setAnrState", (VoidRunnable)voidRunnable2);
    }

    public static void setNDKCrashesState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (NDKCrashReportingFeatureStateChange.getInstance() != null) {
                    NDKCrashReportingFeatureStateChange.getInstance().post(state2);
                } else {
                    InstabugSDKLogger.e((String)"IBG-CR", (String)"Couldn't not enable NDK crash reporting state is null.");
                }
            }
        };
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.setNDKCrashesState", (VoidRunnable)voidRunnable2);
    }

    public static void setOnCrashSentCallback(@NonNull OnCrashSentCallback onCrashSentCallback) {
        CommonsLocator.setUserCrashMetadataCallback(onCrashSentCallback);
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.setOnCrashSentCallback", () -> {
            if (!com.instabug.crash.di.a.b().c()) {
                InstabugSDKLogger.e((String)"IBG-CR", (String)"CrashReporting.setOnCrashSentCallback Call won\u2019t take effect as CrashReporting is disabled. Please enable CrashReporting first.");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$reportException$1(JSONObject jsonObject, Map userAttributes, JSONObject fingerprint, IBGNonFatalException.Level level, String currentView) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        CrashReporting.saveAndReportException(jsonObject, true, (Map<String, String>)var1_1, (JSONObject)var2_2, (IBGNonFatalException.Level)var3_3, (String)var4_4);
    }
}

