/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.commons.snapshot;

import android.content.Context;
import com.instabug.commons.caching.SessionCacheDirectory;
import com.instabug.commons.di.CommonsLocator;
import com.instabug.commons.lifecycle.a;
import com.instabug.commons.logging.ExtensionsKt;
import com.instabug.commons.snapshot.FileKtxKt;
import com.instabug.commons.snapshot.a;
import com.instabug.commons.snapshot.b;
import com.instabug.library.model.State;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0002*+B\u001f\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b(\u0010)J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\b\u0010\b\u001a\u00020\u0006H\u0014J\b\u0010\t\u001a\u00020\u0006H\u0014J\b\u0010\n\u001a\u00020\u0006H\u0014J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016R\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0019\u001a\u00020\u0016*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u001b\u001a\u00020\u0016*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001f\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010#\u001a\u00020 8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010'\u001a\u00020$8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006,"}, d2={"Lcom/instabug/commons/snapshot/StateSnapshotCaptor;", "Lcom/instabug/commons/snapshot/a;", "Lcom/instabug/commons/lifecycle/a$b;", "Lcom/instabug/library/model/State;", "state", "updateReproStepsIfPossible", "", "setEligibleForScreenshots", "onStart", "onShutdown", "capture", "onActivityStarted", "onFragmentStarted", "Lcom/instabug/commons/snapshot/b;", "configurations", "Lcom/instabug/commons/snapshot/b;", "Lcom/instabug/commons/lifecycle/a;", "lifecycleOwner", "Lcom/instabug/commons/lifecycle/a;", "Lcom/instabug/library/visualusersteps/ReproConfigurationsProvider;", "reproConfigProvider", "Lcom/instabug/library/visualusersteps/ReproConfigurationsProvider;", "Ljava/io/File;", "getSnapshotFile", "(Ljava/io/File;)Ljava/io/File;", "snapshotFile", "getOldSnapshotFile", "oldSnapshotFile", "", "getId", "()I", "id", "", "getCaptorName", "()Ljava/lang/String;", "captorName", "", "getCapturingPeriod", "()J", "capturingPeriod", "<init>", "(Lcom/instabug/commons/snapshot/b;Lcom/instabug/commons/lifecycle/a;Lcom/instabug/library/visualusersteps/ReproConfigurationsProvider;)V", "Companion", "Factory", "instabug-crash_defaultUiRelease"})
public final class StateSnapshotCaptor
extends a
implements a.b {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int ID = 1;
    @NotNull
    public static final String STATE_SNAPSHOT_FILE_NAME = "snapshot";
    @NotNull
    public static final String OLD_STATE_SNAPSHOT_FILE_SUFFIX = "-old";
    @NotNull
    private static final String CAPTOR_NAME = "CrashesStateSnapshot";
    @NotNull
    private final b configurations;
    @NotNull
    private final com.instabug.commons.lifecycle.a lifecycleOwner;
    @NotNull
    private final ReproConfigurationsProvider reproConfigProvider;

    /*
     * WARNING - void declaration
     */
    public StateSnapshotCaptor(@NotNull b configurations, @NotNull com.instabug.commons.lifecycle.a lifecycleOwner, @NotNull ReproConfigurationsProvider reproConfigProvider) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"reproConfigProvider");
        super(var1_1.b());
        this.configurations = var1_1;
        this.lifecycleOwner = var2_2;
        this.reproConfigProvider = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final File getSnapshotFile(File $this$snapshotFile) {
        void var1_1;
        return new File(var1_1.getAbsolutePath() + File.separator + STATE_SNAPSHOT_FILE_NAME);
    }

    /*
     * WARNING - void declaration
     */
    private final File getOldSnapshotFile(File $this$oldSnapshotFile) {
        void var1_1;
        return new File(var1_1.getAbsolutePath() + OLD_STATE_SNAPSHOT_FILE_SUFFIX);
    }

    private final State updateReproStepsIfPossible(State state) {
        StateSnapshotCaptor stateSnapshotCaptor;
        StateSnapshotCaptor this_ = this_.reproConfigProvider.isReproStepsEnabled() ? stateSnapshotCaptor : null;
        if (this_ != null) {
            this_.updateVisualUserSteps();
            stateSnapshotCaptor = this_;
        }
        return stateSnapshotCaptor;
    }

    private final void setEligibleForScreenshots(State state) {
        state.setEligibleForScreenshots(this.reproConfigProvider.isReproScreenshotsEnabled());
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    @NotNull
    protected String getCaptorName() {
        return CAPTOR_NAME;
    }

    @Override
    protected long getCapturingPeriod() {
        return 5L;
    }

    @Override
    protected void onStart() {
        this.lifecycleOwner.a(this);
        ExtensionsKt.logVerbose("Starting state snapshot captor");
    }

    @Override
    protected void onShutdown() {
        this.lifecycleOwner.b(this);
        ExtensionsKt.logVerbose("Shutting down state snapshot captor");
    }

    @Override
    protected void capture() {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        File file = stateSnapshotCaptor3.configurations.c();
        if (file != null) {
            File file2 = stateSnapshotCaptor3.getSnapshotFile(file);
            if (!file2.exists()) {
                file2 = null;
            }
            if (file2 != null) {
                File file3 = file2;
                file2 = stateSnapshotCaptor3.getOldSnapshotFile(file2);
                file3.renameTo(file2);
            } else {
                file2 = null;
            }
            File file4 = stateSnapshotCaptor3.getSnapshotFile(file).getParentFile();
            if (file4 != null) {
                File file5 = file4;
                Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"parentFile");
                File file6 = file5.exists() ? file4 : null;
                if (file6 == null) {
                    file4.mkdirs();
                }
            }
            if ((file4 = stateSnapshotCaptor3.configurations.a()) != null) {
                StateSnapshotCaptor stateSnapshotCaptor = stateSnapshotCaptor3;
                StateSnapshotCaptor stateSnapshotCaptor2 = stateSnapshotCaptor3;
                StateSnapshotCaptor stateSnapshotCaptor3 = new State.Builder((Context)file4).build(true, true, 1.0f, false);
                stateSnapshotCaptor2.updateReproStepsIfPossible((State)stateSnapshotCaptor3);
                stateSnapshotCaptor2.setEligibleForScreenshots((State)stateSnapshotCaptor3);
                FileKtxKt.writeSerializable(stateSnapshotCaptor.getSnapshotFile(file), (Serializable)((Object)stateSnapshotCaptor3));
            }
            if (file2 != null) {
                file2.delete();
            }
        }
    }

    public void onActivityStarted() {
        ExtensionsKt.logVerbose("StateSnapshotCaptor: Activity started");
        this.force();
    }

    public void onFragmentStarted() {
        ExtensionsKt.logVerbose("StateSnapshotCaptor: Fragment started");
        this.force();
    }

    @Metadata(mv={1, 7, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012JW\u0010\u0010\u001a\u00020\u000f2\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00022\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0087\u0002\u00a8\u0006\u0013"}, d2={"Lcom/instabug/commons/snapshot/StateSnapshotCaptor$Factory;", "", "Lkotlin/Function0;", "Landroid/content/Context;", "ctxGetter", "Ljava/io/File;", "savingDirectoryGetter", "Lkotlin/Function1;", "", "Ljava/util/concurrent/ScheduledExecutorService;", "executorFactory", "Lcom/instabug/commons/lifecycle/a;", "lifecycleOwner", "Lcom/instabug/library/visualusersteps/ReproConfigurationsProvider;", "reproConfigProvider", "Lcom/instabug/commons/snapshot/StateSnapshotCaptor;", "invoke", "<init>", "()V", "instabug-crash_defaultUiRelease"})
    public static final class Factory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final StateSnapshotCaptor invoke(@NotNull Function0<? extends Context> ctxGetter, @NotNull Function0<? extends File> savingDirectoryGetter, @NotNull Function1<? super String, ? extends ScheduledExecutorService> executorFactory, @NotNull com.instabug.commons.lifecycle.a lifecycleOwner, @NotNull ReproConfigurationsProvider reproConfigProvider) {
            void var4_4;
            b b2;
            void var3_3;
            void var2_2;
            void var1_1;
            Function0<? extends Context> function0;
            Intrinsics.checkNotNullParameter(function0, (String)"ctxGetter");
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"savingDirectoryGetter");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"executorFactory");
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"lifecycleOwner");
            Intrinsics.checkNotNullParameter((Object)reproConfigProvider, (String)"reproConfigProvider");
            b b3 = b2;
            b2 = new b(function0, (Function0)var1_1, (Function1)var2_2);
            return new StateSnapshotCaptor(b3, (com.instabug.commons.lifecycle.a)var3_3, (ReproConfigurationsProvider)var4_4);
        }

        public static /* synthetic */ StateSnapshotCaptor invoke$default(Function0 object, Function0 object2, Function1 function1, com.instabug.commons.lifecycle.a a2, ReproConfigurationsProvider reproConfigurationsProvider, int n2, Object object3) {
            if ((n2 & 1) != 0) {
                PropertyReference0Impl propertyReference0Impl;
                object = propertyReference0Impl;
                propertyReference0Impl = new PropertyReference0Impl(CommonsLocator.INSTANCE){
                    {
                        void var1_1;
                    }

                    public Object get() {
                        return ((CommonsLocator)this.receiver).getAppCtx();
                    }
                };
            }
            if ((n2 & 2) != 0) {
                PropertyReference0Impl propertyReference0Impl;
                object2 = propertyReference0Impl;
                propertyReference0Impl = new PropertyReference0Impl(CommonsLocator.getCrashesCacheDir()){
                    {
                        void var1_1;
                    }

                    public Object get() {
                        return ((SessionCacheDirectory)this.receiver).getCurrentSessionDirectory();
                    }
                };
            }
            if ((n2 & 4) != 0) {
                Function1 function12;
                function1 = function12;
                function12 = new Function1(CommonsLocator.INSTANCE){
                    {
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final ScheduledExecutorService a(String p0) {
                        void var1_1;
                        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"p0");
                        return ((CommonsLocator)this.receiver).getScheduledExecutor((String)var1_1);
                    }
                };
            }
            if ((n2 & 8) != 0) {
                a2 = CommonsLocator.INSTANCE.getCompositeLifecycleOwner();
            }
            if ((n2 & 0x10) != 0) {
                reproConfigurationsProvider = CommonsLocator.INSTANCE.getConfigurationsProvider();
            }
            return Factory.invoke((Function0<? extends Context>)object, (Function0<? extends File>)object2, (Function1<? super String, ? extends ScheduledExecutorService>)function1, a2, reproConfigurationsProvider);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final StateSnapshotCaptor invoke(@NotNull Function0<? extends Context> ctxGetter, @NotNull Function0<? extends File> savingDirectoryGetter, @NotNull Function1<? super String, ? extends ScheduledExecutorService> executorFactory, @NotNull com.instabug.commons.lifecycle.a lifecycleOwner) {
            void var3_3;
            void var2_2;
            void var1_1;
            Function0<? extends Context> function0;
            Intrinsics.checkNotNullParameter(function0, (String)"ctxGetter");
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"savingDirectoryGetter");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"executorFactory");
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"lifecycleOwner");
            return Factory.invoke$default(ctxGetter, (Function0)var1_1, (Function1)var2_2, (com.instabug.commons.lifecycle.a)var3_3, null, 16, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final StateSnapshotCaptor invoke(@NotNull Function0<? extends Context> ctxGetter, @NotNull Function0<? extends File> savingDirectoryGetter, @NotNull Function1<? super String, ? extends ScheduledExecutorService> executorFactory) {
            void var2_2;
            void var1_1;
            Function0<? extends Context> function0;
            Intrinsics.checkNotNullParameter(function0, (String)"ctxGetter");
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"savingDirectoryGetter");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"executorFactory");
            return Factory.invoke$default(ctxGetter, (Function0)var1_1, (Function1)var2_2, null, null, 24, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final StateSnapshotCaptor invoke(@NotNull Function0<? extends Context> ctxGetter, @NotNull Function0<? extends File> savingDirectoryGetter) {
            Function0<? extends Context> function0;
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter(function0, (String)"ctxGetter");
            Intrinsics.checkNotNullParameter((Object)v0, (String)"savingDirectoryGetter");
            return Factory.invoke$default(ctxGetter, (Function0)v0, null, null, null, 28, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final StateSnapshotCaptor invoke(@NotNull Function0<? extends Context> ctxGetter) {
            Function0<? extends Context> function0 = ctxGetter;
            Intrinsics.checkNotNullParameter(function0, (String)"ctxGetter");
            return Factory.invoke$default(function0, null, null, null, null, 30, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final StateSnapshotCaptor invoke() {
            return Factory.invoke$default(null, null, null, null, null, 31, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/instabug/commons/snapshot/StateSnapshotCaptor$Companion;", "", "()V", "CAPTOR_NAME", "", "ID", "", "OLD_STATE_SNAPSHOT_FILE_SUFFIX", "STATE_SNAPSHOT_FILE_NAME", "getOldSnapshotFile", "Ljava/io/File;", "sessionDirectory", "getSnapshotFile", "instabug-crash_defaultUiRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final File getSnapshotFile(@NotNull File sessionDirectory) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sessionDirectory, (String)"sessionDirectory");
            return new File(var1_1.getAbsolutePath() + File.separator + StateSnapshotCaptor.STATE_SNAPSHOT_FILE_NAME);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final File getOldSnapshotFile(@NotNull File sessionDirectory) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"sessionDirectory");
            File this_ = ((Companion)((Object)this_)).getSnapshotFile((File)v0);
            return new File(this_.getAbsolutePath() + StateSnapshotCaptor.OLD_STATE_SNAPSHOT_FILE_SUFFIX);
        }
    }
}

