/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.instabug.anr.e.a;
import com.instabug.crash.f.c;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventSubscriber;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.lang.ref.WeakReference;

public class CrashPlugin
extends Plugin
implements com.instabug.anr.a {
    @Nullable
    public Disposable subscribe;
    @Nullable
    private com.instabug.anr.b anrDetectorThread;

    private void startAnrsUploaderService() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null) {
            if ((weakReference = (Context)weakReference.get()) != null) {
                PoolProvider.postIOTask((Runnable)new Runnable(this, (Context)weakReference){
                    final /* synthetic */ Context a;
                    {
                        this.a = context;
                    }

                    @Override
                    public void run() {
                        if (this.a == null) {
                            return;
                        }
                        if (com.instabug.anr.d.a.a() > 0 && NetworkManager.isOnline((Context)this.a)) {
                            com.instabug.anr.f.b.a().start();
                        }
                    }
                });
            } else {
                InstabugSDKLogger.e((Object)this, (String)"Couldn't start ANRs uploader Service because Context is null.");
            }
        } else {
            InstabugSDKLogger.e((Object)this, (String)"Couldn't start ANRs uploader Service because Context WeakReference is null.");
        }
    }

    private void startCrashesUploaderService() {
        InstabugSDKLogger.d((Object)"CrashPlugin", (String)"startCrashesUploaderService");
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null) {
            if ((weakReference = (Context)weakReference.get()) != null) {
                PoolProvider.postIOTask((Runnable)new Runnable((Context)weakReference){
                    final /* synthetic */ Context a;
                    {
                        this.a = context;
                    }

                    @Override
                    public void run() {
                        if (this.a == null) {
                            return;
                        }
                        int n = com.instabug.crash.b.b.b();
                        InstabugSDKLogger.d((Object)"CrashPlugin", (String)("Found " + n + " cached crashes"));
                        if (n > 0) {
                            if (n > 100) {
                                CrashPlugin.this.trimCrashes();
                            }
                            if (NetworkManager.isOnline((Context)this.a)) {
                                com.instabug.crash.d.b.b().start();
                            }
                        }
                    }
                });
            } else {
                InstabugSDKLogger.e((Object)this, (String)"Context is null.");
            }
        } else {
            InstabugSDKLogger.e((Object)this, (String)"Context WeakReference is null.");
        }
    }

    private void setExceptionHandler() {
        InstabugSDKLogger.d((Object)"CrashPlugin", (String)"setting Uncaught Exception Handler com.instabug.crash.InstabugUncaughtExceptionHandler");
        Thread.setDefaultUncaughtExceptionHandler(new com.instabug.crash.a());
    }

    @WorkerThread
    private void checkEncryptorVersion() {
        InstabugSDKLogger.d((Object)"CrashPlugin", (String)"CrashPlugin checking EncryptorVersion");
        if (com.instabug.crash.f.a.c().b()) {
            InstabugSDKLogger.d((Object)"CrashPlugin", (String)"CrashPlugin checking EncryptorVersion > firstRunAfterEncryptorUpdate");
            com.instabug.crash.b.a.a();
        }
    }

    @WorkerThread
    private void trimCrashes() {
        com.instabug.crash.b.a.b();
    }

    private void startAnrDetectionIfPossible() {
        if (this.canStartAnrDetection()) {
            this.startAnrDetection();
        }
    }

    private boolean canStartAnrDetection() {
        return this.isAnrEnabled() && this.anrDetectorThread == null && this.hasStartedActivities();
    }

    private boolean hasStartedActivities() {
        return InstabugCore.getStartedActivitiesCount() > 0;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ com.instabug.anr.b access$402(CrashPlugin x0, com.instabug.anr.b x1) {
        void var1_1;
        var0.anrDetectorThread = var1_1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    public void init(Context context) {
        void var1_1;
        CrashPlugin crashPlugin = this;
        InstabugSDKLogger.d((Object)"CrashPlugin", (String)"CrashPlugin init");
        super.init((Context)var1_1);
        crashPlugin.setExceptionHandler();
    }

    public void stop() {
        InstabugSDKLogger.d((Object)"CrashPlugin", (String)"CrashPlugin stop");
        Disposable disposable = this.subscribe;
        if (disposable != null) {
            disposable.dispose();
        }
        com.instabug.crash.f.a.d();
        this.anrDetectorThread = null;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public void start(Context context) {
        void var1_1;
        InstabugSDKLogger.d((Object)"CrashPlugin", (String)"CrashPlugin start");
        PoolProvider.postIOTaskWithCheck((Runnable)new Runnable((Context)var1_1){
            final /* synthetic */ Context a;
            {
                this.a = context;
            }

            @Override
            public void run() {
                a a2 = this;
                com.instabug.crash.f.a.a(a2.a);
                a2.CrashPlugin.this.checkEncryptorVersion();
                a2.CrashPlugin.this.subscribeOnSDKEvents();
            }
        });
    }

    @Nullable
    @VisibleForTesting
    public com.instabug.anr.b getAnrDetectorThread() {
        return this.anrDetectorThread;
    }

    public boolean isAnrEnabled() {
        return com.instabug.crash.g.a.a() && this.isAnrStateEnabled();
    }

    @VisibleForTesting
    public boolean isAnrStateEnabled() {
        return InstabugCore.getFeatureState((Feature)Feature.ANR_REPORTING) == Feature.State.ENABLED;
    }

    public void wake() {
        InstabugSDKLogger.d((Object)"CrashPlugin", (String)"CrashPlugin wake");
        this.startAnrDetectionIfPossible();
    }

    public void startAnrDetection() {
        if (Instabug.isEnabled()) {
            com.instabug.anr.b b2;
            com.instabug.anr.c c2;
            a.a a2;
            a.a a3 = a2;
            a2 = new a.a();
            com.instabug.anr.c c3 = c2;
            c2 = new com.instabug.anr.c();
            com.instabug.anr.b b3 = b2;
            b3(this, a3, c3);
            this.anrDetectorThread = b3;
            b2.start();
        }
    }

    public void sleep() {
        InstabugSDKLogger.d((Object)"CrashPlugin", (String)"CrashPlugin sleep");
        com.instabug.anr.b b2 = this.anrDetectorThread;
        if (b2 != null) {
            b2.interrupt();
            this.anrDetectorThread = null;
        }
    }

    public long getLastActivityTime() {
        return com.instabug.crash.f.a.c().a();
    }

    public boolean isFeatureEnabled() {
        return InstabugCore.isFeatureEnabled((Feature)Feature.CRASH_REPORTING);
    }

    public void subscribeOnSDKEvents() {
        this.subscribe = this.getSDKEventSubscriber();
    }

    public Disposable getSDKEventSubscriber() {
        return SDKCoreEventSubscriber.subscribe((Consumer)new Consumer<SDKCoreEvent>(){

            public void a(SDKCoreEvent sDKCoreEvent) {
                String string = sDKCoreEvent.getType();
                int n = -1;
                int n2 = string.hashCode();
                if (n2 != -290659267) {
                    if (n2 != 3599307) {
                        if (n2 != 1843485230) {
                            if (n2 == 1984987798 && string.equals("session")) {
                                n = 3;
                            }
                        } else if (string.equals("network")) {
                            n = 1;
                        }
                    } else if (string.equals("user")) {
                        n = 0;
                    }
                } else if (string.equals("features")) {
                    n = 2;
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        InstabugSDKLogger.d((Object)"CrashPlugin", (String)("CrashPlugin SESSION event with value " + sDKCoreEvent.getValue() + " received"));
                        if (!sDKCoreEvent.getValue().equals("started")) break;
                        CrashPlugin.this.startAnrDetectionIfPossible();
                        break;
                    }
                    case 2: {
                        InstabugSDKLogger.d((Object)"CrashPlugin", (String)("CrashPlugin FEATURE event with value " + sDKCoreEvent.getValue() + " received"));
                        if (!sDKCoreEvent.getValue().equals("fetched") && !sDKCoreEvent.getValue().equals("updated")) break;
                        if (CrashPlugin.this.isAnrEnabled()) {
                            CrashPlugin.this.startAnrDetectionIfPossible();
                            break;
                        }
                        if (CrashPlugin.this.anrDetectorThread == null) break;
                        b b2 = this;
                        b2.CrashPlugin.this.anrDetectorThread.interrupt();
                        CrashPlugin.access$402(b2.CrashPlugin.this, null);
                        break;
                    }
                    case 1: {
                        InstabugSDKLogger.d((Object)"CrashPlugin", (String)("CrashPlugin NETWORK event with value " + sDKCoreEvent.getValue() + " received"));
                        if (!sDKCoreEvent.getValue().equals("activated")) break;
                        if (com.instabug.crash.g.a.a()) {
                            CrashPlugin.this.startCrashesUploaderService();
                        }
                        if (!CrashPlugin.this.isAnrEnabled()) break;
                        CrashPlugin.this.startAnrsUploaderService();
                        break;
                    }
                    case 0: {
                        if (!sDKCoreEvent.getValue().equals("logged_out")) break;
                        CrashPlugin.this.clearUserActivities();
                    }
                }
            }
        });
    }

    public void clearUserActivities() {
        if (c.c() == null) {
            return;
        }
        c.c().a(0L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @WorkerThread
    public void onAnrDetected(com.instabug.anr.e.a anr) {
        void var1_1;
        void v0 = var1_1;
        v0.a(1);
        com.instabug.anr.d.a.a((com.instabug.anr.e.a)v0);
        CrashPlugin this_ = this_.getAppContext();
        if (this_ != null && NetworkManager.isOnline((Context)this_)) {
            com.instabug.anr.f.b.a().start();
        }
    }
}

