/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.network;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.cache.AttachmentsDbHelper;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.observers.DisposableObserver;
import java.io.File;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class a {
    private static a b;
    private NetworkManager a;

    private a() {
        NetworkManager networkManager;
        a a2 = networkManager;
        networkManager = new NetworkManager();
        v1.a = a2;
    }

    public static a a() {
        if (b == null) {
            b = new a();
        }
        return b;
    }

    @NonNull
    private DisposableObserver<RequestResponse> a(final com.instabug.crash.c.a a2, final Request.Callbacks<Boolean, com.instabug.crash.c.a> callbacks) {
        return new DisposableObserver<RequestResponse>(this){

            public void onStart() {
                InstabugSDKLogger.d((Object)"CrashesService", (String)"uploadingCrashAttachmentRequest started");
            }

            public void onComplete() {
                InstabugSDKLogger.d((Object)"CrashesService", (String)"uploadingCrashAttachmentRequest completed");
                if (a2.a().size() == 0) {
                    callbacks.onSucceeded((Object)true);
                }
            }

            public void onError(@NonNull Throwable throwable) {
                InstabugSDKLogger.d((Object)"CrashesService", (String)("uploadingCrashAttachmentRequest got error: " + throwable.getMessage()));
                callbacks.onFailed((Object)a2);
            }

            public void a(@NonNull RequestResponse requestResponse) {
                InstabugSDKLogger.addVerboseLog((Object)"CrashesService", (String)("uploadingCrashAttachmentRequest onNext, Response code: " + requestResponse.getResponseCode() + ", Response body: " + requestResponse.getResponseBody()));
                if (a2.a().get(0).getLocalPath() != null) {
                    requestResponse = a2.a().remove(0);
                    if (!new File(a2.a().get(0).getLocalPath()).delete()) {
                        InstabugSDKLogger.w((Object)"CrashesService", (String)("Attachment: " + requestResponse + " is not removed"));
                    } else {
                        InstabugSDKLogger.d((Object)"CrashesService", (String)("Attachment: " + requestResponse + " is removed"));
                    }
                    if (requestResponse.getId() != -1L) {
                        AttachmentsDbHelper.delete((long)requestResponse.getId());
                    } else if (requestResponse.getName() != null) {
                        AttachmentsDbHelper.delete((String)requestResponse.getName(), (String)a2.d());
                    }
                }
            }
        };
    }

    @NonNull
    private DisposableObserver<RequestResponse> b(final com.instabug.crash.c.a a2, final Request.Callbacks<Boolean, com.instabug.crash.c.a> callbacks) {
        return new DisposableObserver<RequestResponse>(this){

            public void onStart() {
                InstabugSDKLogger.d((Object)"CrashesService", (String)"uploading crash logs started");
            }

            public void a(@NonNull RequestResponse requestResponse) {
                InstabugSDKLogger.addVerboseLog((Object)"CrashesService", (String)("uploading crash logs onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody()));
            }

            public void onComplete() {
                InstabugSDKLogger.d((Object)"CrashesService", (String)"uploading crash logs completed");
                callbacks.onSucceeded((Object)true);
            }

            public void onError(@NonNull Throwable throwable) {
                InstabugSDKLogger.d((Object)"CrashesService", (String)("uploading crash logs got error: " + throwable.getMessage()));
                callbacks.onFailed((Object)a2);
            }
        };
    }

    public void a(Context disposableObserver, com.instabug.crash.c.a a2, Request.Callbacks<String, Throwable> callbacks) throws JSONException {
        a a3 = a4;
        InstabugSDKLogger.d((Object)"CrashesService", (String)("Reporting crash with crash message: " + a2.b()));
        a a4 = a4.b((Context)disposableObserver, a2);
        disposableObserver = a3.a(callbacks, a2);
        a3.a.doRequest((Request)a4).subscribe(disposableObserver);
    }

    @NonNull
    @VisibleForTesting
    public Request b(Context object, com.instabug.crash.c.a a2) throws JSONException {
        a a3 = a3.a.buildRequest((Context)object, Request.Endpoint.REPORT_CRASH, Request.RequestMethod.Post);
        if (a2.b() != null && a2.b().contains("InstabugSDK-v: ")) {
            a3.addRequestBodyParameter("application_token", "b1a9630002b2cbdfbfecd942744b9018");
        }
        if ((object = a2.f().getStateItems()) != null && ((ArrayList)object).size() > 0) {
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                InstabugSDKLogger.d((Object)"CrashesService", (String)("Crash State Key: " + ((State.StateItem)((ArrayList)object).get(i)).getKey() + ", Crash State value: " + ((State.StateItem)((ArrayList)object).get(i)).getValue()));
                if (((State.StateItem)((ArrayList)object).get(i)).getKey() == null) continue;
                String string = ((State.StateItem)((ArrayList)object).get(i)).getKey();
                a3.addRequestBodyParameter(string, ((State.StateItem)((ArrayList)object).get(i)).getValue());
            }
        }
        a3.addRequestBodyParameter("title", a2.b());
        a3.addRequestBodyParameter("handled", a2.i());
        a3.addRequestBodyParameter("threads_details", a2.h());
        if (a2.a() != null && a2.a().size() > 0) {
            a3.addRequestBodyParameter("attachments_count", a2.a().size());
        }
        return a3;
    }

    @NonNull
    public DisposableObserver<RequestResponse> a(final Request.Callbacks<String, Throwable> callbacks, final com.instabug.crash.c.a a2) {
        return new DisposableObserver<RequestResponse>(this){

            public void onStart() {
            }

            public void onComplete() {
            }

            public void onError(@NonNull Throwable throwable) {
                a a22 = this;
                InstabugSDKLogger.e((Object)"CrashesService", (String)"reportingCrashRequest got error: ", (Throwable)throwable);
                AttachmentsUtility.encryptAttachmentsAndUpdateDb(a22.a2.a());
                a22.callbacks.onFailed((Object)throwable);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void a(@NonNull RequestResponse requestResponse) {
                InstabugSDKLogger.addVerboseLog((Object)"CrashesService", (String)("reportingCrashRequest onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody()));
                try {
                    if (requestResponse.getResponseBody() != null) {
                        callbacks.onSucceeded((Object)new JSONObject((String)requestResponse.getResponseBody()).getString("id"));
                        return;
                    }
                    callbacks.onFailed((Object)new JSONException("requestResponse.getResponseBody() returned null"));
                    return;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        };
    }

    public void b(Context context, com.instabug.crash.c.a a2, Request.Callbacks<Boolean, com.instabug.crash.c.a> callbacks) throws JSONException {
        InstabugSDKLogger.d((Object)"CrashesService", (String)"Uploading Crash attachments");
        ArrayList<Observable<RequestResponse>> arrayList = disposableObserver.c(context, a2);
        DisposableObserver<RequestResponse> disposableObserver = disposableObserver.a(a2, callbacks);
        Observable.merge(arrayList, (int)1).subscribe(disposableObserver);
    }

    @NonNull
    @VisibleForTesting
    public ArrayList<Observable<RequestResponse>> c(Context context, com.instabug.crash.c.a a2) throws JSONException {
        ArrayList<Observable<RequestResponse>> arrayList;
        ArrayList<Observable<RequestResponse>> arrayList2 = arrayList;
        arrayList = new ArrayList<Observable<RequestResponse>>(a2.a().size());
        for (int i = 0; i < a2.a().size(); ++i) {
            Attachment attachment = a2.a().get(i);
            if (AttachmentsUtility.decryptAttachmentAndUpdateDb((Attachment)attachment)) {
                Request request = this.a(context, a2, attachment);
                if (attachment.getLocalPath() != null) {
                    File file;
                    File file2 = file;
                    if (new File(attachment.getLocalPath()).exists() && file2.length() > 0L) {
                        attachment.setAttachmentState(Attachment.AttachmentState.SYNCED);
                        arrayList2.add((Observable<RequestResponse>)this.a.doRequest(request));
                        continue;
                    }
                    InstabugSDKLogger.w((Object)"CrashesService", (String)("Skipping attachment file of type " + attachment.getType() + " because it's either not found or empty file"));
                    continue;
                }
                InstabugSDKLogger.w((Object)"CrashesService", (String)("Skipping attachment file of type " + attachment.getType() + " because it's either not found or empty file"));
                continue;
            }
            InstabugSDKLogger.w((Object)"CrashesService", (String)("Skipping attachment file of type " + attachment.getType() + " because it was not decrypted successfully"));
        }
        return arrayList2;
    }

    @NonNull
    @VisibleForTesting
    public Request a(Context context, com.instabug.crash.c.a object, Attachment object2) throws JSONException {
        Context context2 = context;
        a a2 = Request.Endpoint.ADD_CRASH_ATTACHMENT;
        context = NetworkManager.RequestType.MULTI_PART;
        a a3 = a2 = a2.a.buildRequest(context2, (Request.Endpoint)a2, Request.RequestMethod.Post, (NetworkManager.RequestType)context);
        a3.setEndpoint(a3.getEndpoint().replaceAll(":crash_token", ((com.instabug.crash.c.a)object).g()));
        a2.addParameter("metadata[file_type]", object2.getType());
        if (object2.getType() == Attachment.Type.AUDIO) {
            a2.addParameter("metadata[duration]", object2.getDuration());
        }
        if (object2.getName() != null && object2.getLocalPath() != null) {
            Request.FileToUpload fileToUpload;
            context = fileToUpload;
            Attachment attachment = object2;
            object = attachment.getName();
            object2 = attachment.getLocalPath();
            String string = attachment.getFileType();
            fileToUpload = new Request.FileToUpload("file", (String)object, (String)object2, string);
            a2.setFileToUpload((Request.FileToUpload)context);
        }
        return a2;
    }

    public void c(Context disposableObserver, com.instabug.crash.c.a a2, Request.Callbacks<Boolean, com.instabug.crash.c.a> callbacks) {
        a a3 = a7;
        a a4 = a3;
        a a5 = a3;
        com.instabug.crash.c.a a6 = a2;
        Request.Callbacks<Boolean, com.instabug.crash.c.a> callbacks2 = callbacks;
        a a7 = a7.a((Context)disposableObserver, a2);
        disposableObserver = a4.b(a6, callbacks2);
        try {
            a5.a.doRequest((Request)a7).subscribe(disposableObserver);
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.d((Object)"CrashesService", (String)("uploading crash logs got Json error: " + jSONException.getMessage()));
            callbacks.onFailed((Object)a2);
        }
    }

    @NonNull
    @VisibleForTesting
    public Request a(Context object, com.instabug.crash.c.a object2) throws JSONException {
        a a2 = a2.a.buildRequest((Context)object, Request.Endpoint.CRASH_LOGS, Request.RequestMethod.Post);
        a2.setEndpoint(a2.getEndpoint().replaceAll(":crash_token", ((com.instabug.crash.c.a)object2).g()));
        object = ((com.instabug.crash.c.a)object2).f().getLogsItems();
        if (object != null && ((ArrayList)object).size() > 0) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                object2 = (State.StateItem)object.next();
                if (object2.getKey() == null) continue;
                com.instabug.crash.c.a a3 = object2;
                object2 = a3.getKey();
                a2.addRequestBodyParameter((String)object2, a3.getValue());
            }
        }
        return a2;
    }
}

