/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.d;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.network.a;
import com.instabug.library.network.authorization.NetworkOfficer;
import com.instabug.library.network.c;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.json.JSONException;

public class NetworkManager
implements a {
    public static final String TAG = "NetworkManager";
    public static final String APP_TOKEN = "application_token";
    public static final String UUID = "uuid";
    private static final int DEFAULT_READ_TIME_OUT = 10000;
    private static final int DEFAULT_CONNECTION_TIME_OUT = 15000;
    @Nullable
    private OnDoRequestListener onDoRequestListener;

    public static boolean isOnline(Context context) {
        block7: {
            if (context != null) {
                Context context2;
                context2 = (ConnectivityManager)context2.getSystemService("connectivity");
                if (context2 == null) break block7;
                context2 = context2.getActiveNetworkInfo();
                if (context2 == null) break block7;
                try {
                    if (context2.isConnectedOrConnecting()) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(TAG, "Something went wrong while checking network state", exception);
                }
                catch (SecurityException securityException) {
                    InstabugSDKLogger.w(TAG, "Could not read network state. To enable please add the following line in your AndroidManifest.xml <uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\"/>\n" + securityException.getMessage());
                }
            }
        }
        return false;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private Request buildRequest(@NonNull Context context, Request request) throws JSONException {
        Request.RequestParameter requestParameter;
        Request request2 = request;
        request2.addParameter(APP_TOKEN, Instabug.getAppToken());
        request2.addParameter(UUID, com.instabug.library.user.b.h());
        Request.RequestParameter requestParameter2 = requestParameter;
        requestParameter = new Request.RequestParameter("IBG-SDK-VERSION", DeviceStateProvider.getSdkVersion());
        request2.addHeader(requestParameter2);
        return request2;
    }

    /*
     * WARNING - void declaration
     */
    private HttpURLConnection setURLConnectionDefaultTimeOut(HttpURLConnection httpURLConnection) {
        void var1_1;
        return this.setURLConnectionTimeOut((HttpURLConnection)var1_1, 10000, 15000);
    }

    /*
     * WARNING - void declaration
     */
    private HttpURLConnection connectWithNormalType(Request request) throws Exception {
        void var1_1;
        NetworkManager networkManager = outputStream;
        InstabugSDKLogger.d(TAG, "Connect to: " + var1_1.getRequestUrl() + " with normal type");
        HttpURLConnection httpURLConnection = networkManager.buildConnection((Request)var1_1);
        networkManager.setURLConnectionDefaultTimeOut(httpURLConnection);
        if (request.getRequestMethod() != null) {
            httpURLConnection.setRequestMethod(var1_1.getRequestMethod().toString());
        }
        if (var1_1.getRequestMethod() == Request.RequestMethod.Post || var1_1.getRequestMethod() == Request.RequestMethod.put) {
            NetworkManager networkManager2 = outputStream;
            HttpURLConnection httpURLConnection2 = httpURLConnection;
            httpURLConnection2.setDoOutput(true);
            OutputStream outputStream = httpURLConnection2.getOutputStream();
            networkManager2.writeRequestBody(outputStream, var1_1.getRequestBody());
        }
        return httpURLConnection;
    }

    /*
     * WARNING - void declaration
     */
    private void writeRequestBody(OutputStream outputStream, String requestBody) throws IOException {
        void var1_1;
        void var2_2;
        ByteArrayOutputStream byteArrayOutputStream;
        Object object = this = byteArrayOutputStream;
        ((ByteArrayOutputStream)object)();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)this);
        gZIPOutputStream.write(var2_2.getBytes(Charset.forName("UTF8")));
        gZIPOutputStream.close();
        var1_1.write(((ByteArrayOutputStream)object).toByteArray());
        byteArrayOutputStream.close();
    }

    /*
     * WARNING - void declaration
     */
    private HttpURLConnection connectWithFileDownloadType(Request request) throws Exception {
        void var1_1;
        InstabugSDKLogger.d(TAG, "Connect to: " + var1_1.getRequestUrl() + " with fileDownload type");
        return this.connectWithNormalType((Request)var1_1);
    }

    @SuppressLint(value={"RESOURCE_LEAK"})
    private HttpURLConnection connectWithMultiPartType(Request request) throws Exception {
        c c2;
        Object object;
        InstabugSDKLogger.d(TAG, "Connect to: " + ((Request)object).getRequestUrl() + " with multiPart type");
        HttpURLConnection httpURLConnection = ((NetworkManager)((Object)httpURLConnection)).buildConnection((Request)object);
        if (request.getRequestMethod() != null) {
            httpURLConnection.setRequestMethod(((Request)object).getRequestMethod().toString());
        }
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        httpURLConnection2.setRequestProperty("Connection", "Keep-Alive");
        httpURLConnection2.setRequestProperty("Cache-Control", "no-cache");
        httpURLConnection2.setRequestProperty("Content-Encoding", "");
        c c3 = c2;
        c2 = new c(httpURLConnection);
        for (Serializable serializable : ((Request)object).getRequestBodyParameters()) {
            c3.a(serializable.getKey(), serializable.getValue().toString());
        }
        if ((object = ((Request)object).getFileToUpload()) != null) {
            File file;
            Serializable serializable;
            Request.FileToUpload fileToUpload = object;
            String string2 = fileToUpload.getFilePartName();
            serializable = file;
            file = new File(((Request.FileToUpload)object).getFilePath());
            object = fileToUpload.getFileName();
            String string3 = fileToUpload.getFileType();
            c3.a(string2, (File)serializable, (String)object, string3);
        }
        c3.a();
        return httpURLConnection;
    }

    /*
     * WARNING - void declaration
     */
    private RequestResponse handleRequestResponse(HttpURLConnection connection) throws IOException {
        void var1_3;
        RequestResponse requestResponse;
        RequestResponse requestResponse2 = requestResponse;
        requestResponse2();
        int n2 = var1_3.getResponseCode();
        requestResponse2.setResponseCode(n2);
        requestResponse2.setHeaders(this.getHeaderFields((HttpURLConnection)var1_3));
        InstabugSDKLogger.d(TAG, "Request response code: " + n2);
        String string2 = this.convertStreamToString(var1_3.getInputStream());
        requestResponse2.setResponseBody(string2);
        InstabugSDKLogger.addVerboseLog(TAG, "Request response: " + string2);
        var1_3.disconnect();
        return requestResponse;
    }

    /*
     * WARNING - void declaration
     */
    private RequestResponse handleMultipartRequestResponse(HttpURLConnection connection) throws IOException {
        void var1_1;
        return this.handleRequestResponse((HttpURLConnection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"RESOURCE_LEAK"})
    private RequestResponse handleFileDownloadRequestResponse(Request request, HttpURLConnection connection) throws IOException {
        void var2_2;
        RequestResponse requestResponse;
        RequestResponse requestResponse2 = requestResponse;
        requestResponse2();
        int n2 = var2_2.getResponseCode();
        requestResponse2.setResponseCode(n2);
        requestResponse.setHeaders(this.getHeaderFields((HttpURLConnection)var2_2));
        InstabugSDKLogger.d(TAG, "File downloader request response code: " + n2);
        File file = request.getDownloadedFile();
        if (file != null) {
            this.copyStream(var2_2.getInputStream(), new FileOutputStream(file));
            requestResponse2.setResponseBody(file);
            InstabugSDKLogger.addVerboseLog(TAG, "File downloader request response: " + file.getPath());
        } else {
            requestResponse2.setResponseBody(null);
            InstabugSDKLogger.addVerboseLog(TAG, "File downloader request response is null");
        }
        var2_2.disconnect();
        return requestResponse2;
    }

    /*
     * WARNING - void declaration
     */
    private void handleServerConnectionError(HttpURLConnection connection) throws IOException {
        block5: {
            void var1_2;
            HttpURLConnection httpURLConnection = connection;
            InputStream inputStream = httpURLConnection.getErrorStream();
            if (httpURLConnection.getURL() == null) break block5;
            if (!this.isInstabugRequest(var1_2.getURL().toString())) break block5;
            InstabugSDKLogger.e(TAG, "Network request got error");
            try {
                InstabugSDKLogger.e(TAG, "Error getting Network request response: " + this.convertStreamToString(inputStream));
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e(TAG, outOfMemoryError.getMessage(), outOfMemoryError);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInstabugRequest(String url) {
        if (url != null) {
            void var1_1;
            return var1_1.startsWith("https://api.instabug.com/api/sdk/v3");
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"RESOURCE_LEAK"})
    private String convertStreamToString(InputStream is) {
        block23: {
            this = null;
            var2_5 = v0;
            try {
                v0 = new BufferedReader(new InputStreamReader((InputStream)var1_4, "UTF-8"));
            }
            catch (Throwable var2_6) {
                break block23;
            }
            catch (Exception var2_7) {
                // empty catch block
                ** GOTO lbl-1000
            }
            catch (OutOfMemoryError var2_8) {
                // empty catch block
                ** GOTO lbl-1000
            }
            this = v1;
            try {
                v1 = new StringBuilder();
lbl17:
                // 2 sources

                while ((var3_9 = var2_5.readLine()) != null) {
                    ** GOTO lbl-1000
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var0_1) {
                this = var2_5;
                var2_5 = var0_1;
                break block23;
            }
            catch (Exception var0_2) {
                this = var2_5;
                var2_5 = var0_2;
                ** GOTO lbl-1000
            }
            catch (OutOfMemoryError var0_3) {
                this = var2_5;
                var2_5 = var0_3;
                ** GOTO lbl-1000
            }
lbl-1000:
            // 1 sources

            {
                this.append(var3_9).append('\n');
            }
            ** GOTO lbl17
lbl-1000:
            // 1 sources

            {
                v2 = var2_5;
                v3 = var1_4;
                this = this.toString();
            }
            try {
                v3.close();
                v2.close();
                return this;
            }
            catch (IOException v4) {
                v4.printStackTrace();
            }
            return this;
lbl-1000:
            // 2 sources

            {
                InstabugSDKLogger.e("NetworkManager", var2_5.getMessage(), (Throwable)var2_5);
            }
            try {
                var1_4.close();
                if (this == null) return "";
                this.close();
                return "";
            }
            catch (IOException v5) {
                v5.printStackTrace();
                return "";
            }
lbl-1000:
            // 2 sources

            {
                InstabugSDKLogger.e("NetworkManager", var2_5.getMessage(), (Throwable)var2_5);
            }
            try {
                var1_4.close();
                if (this == null) return "";
                this.close();
                return "";
            }
            catch (IOException v6) {
                v6.printStackTrace();
            }
            return "";
        }
        try {
            var1_4.close();
            if (this == null) throw var2_5;
            this.close();
            throw var2_5;
        }
        catch (IOException v7) {
            v7.printStackTrace();
        }
        throw var2_5;
    }

    /*
     * WARNING - void declaration
     */
    private void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        while ((n2 = inputStream.read()) != -1) {
            void var2_3;
            var2_3.write(n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> getHeaderFields(HttpURLConnection connection) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        for (String string2 : connection.getHeaderFields().keySet()) {
            void var1_1;
            hashMap2.put(string2, var1_1.getHeaderField(string2));
        }
        return hashMap2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ HttpURLConnection access$100(NetworkManager x0, Request x1) throws Exception {
        void var1_1;
        return x0.connectWithNormalType((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ HttpURLConnection access$200(NetworkManager x0, Request x1) throws Exception {
        void var1_1;
        return x0.connectWithFileDownloadType((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ HttpURLConnection access$300(NetworkManager x0, Request x1) throws Exception {
        void var1_1;
        return x0.connectWithMultiPartType((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(NetworkManager x0, HttpURLConnection x1) throws IOException {
        void var1_1;
        x0.handleServerConnectionError((HttpURLConnection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ RequestResponse access$500(NetworkManager x0, HttpURLConnection x1) throws IOException {
        void var1_1;
        return x0.handleRequestResponse((HttpURLConnection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ RequestResponse access$600(NetworkManager x0, Request x1, HttpURLConnection x2) throws IOException {
        void var2_2;
        void var1_1;
        return x0.handleFileDownloadRequestResponse((Request)var1_1, (HttpURLConnection)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ RequestResponse access$700(NetworkManager x0, HttpURLConnection x1) throws IOException {
        void var1_1;
        return x0.handleMultipartRequestResponse((HttpURLConnection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$800(NetworkManager x0, String x1) {
        void var1_1;
        return x0.isInstabugRequest((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setOnDoRequestListener(@Nullable OnDoRequestListener onDoRequestListener) {
        void var1_1;
        this.onDoRequestListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Observable<RequestResponse> doRequest(@NonNull Request request) {
        void var1_1;
        OnDoRequestListener onDoRequestListener = this.onDoRequestListener;
        if (onDoRequestListener != null) {
            onDoRequestListener.onRequestStarted((Request)var1_1);
        }
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<RequestResponse>((Request)var1_1){
            final /* synthetic */ Request a;
            {
                this.a = request;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void subscribe(ObservableEmitter<RequestResponse> observableEmitter) {
                if (NetworkManager.this.onDoRequestListener != null) {
                    NetworkManager.this.onDoRequestListener.onStart();
                }
                try {
                    block37: {
                        HttpURLConnection httpURLConnection;
                        block38: {
                            int n2;
                            block36: {
                                HttpURLConnection httpURLConnection2;
                                block35: {
                                    InstabugSDKLogger.d(NetworkManager.TAG, "Request Url: " + this.a.getRequestUrl());
                                    httpURLConnection = null;
                                    n2 = b.a[this.a.getRequestType().ordinal()];
                                    if (n2 == 1) break block35;
                                    if (n2 != 2) {
                                        if (n2 == 3) {
                                            httpURLConnection2 = NetworkManager.access$300(NetworkManager.this, this.a);
                                        }
                                        break block36;
                                    } else {
                                        httpURLConnection2 = NetworkManager.access$200(NetworkManager.this, this.a);
                                    }
                                    break block36;
                                }
                                httpURLConnection2 = httpURLConnection = NetworkManager.access$100(NetworkManager.this, this.a);
                            }
                            if (httpURLConnection == null) break block37;
                            if (httpURLConnection.getResponseCode() >= 400) {
                                NetworkManager.access$400(NetworkManager.this, httpURLConnection);
                            }
                            InstabugSDKLogger.d(NetworkManager.TAG, "Network request completed successfully");
                            n2 = b.a[this.a.getRequestType().ordinal()];
                            if (n2 == 1) break block38;
                            if (n2 != 2) {
                                if (n2 == 3) {
                                    observableEmitter.onNext((Object)NetworkManager.access$700(NetworkManager.this, httpURLConnection));
                                }
                                break block37;
                            } else {
                                observableEmitter.onNext((Object)NetworkManager.access$600(NetworkManager.this, this.a, httpURLConnection));
                            }
                            break block37;
                        }
                        observableEmitter.onNext((Object)NetworkManager.access$500(NetworkManager.this, httpURLConnection));
                    }
                    if (NetworkManager.this.onDoRequestListener != null) {
                        NetworkManager.this.onDoRequestListener.onComplete();
                    }
                    observableEmitter.onComplete();
                    return;
                }
                catch (Exception exception) {
                    try {
                        if (!observableEmitter.isDisposed()) {
                            observableEmitter.onError((Throwable)exception);
                            return;
                        }
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error IIO: " + this.a.getRequestUrl(), exception);
                        return;
                    }
                    catch (Exception exception2) {
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error: " + this.a.getRequestUrl(), exception);
                        return;
                    }
                }
                catch (IOException iOException) {
                    if (this.a.getRequestUrl() != null && NetworkManager.access$800(NetworkManager.this, this.a.getRequestUrl())) {
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error IO: " + this.a.getRequestUrl(), iOException);
                    }
                    try {
                        if (!observableEmitter.isDisposed()) {
                            observableEmitter.onError((Throwable)iOException);
                            return;
                        }
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error IO: " + this.a.getRequestUrl(), iOException);
                        return;
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error: " + this.a.getRequestUrl(), iOException);
                        return;
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    InstabugSDKLogger.e(NetworkManager.TAG, "Request got error IIO: " + this.a.getRequestUrl(), interruptedIOException);
                    try {
                        if (!observableEmitter.isDisposed()) {
                            observableEmitter.onError((Throwable)interruptedIOException);
                            return;
                        }
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error IIO: " + this.a.getRequestUrl(), interruptedIOException);
                        return;
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error: " + this.a.getRequestUrl(), interruptedIOException);
                        return;
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    InstabugSDKLogger.e(NetworkManager.TAG, unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
                    try {
                        if (!observableEmitter.isDisposed()) {
                            observableEmitter.onError((Throwable)unsatisfiedLinkError);
                        } else {
                            InstabugSDKLogger.e(NetworkManager.TAG, "Request got error IIO: " + this.a.getRequestUrl(), unsatisfiedLinkError);
                        }
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error: " + this.a.getRequestUrl(), unsatisfiedLinkError);
                    }
                    InstabugCore.setTemporaryDisabled();
                    return;
                }
                catch (UnknownHostException unknownHostException) {
                    InstabugSDKLogger.e(NetworkManager.TAG, "Request got error UnknownHostException: " + this.a.getRequestUrl(), unknownHostException);
                    try {
                        if (!observableEmitter.isDisposed()) {
                            observableEmitter.onError((Throwable)unknownHostException);
                            return;
                        }
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error IIO: " + this.a.getRequestUrl(), unknownHostException);
                        return;
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e(NetworkManager.TAG, "Request got error: " + this.a.getRequestUrl(), unknownHostException);
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Request buildRequest(Context context, Request.Endpoint endpoint, Request.RequestMethod requestMethod) throws JSONException {
        void var3_3;
        void var2_2;
        void var1_1;
        NetworkManager networkManager = this_;
        Object this_ = RequestType.NORMAL;
        return networkManager.buildRequest((Context)var1_1, (Request.Endpoint)var2_2, (Request.RequestMethod)var3_3, (RequestType)((Object)this_));
    }

    /*
     * WARNING - void declaration
     */
    public Request buildRequest(Context context, Request.Endpoint endpoint, Request.RequestMethod requestMethod, RequestType requestType) throws JSONException {
        void var1_1;
        void var3_3;
        void var4_4;
        void var2_2;
        Request request;
        NetworkManager networkManager = this_;
        Request this_ = request;
        this_((Request.Endpoint)var2_2, (RequestType)var4_4);
        request.setRequestMethod((Request.RequestMethod)var3_3);
        request.addHeader(new Request.RequestParameter("IBG-SDK-VERSION", DeviceStateProvider.getSdkVersion()));
        return networkManager.buildRequest((Context)var1_1, this_);
    }

    /*
     * WARNING - void declaration
     */
    public Request buildRequest(@NonNull Context context, @NonNull String requestUrl, @NonNull Request.RequestMethod requestMethod) throws JSONException {
        void var3_3;
        void var2_2;
        void var1_1;
        NetworkManager networkManager = this_;
        Object this_ = RequestType.NORMAL;
        return networkManager.buildRequest((Context)var1_1, (String)var2_2, (Request.RequestMethod)var3_3, (RequestType)((Object)this_));
    }

    /*
     * WARNING - void declaration
     */
    public Request buildRequest(@NonNull Context context, @NonNull String requestUrl, @NonNull Request.RequestMethod requestMethod, @NonNull RequestType requestType) throws JSONException {
        void var1_1;
        void var3_3;
        void var4_4;
        void var2_2;
        Request request;
        NetworkManager networkManager = this_;
        Request this_ = request;
        this_((String)var2_2, (RequestType)var4_4);
        request.setRequestMethod((Request.RequestMethod)var3_3);
        request.addHeader(new Request.RequestParameter("IBG-SDK-VERSION", DeviceStateProvider.getSdkVersion()));
        return networkManager.buildRequest((Context)var1_1, this_);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Request buildRequestWithoutUUID(Context context, Request.Endpoint endpoint, Request.RequestMethod requestMethod) throws JSONException {
        Request.RequestParameter requestParameter;
        void var3_3;
        void var2_2;
        Request request = new Request((Request.Endpoint)var2_2, RequestType.NORMAL);
        request.setRequestMethod((Request.RequestMethod)var3_3);
        request.addParameter(APP_TOKEN, Instabug.getAppToken());
        Request.RequestParameter requestParameter2 = requestParameter;
        requestParameter = new Request.RequestParameter("IBG-SDK-VERSION", DeviceStateProvider.getSdkVersion());
        request.addHeader(requestParameter2);
        return request;
    }

    public HttpURLConnection buildConnection(Request request) throws Exception, UnsatisfiedLinkError {
        Request.RequestParameter requestParameter2;
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(((Request)((Object)requestParameter2)).getRequestUrl()).openConnection();
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
        httpURLConnection.setRequestProperty("Content-Encoding", "gzip");
        if (d.d().b((Object)com.instabug.library.a.BE_DISABLE_SIGNING) && d.d().a((Object)com.instabug.library.a.BE_DISABLE_SIGNING) != Feature.State.DISABLED && ((NetworkManager)this).isAuthorizationRequired((Request)((Object)requestParameter2)) && !((String)(this = NetworkOfficer.a((Request)((Object)requestParameter2)))).isEmpty()) {
            httpURLConnection.setRequestProperty("Authorization", (String)this);
        }
        for (Request.RequestParameter requestParameter2 : ((Request)((Object)requestParameter2)).getHeaders()) {
            if (requestParameter2.getValue() == null) continue;
            httpURLConnection.setRequestProperty(requestParameter2.getKey(), (String)requestParameter2.getValue());
        }
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        httpURLConnection2.setDoInput(true);
        return httpURLConnection2;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    boolean isAuthorizationRequired(Request request) {
        void var1_1;
        return this.isInstabugRequest((Request)var1_1) && !this.isFeatureRequest((Request)var1_1);
    }

    @VisibleForTesting
    boolean isInstabugRequest(Request request) {
        return request.getRequestUrl().contains("https://api.instabug.com/api/sdk/v3");
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    boolean isFeatureRequest(Request request) {
        void var1_1;
        if (request.getRequestMethod() != null && var1_1.getEndpoint() != null) {
            return var1_1.getRequestMethod().equals((Object)Request.RequestMethod.Get) && var1_1.getEndpoint().contains(Request.Endpoint.APP_SETTINGS.toString());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public HttpURLConnection setURLConnectionTimeOut(HttpURLConnection httpURLConnection, int readTimeOut, int connectionTimeOut) {
        void var3_3;
        void var2_2;
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        httpURLConnection2.setReadTimeout((int)var2_2);
        httpURLConnection2.setConnectTimeout((int)var3_3);
        return httpURLConnection2;
    }

    public static interface OnDoRequestListener {
        public void onRequestStarted(Request var1);

        public void onStart();

        public void onComplete();
    }

    public static final class RequestType
    extends Enum<RequestType> {
        public static final /* enum */ RequestType NORMAL;
        public static final /* enum */ RequestType MULTI_PART;
        public static final /* enum */ RequestType FILE_DOWNLOAD;
        private static final /* synthetic */ RequestType[] $VALUES;

        public static RequestType[] values() {
            return (RequestType[])$VALUES.clone();
        }

        public static RequestType valueOf(String name) {
            String string2;
            return Enum.valueOf(RequestType.class, string2);
        }

        static {
            RequestType requestType;
            NORMAL = new RequestType();
            MULTI_PART = new RequestType();
            RequestType requestType2 = requestType;
            FILE_DOWNLOAD = new RequestType();
            $VALUES = new RequestType[]{NORMAL, MULTI_PART, requestType2};
        }
    }
}

