/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.MediaController;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import com.instabug.library.Feature;
import com.instabug.library.InstabugBaseFragment;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.d;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.PlaceHolderUtils;

public class VideoPlayerFragment
extends InstabugBaseFragment {
    private static final String VIDEO_PATH = "video.uri";
    public static final String TAG = "VideoPlayerFragment";
    @Nullable
    private VideoView videoView;
    private int position = 0;
    @Nullable
    private ProgressDialog progressDialog;
    @Nullable
    private MediaController mediaControls;
    @Nullable
    private String videoUri;

    public static VideoPlayerFragment newInstance(String videoUri) {
        String string2;
        Bundle bundle;
        VideoPlayerFragment videoPlayerFragment = new VideoPlayerFragment();
        Bundle bundle2 = bundle;
        new Bundle().putString(VIDEO_PATH, string2);
        videoPlayerFragment.setArguments(bundle2);
        return videoPlayerFragment;
    }

    /*
     * WARNING - void declaration
     */
    private void showToolbar(boolean shouldShow) {
        if ((this = this.getActivity()) != null && (this = ((AppCompatActivity)this).getSupportActionBar()) != null) {
            void var1_1;
            if (var1_1 != false) {
                this.show();
            } else {
                this.hide();
            }
        }
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_lyt_video_view;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        void var2_2;
        void var1_1;
        super.onViewCreated((View)var1_1, (Bundle)var2_2);
        this.videoView = (VideoView)var1_1.findViewById(R.id.video_view);
        if (d.d().a((Object)Feature.WHITE_LABELING) == Feature.State.DISABLED && (this = this.getActivity()) != null && (this = this.findViewById(R.id.instabug_pbi_footer)) != null) {
            this.setVisibility(8);
        }
    }

    @Override
    public void onResume() {
        VideoPlayerFragment videoPlayerFragment = this;
        super.onResume();
        videoPlayerFragment.showToolbar(false);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        FragmentActivity fragmentActivity;
        VideoPlayerFragment videoPlayerFragment = this;
        super.onActivityCreated((Bundle)fragmentActivity);
        fragmentActivity = videoPlayerFragment.getActivity();
        if (fragmentActivity != null) {
            block8: {
                if (this.mediaControls == null) {
                    MediaController mediaController;
                    MediaController mediaController2 = mediaController;
                    mediaController = new MediaController((Context)fragmentActivity);
                    this.mediaControls = mediaController2;
                }
                VideoPlayerFragment videoPlayerFragment2 = this;
                this.progressDialog = new ProgressDialog((Context)fragmentActivity);
                this.progressDialog.setMessage((CharSequence)"Loading...");
                videoPlayerFragment2.progressDialog.setCancelable(false);
                videoPlayerFragment2.progressDialog.show();
                if (videoPlayerFragment2.videoView == null) break block8;
                if (this.videoUri == null) break block8;
                try {
                    VideoPlayerFragment videoPlayerFragment3 = this;
                    videoPlayerFragment3.videoView.setMediaController(this.mediaControls);
                    videoPlayerFragment3.videoView.setVideoURI(Uri.parse((String)this.videoUri));
                }
                catch (Exception exception) {
                    if (exception.getMessage() != null) {
                        InstabugSDKLogger.e(TAG, exception.getMessage(), exception);
                        break block8;
                    }
                    InstabugSDKLogger.e(TAG, exception.toString(), exception);
                }
            }
            if ((fragmentActivity = this.videoView) != null) {
                VideoPlayerFragment videoPlayerFragment4 = this;
                fragmentActivity.requestFocus();
                videoPlayerFragment4.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    @SuppressLint(value={"NULL_DEREFERENCE"})
                    public void onPrepared(MediaPlayer mediaPlayer) {
                        a a2 = this;
                        a2.VideoPlayerFragment.this.progressDialog.dismiss();
                        a2.VideoPlayerFragment.this.videoView.seekTo(VideoPlayerFragment.this.position);
                        if (a2.VideoPlayerFragment.this.position == 0) {
                            VideoPlayerFragment.this.videoView.start();
                        } else {
                            VideoPlayerFragment.this.videoView.pause();
                        }
                    }
                });
                videoPlayerFragment4.videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                    @SuppressLint(value={"NULL_DEREFERENCE"})
                    public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
                        VideoPlayerFragment.this.progressDialog.dismiss();
                        return false;
                    }
                });
            }
        }
    }

    @Override
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    protected String getTitle() {
        return PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VIDEO_PLAYER_TITLE, this.getString(R.string.instabug_str_video_player));
    }

    public void onDestroy() {
        VideoPlayerFragment videoPlayerFragment = this;
        super.onDestroy();
        videoPlayerFragment.showToolbar(true);
    }

    @Override
    protected void consumeNewInstanceSavedArguments() {
        String string2 = this.getArguments() == null ? null : this.getArguments().getString(VIDEO_PATH);
        this.videoUri = string2;
    }

    @Override
    protected void restoreState(Bundle savedInstanceState) {
        VideoView videoView;
        int n2;
        this.position = n2 = videoView.getInt("Position");
        videoView = this.videoView;
        if (videoView != null) {
            videoView.seekTo(n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void saveState(Bundle outState) {
        VideoView videoView = this.videoView;
        if (videoView != null) {
            void var1_1;
            var1_1.putInt("Position", videoView.getCurrentPosition());
            this.videoView.pause();
        }
    }

    public void onDestroyView() {
        this.mediaControls = null;
        this.videoView = null;
        super.onDestroyView();
        if (d.d().a((Object)Feature.WHITE_LABELING) == Feature.State.DISABLED && (this = this.getActivity()) != null && (this = this.findViewById(R.id.instabug_pbi_footer)) != null) {
            this.setVisibility(0);
        }
    }
}

