/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.instacapture.screenshot;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import android.view.PixelCopy;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.webkit.WebView;
import androidx.annotation.IdRes;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.instacapture.screenshot.FieldHelper;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

public final class ScreenshotTaker {
    private ScreenshotTaker() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Observable<Bitmap> getScreenshotBitmap(Activity activity, @Nullable @IdRes int[] ignoredViewsIds) {
        void var1_1;
        Activity activity2;
        if (activity == null) throw new IllegalArgumentException("Parameter activity cannot be null.");
        View view = activity2.getWindow().getDecorView();
        List<RootViewInfo> list = FieldHelper.getRootViews(activity2, (int[])var1_1);
        InstabugSDKLogger.d(ScreenshotTaker.class, "viewRoots count: " + list.size());
        try {
            view = (long)(view.getWidth() * view.getHeight() * 4) < com.instabug.library.j.e.a.a((Context)activity2) ? Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            return ScreenshotTaker.drawRootsToBitmap(list, (Bitmap)view, (int[])var1_1, activity2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Observable<Bitmap> drawRootsToBitmap(List<RootViewInfo> viewRoots, Bitmap bitmap, @Nullable @IdRes int[] ignoredViewsIds, Activity activity) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Observable.fromIterable(viewRoots).flatMap((Function)new Function<RootViewInfo, ObservableSource<Bitmap>>((Bitmap)var1_1, (int[])var2_2, (Activity)var3_3){
            final /* synthetic */ Bitmap a;
            final /* synthetic */ int[] b;
            final /* synthetic */ Activity c;
            {
                this.a = bitmap;
                this.b = nArray;
                this.c = activity;
            }

            public ObservableSource<Bitmap> a(RootViewInfo object) throws Exception {
                RootViewInfo rootViewInfo = object;
                a a2 = a3;
                a a3 = a2.a;
                object = a2.b;
                Activity activity = a2.c;
                return ScreenshotTaker.access$000(rootViewInfo, (Bitmap)a3, (int[])object, activity);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static Observable<Bitmap> drawRootToBitmap(RootViewInfo rootViewInfo, Bitmap bitmap, @Nullable @IdRes int[] ignoredViewsIds, Activity activity) {
        void var3_3;
        void var2_2;
        void var1_1;
        RootViewInfo rootViewInfo2;
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Pair<Canvas, HashMap<View, Integer>>>((Bitmap)var1_1, (int[])var2_2){
            final /* synthetic */ Bitmap b;
            final /* synthetic */ int[] c;
            {
                this.b = bitmap;
                this.c = nArray;
            }

            public void subscribe(ObservableEmitter<Pair<Canvas, HashMap<View, Integer>>> observableEmitter) throws Exception {
                Pair pair;
                HashMap<View, Integer> hashMap;
                Canvas canvas;
                if ((e2.rootViewInfo2.getLayoutParams().flags & 2) == 2) {
                    new Canvas(e2.b).drawARGB((int)(e2.rootViewInfo2.getLayoutParams().dimAmount * 255.0f), 0, 0, 0);
                }
                Canvas canvas2 = canvas;
                canvas2(e2.b);
                canvas.translate((float)e2.rootViewInfo2.getLeft(), (float)e2.rootViewInfo2.getTop());
                HashMap<View, Integer> hashMap2 = hashMap;
                hashMap = new HashMap<View, Integer>();
                if (e2.c != null) {
                    for (int i2 = 0; i2 < e2.c.length; ++i2) {
                        View view = e2.rootViewInfo2.getView().findViewById(e2.c[i2]);
                        if (view == null) continue;
                        View view2 = view;
                        hashMap2.put(view2, view2.getVisibility());
                    }
                }
                e e2 = pair;
                pair = new Pair((Object)canvas2, hashMap2);
                observableEmitter.onNext((Object)e2);
            }
        }).map((Function)new Function<Pair<Canvas, HashMap<View, Integer>>, Pair<Canvas, HashMap<View, Integer>>>((Activity)var3_3){
            final /* synthetic */ Activity b;
            {
                this.b = activity;
            }

            public Pair<Canvas, HashMap<View, Integer>> a(final Pair<Canvas, HashMap<View, Integer>> pair) throws Exception {
                final Bitmap bitmap = ((HashMap)pair.second).keySet().iterator();
                while (bitmap.hasNext()) {
                    ((View)bitmap.next()).setVisibility(4);
                }
                if (Build.VERSION.SDK_INT > 26) {
                    Rect rect;
                    d d2 = this;
                    bitmap = Bitmap.createBitmap((int)d2.rootViewInfo2.getView().getWidth(), (int)rootViewInfo2.getView().getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Window window = d2.b.getWindow();
                    Rect rect2 = rect;
                    Bitmap bitmap2 = bitmap;
                    int n2 = rootViewInfo2.getLeft();
                    d d3 = this;
                    d d4 = d3;
                    d d5 = d3;
                    int n3 = d3.rootViewInfo2.getTop();
                    int n4 = d5.rootViewInfo2.getLeft() + rootViewInfo2.getView().getWidth();
                    int n5 = d4.rootViewInfo2.getTop() + rootViewInfo2.getView().getHeight();
                    try {
                        rect2(n2, n3, n4, n5);
                        PixelCopy.request((Window)window, (Rect)rect, (Bitmap)bitmap2, (PixelCopy.OnPixelCopyFinishedListener)new PixelCopy.OnPixelCopyFinishedListener(){

                            public void onPixelCopyFinished(int n2) {
                                if (n2 == 0) {
                                    Paint paint;
                                    Paint paint2 = paint;
                                    new Paint().setAntiAlias(true);
                                    paint2.setFilterBitmap(true);
                                    paint2.setDither(true);
                                    a a2 = this;
                                    float f2 = a2.rootViewInfo2.getLeft();
                                    ((Canvas)pair.first).drawBitmap(bitmap, f2, (float)a2.rootViewInfo2.getTop(), paint2);
                                }
                            }
                        }, (Handler)new Handler(Looper.getMainLooper()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        InstabugSDKLogger.e(illegalArgumentException, illegalArgumentException.getMessage() + "");
                    }
                } else {
                    rootViewInfo2.getView().draw((Canvas)pair.first);
                }
                return pair;
            }
        }).observeOn(AndroidSchedulers.mainThread()).map((Function)new Function<Pair<Canvas, HashMap<View, Integer>>, HashMap<View, Integer>>((Bitmap)var1_1){
            final /* synthetic */ Bitmap b;
            {
                this.b = bitmap;
            }

            public HashMap<View, Integer> a(Pair<Canvas, HashMap<View, Integer>> pair) throws Exception {
                c c2 = this;
                c c3 = c2;
                ScreenshotTaker.access$100(c2.rootViewInfo2.getView(), (Canvas)pair.first);
                try {
                    BitmapUtils.maskBitmap(c3.b, (Canvas)pair.first);
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e("ScreenshotTaker", "Something went wrong wile trying to mask bitmap", exception);
                }
                return (HashMap)pair.second;
            }
        }).map((Function)new Function<HashMap<View, Integer>, Bitmap>((Bitmap)var1_1){
            final /* synthetic */ Bitmap a;
            {
                this.a = bitmap;
            }

            public Bitmap a(HashMap<View, Integer> object) throws Exception {
                for (Map.Entry entry : ((HashMap)((Object)object)).entrySet()) {
                    ((View)entry.getKey()).setVisibility(((Integer)entry.getValue()).intValue());
                }
                return this.a;
            }
        }).subscribeOn(AndroidSchedulers.mainThread());
    }

    public static boolean isVisible(View view) {
        Rect rect;
        View view2;
        if (view.getVisibility() != 0) {
            return false;
        }
        View view3 = view2;
        view2 = rect;
        rect = new Rect();
        view3.getGlobalVisibleRect((Rect)view2);
        Context context = Instabug.getApplicationContext();
        int n2 = context == null ? 0 : DisplayUtils.getDisplayWidthInPx(context);
        int n3 = context == null ? 0 : DisplayUtils.getDisplayHeightInPx(context);
        return view2.intersect(new Rect(0, 0, n2, n3));
    }

    public static Rect getVisibleRect(@Nullable View childView) {
        View view;
        Rect rect;
        Rect rect2 = rect;
        rect = new Rect();
        if (childView != null && view.getVisibility() == 0 && view.getRootView().getParent() != null) {
            if (!view.getGlobalVisibleRect(rect2)) {
                return new Rect(0, 0, 0, 0);
            }
            return rect2;
        }
        return new Rect(0, 0, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static ArrayList<View> drawUnDrawableViews(View v, Canvas canvas) {
        ArrayList<View> arrayList;
        View view;
        if (!(v instanceof ViewGroup)) {
            ArrayList<View> arrayList2 = new ArrayList<View>();
            arrayList2.add(view);
            return arrayList2;
        }
        ArrayList<View> arrayList3 = arrayList;
        arrayList = new ArrayList<View>();
        ViewGroup viewGroup = (ViewGroup)view;
        for (int i2 = 0; i2 < viewGroup.getChildCount(); ++i2) {
            void var1_1;
            ArrayList<View> arrayList4;
            View view2 = viewGroup.getChildAt(i2);
            ArrayList<View> arrayList5 = arrayList4;
            arrayList5();
            arrayList5.add(view);
            arrayList4.addAll(ScreenshotTaker.drawUnDrawableViews(view2, (Canvas)var1_1));
            int[] nArray = new int[2];
            view2.getLocationOnScreen(nArray);
            if (Build.VERSION.SDK_INT >= 14 && view2 instanceof TextureView) {
                ScreenshotTaker.drawTextureView((TextureView)view2, nArray, (Canvas)var1_1);
            }
            if (view2 instanceof GLSurfaceView) {
                ScreenshotTaker.drawGLSurfaceView((GLSurfaceView)view2, nArray, (Canvas)var1_1);
            }
            if (view2 instanceof WebView) {
                ScreenshotTaker.drawWebView((WebView)view2, (Canvas)var1_1);
            }
            arrayList3.addAll(arrayList5);
        }
        return arrayList3;
    }

    /*
     * WARNING - void declaration
     */
    public static void drawGLSurfaceView(GLSurfaceView surfaceView, int[] locationOnScreen, Canvas canvas) {
        InstabugSDKLogger.d(ScreenshotTaker.class, "Drawing GLSurfaceView");
        if (surfaceView.getWindowToken() != null) {
            void var2_3;
            Paint paint;
            void var1_1;
            CountDownLatch countDownLatch;
            Object object;
            final int n2 = object.getWidth();
            final int n3 = object.getHeight();
            int[] nArray = new int[n2 * (n3 + 0)];
            final IntBuffer intBuffer = IntBuffer.wrap(nArray);
            intBuffer.position(0);
            final CountDownLatch countDownLatch2 = countDownLatch;
            countDownLatch2(1);
            object.queueEvent(new Runnable(){

                @Override
                public void run() {
                    EGL10 eGL10 = (EGL10)EGLContext.getEGL();
                    eGL10.eglWaitGL();
                    GL10 gL10 = (GL10)eGL10.eglGetCurrentContext().getGL();
                    gL10.glFinish();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    f f2 = this;
                    int n22 = f2.n2;
                    int n32 = f2.n3 + 0;
                    IntBuffer intBuffer2 = f2.intBuffer;
                    gL10.glReadPixels(0, 0, n22, n32, 6408, 5121, (Buffer)intBuffer2);
                    countDownLatch2.countDown();
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            object = new int[n2 * n3];
            int n4 = 0;
            int n5 = 0;
            while (n4 < n3) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n6 = nArray[n4 * n2 + i2];
                    int n7 = n6 >> 16 & 0xFF;
                    int n8 = n6 << 16 & 0xFF0000;
                    n7 = n6 & 0xFF00FF00 | n8 | n7;
                    object[(n3 - n5 - 1) * n2 + i2] = (GLSurfaceView)n7;
                }
                ++n4;
                ++n5;
            }
            Bitmap bitmap = Bitmap.createBitmap((int[])object, (int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            void v4 = var1_1;
            object = paint;
            new Paint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            float f2 = (float)v4[0];
            var2_3.drawBitmap(bitmap, f2, (float)v4[1], (Paint)object);
            bitmap.recycle();
        }
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=14)
    public static void drawTextureView(TextureView textureView, int[] locationOnScreen, Canvas canvas) {
        block7: {
            Paint paint;
            void var1_2;
            void var2_4;
            InstabugSDKLogger.d(ScreenshotTaker.class, "Drawing TextureView");
            TextureView textureView2 = textureView.getBitmap();
            if (textureView2 == null) break block7;
            TextureView textureView3 = textureView2;
            void v1 = var2_4;
            TextureView textureView4 = textureView2;
            void v3 = var1_2;
            void v4 = v3;
            void v5 = v3;
            textureView2 = paint;
            new Paint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            float f2 = (float)v4[0];
            float f3 = (float)v5[1];
            try {
                v1.drawBitmap((Bitmap)textureView4, f2, f3, (Paint)textureView2);
                textureView3.recycle();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e(ScreenshotTaker.class, ScreenshotTaker.class.getSimpleName(), outOfMemoryError);
            }
        }
    }

    @TargetApi(value=11)
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void drawWebView(WebView webView, Canvas canvas) {
        int n2 = webView.getLayerType();
        if (n2 == 2) {
            WebView webView2;
            WebView webView3 = webView2;
            webView3.setLayerType(0, null);
            webView3.setDrawingCacheEnabled(true);
            webView3.buildDrawingCache(true);
            Bitmap bitmap = webView3.getDrawingCache();
            if (bitmap != null) {
                Paint paint;
                Paint paint2;
                void v1 = paint2;
                paint2 = paint;
                new Paint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                int[] nArray = new int[2];
                webView2.getLocationOnScreen(nArray);
                float f2 = nArray[0];
                v1.drawBitmap(bitmap, f2, (float)nArray[1], paint2);
                bitmap.recycle();
            }
            WebView webView4 = webView2;
            webView4.setDrawingCacheEnabled(false);
            webView4.setLayerType(n2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Observable access$000(RootViewInfo x0, Bitmap x1, int[] x2, Activity x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ScreenshotTaker.drawRootToBitmap(x0, (Bitmap)var1_1, (int[])var2_2, (Activity)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ArrayList access$100(View x0, Canvas x1) {
        void var1_1;
        return ScreenshotTaker.drawUnDrawableViews(x0, (Canvas)var1_1);
    }
}

