/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util.threading;

import android.content.Context;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.memory.MemoryUtils;
import com.instabug.library.util.threading.a;
import com.instabug.library.util.threading.b;
import com.instabug.library.util.threading.c;
import com.instabug.library.util.threading.d;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PoolProvider {
    public static final int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    private static final String TAG = "PoolProvider";
    private static PoolProvider INSTANCE;
    private static Map<String, c> singleThreadPoolExecutorhMap;
    private final ThreadPoolExecutor forBitmapTasks;
    private final ThreadPoolExecutor forIOTasks;
    private final ThreadPoolExecutor forComputationTasks;
    private final ScheduledThreadPoolExecutor forScheduledTasks;
    private final Executor mainThreadExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PoolProvider getInstance() {
        if (INSTANCE == null) {
            Class<PoolProvider> clazz = PoolProvider.class;
            synchronized (PoolProvider.class) {
                INSTANCE = new PoolProvider();
            }
        }
        return INSTANCE;
    }

    @Nullable
    public static Context getContext() {
        try {
            return Instabug.getApplicationContext();
        }
        catch (IllegalStateException illegalStateException) {
            IllegalStateException illegalStateException2 = illegalStateException;
            InstabugSDKLogger.e(TAG, illegalStateException.getMessage(), illegalStateException2);
            return null;
        }
    }

    private PoolProvider() {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue3;
        b b2;
        b this_ = b2;
        b2 = new b(10);
        int n2 = NUMBER_OF_CORES;
        int n3 = n2 * 2;
        int n4 = n2 * 2 + 2;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue4 = linkedBlockingQueue3;
        linkedBlockingQueue3 = new LinkedBlockingQueue<Runnable>();
        v3.forBitmapTasks = new ThreadPoolExecutor(n3, n4, 10L, timeUnit, linkedBlockingQueue4, this_);
        int n5 = NUMBER_OF_CORES;
        int n6 = n5 * 2;
        n4 = n5 * 2 + 2;
        TimeUnit timeUnit2 = TimeUnit.SECONDS;
        linkedBlockingQueue4 = linkedBlockingQueue2;
        linkedBlockingQueue2 = new LinkedBlockingQueue<Runnable>();
        v3.forIOTasks = new ThreadPoolExecutor(n6, n4, 10L, timeUnit2, linkedBlockingQueue4, this_);
        int n7 = NUMBER_OF_CORES;
        int n8 = n7 * 2;
        n4 = n7 * 2 + 2;
        TimeUnit timeUnit3 = TimeUnit.SECONDS;
        linkedBlockingQueue4 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        v3.forComputationTasks = new ThreadPoolExecutor(n8, n4, 10L, timeUnit3, linkedBlockingQueue4, this_);
        v3.forScheduledTasks = new ScheduledThreadPoolExecutor(NUMBER_OF_CORES * 2, this_);
        v3.mainThreadExecutor = new a();
    }

    public static void postBitmapTask(Runnable runnable) {
        InstabugSDKLogger.v(TAG, "postBitmapTask");
        if (!MemoryUtils.isLowMemory(PoolProvider.getContext())) {
            try {
                Runnable runnable2;
                PoolProvider.getInstance().forBitmapTasks.execute(runnable2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e(TAG, "low memory, can't perform bitmap task", outOfMemoryError);
            }
        } else {
            InstabugSDKLogger.e(TAG, "low memory, can't perform bitmap task");
        }
    }

    public static void postIOTask(Runnable runnable) {
        InstabugSDKLogger.v(TAG, "postIOTask");
        if (!MemoryUtils.isLowMemory(PoolProvider.getContext())) {
            try {
                Runnable runnable2;
                PoolProvider.getInstance().forIOTasks.execute(runnable2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e(TAG, "low memory, can't run i/o task", outOfMemoryError);
            }
        } else {
            InstabugSDKLogger.e(TAG, "low memory, can't run i/o task");
        }
    }

    public static void postComputationTask(Runnable runnable) {
        InstabugSDKLogger.v(TAG, "postComputationTask");
        if (!MemoryUtils.isLowMemory(PoolProvider.getContext())) {
            try {
                Runnable runnable2;
                PoolProvider.getInstance().forComputationTasks.execute(runnable2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e(TAG, "low memory, can't run computation task", outOfMemoryError);
            }
        } else {
            InstabugSDKLogger.e(TAG, "low memory, can't run computation task");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void postDelayedTask(Runnable runnable, long delayMillis) {
        block2: {
            block3: {
                if (MemoryUtils.isLowMemory(PoolProvider.getContext())) break block3;
                try {
                    void var1_2;
                    Runnable runnable2;
                    PoolProvider.getInstance().forScheduledTasks.schedule(runnable2, (long)var1_2, TimeUnit.MILLISECONDS);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e(TAG, "low memory, can't run delayed task", outOfMemoryError);
                    break block2;
                }
                break block2;
            }
            InstabugSDKLogger.e(TAG, "low memory, can't run delayed task");
        }
    }

    public static void postMainThreadTask(Runnable runnable) {
        InstabugSDKLogger.v(TAG, "postMainThreadTask");
        if (!MemoryUtils.isLowMemory(PoolProvider.getContext())) {
            try {
                Runnable runnable2;
                PoolProvider.getInstance().mainThreadExecutor.execute(runnable2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e(TAG, "low memory, can't run main thread task", outOfMemoryError);
            }
        } else {
            InstabugSDKLogger.e(TAG, "low memory, can't run main thread task");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void postTask(Executor executor, Runnable runnable) {
        InstabugSDKLogger.v(TAG, "postTask");
        if (!MemoryUtils.isLowMemory(PoolProvider.getContext())) {
            try {
                void var1_2;
                Executor executor2;
                executor2.execute((Runnable)var1_2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e(TAG, "low memory, can't run task task", outOfMemoryError);
            }
        } else {
            InstabugSDKLogger.e(TAG, "low memory, can't run task task");
        }
    }

    public static Executor newBackgroundExecutor() {
        b b2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        int n2 = NUMBER_OF_CORES;
        int n3 = n2 * 2;
        int n4 = n2 * 2 + 1;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        b b3 = b2;
        b2 = new b(10);
        return new ThreadPoolExecutor(n3, n4, 60L, timeUnit, linkedBlockingQueue2, b3);
    }

    public static Executor getSingleThreadExecuter(String identifier) {
        c c2;
        String string;
        if (singleThreadPoolExecutorhMap.containsKey(string)) {
            return singleThreadPoolExecutorhMap.get(string);
        }
        c c3 = c2;
        c3();
        c2.a(string).a(new d(){

            @Override
            public void a(String string) {
                singleThreadPoolExecutorhMap.remove(string);
            }
        });
        singleThreadPoolExecutorhMap.put(string, c3);
        return c2;
    }

    public static Executor getUserEventLoggerExecuter() {
        return PoolProvider.getSingleThreadExecuter("UserEventLogger");
    }

    static {
        singleThreadPoolExecutorhMap = new HashMap<String, c>();
    }

    public ThreadPoolExecutor getBackgroundExecutor() {
        return this.forIOTasks;
    }
}

