/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.Instabug;
import com.instabug.library.instacapture.screenshot.ScreenshotTaker;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.AssetsCacheManager;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.memory.Action;
import com.instabug.library.util.memory.MemoryGuard;
import com.instabug.library.util.memory.predicate.MemoryNotLowPredicate;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.VisualUserStepsHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtils {
    public static final String TAG = "BitmapUtils";
    private static final String ICON_FILE_PREFIX = "icon";

    public static Bitmap getBitmapFromUri(@NonNull Uri uri) {
        Bitmap bitmap = null;
        try {
            Uri uri2;
            bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)Instabug.getApplicationContext().getContentResolver(), (Uri)uri2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            InstabugSDKLogger.e(TAG, "getBitmapFromFilePath returns null because of " + iOException.getMessage());
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    public static void compressBitmapAndSave(@NonNull Context context, @NonNull File originalImageFile) {
        void var1_1;
        if (context != null && var1_1 != null) {
            Context context2;
            MemoryGuard.from(context2).withPredicate(new MemoryNotLowPredicate()).doAction(new Action((File)var1_1){
                final /* synthetic */ File a;
                {
                    this.a = file;
                }

                @Override
                public void onAffirmed() throws Throwable {
                    BitmapUtils.compressBitmapAndSave(this.a);
                }

                @Override
                public void onDenied() throws Throwable {
                    InstabugSDKLogger.e(BitmapUtils.TAG, "Not enough memory for compressing image");
                }
            });
            return;
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private static void compressBitmapAndSave(File originalImageFile) {
        FileOutputStream fileOutputStream;
        BitmapFactory.Options options;
        File file;
        BitmapFactory.Options options2;
        Object object = options2;
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)object);
        int n2 = 1;
        while (true) {
            if (object.outWidth / n2 / 2 < 900) break;
            if (object.outHeight / n2 / 2 < 900) break;
            n2 *= 2;
            continue;
            break;
        }
        object = options;
        object();
        options.inSampleSize = n2;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)object);
        Bitmap bitmap2 = bitmap;
        Bitmap bitmap3 = bitmap;
        File file2 = file;
        object = fileOutputStream;
        fileOutputStream = new FileOutputStream(file);
        bitmap2.compress(BitmapUtils.getImageMimeType(file2), 100, (OutputStream)object);
        try {
            bitmap3.recycle();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            InstabugSDKLogger.e(TAG, "compressBitmapAndSave bitmap doesn't compressed correctly " + fileNotFoundException.getMessage());
        }
    }

    private static Bitmap.CompressFormat getImageMimeType(File file) {
        if (file.getName().contains("png")) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static void loadBitmap(String localPath, ImageView imageView) {
        String string2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight) {
        String string2;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (float)var2_2, (float)var3_3);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        String string2;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (BitmapWorkerTask.OnImageLoadedListener)var2_2);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        String string2;
        void var4_4;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (float)var2_2, (float)var3_3, (BitmapWorkerTask.OnImageLoadedListener)var4_4);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    public static Bitmap decodeSampledBitmapFromLocalPath(String imageFilePath) {
        String string2;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options) {
        BitmapFactory.Options options2;
        int n2 = options.outHeight;
        int n3 = options2.outWidth;
        int n4 = 1;
        int n5 = 500;
        int n6 = 500;
        if (n2 > n5 || n3 > n6) {
            int n7 = n3;
            n3 = n2 / 2;
            n2 = n7 / 2;
            while (n3 / n4 >= n5 && n2 / n4 >= n6) {
                n4 *= 2;
            }
        }
        return n4;
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmapAsPNG(Bitmap bitmap, int quality, File directory, String fileNamePrefix, OnSaveBitmapCallback callback) {
        void var4_4;
        void var1_1;
        Bitmap bitmap2;
        void var3_3;
        void var2_2;
        PoolProvider.postBitmapTask(new Runnable((File)var2_2, (String)var3_3, bitmap2, (int)var1_1, (OnSaveBitmapCallback)var4_4){
            final /* synthetic */ File a;
            final /* synthetic */ String b;
            final /* synthetic */ Bitmap c;
            final /* synthetic */ int d;
            final /* synthetic */ OnSaveBitmapCallback e;
            {
                this.a = file;
                this.b = string2;
                this.c = bitmap;
                this.d = n2;
                this.e = onSaveBitmapCallback;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block6: {
                    var1_1 = v0;
                    v0 = new File(this.a, this.b + "_" + System.currentTimeMillis() + ".png");
                    InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + var1_1.toString());
                    var2_3 = v1;
                    var2_3(new FileOutputStream(var1_1));
                    v2 = this.c;
                    v3 = this;
                    var1_1 = Bitmap.CompressFormat.PNG;
                    v2.compress((Bitmap.CompressFormat)var1_1, v3.d, (OutputStream)var2_3);
                    v1.close();
                    var1_1 = Uri.fromFile((File)v0);
                    if (var1_1 == null) ** GOTO lbl20
                    try {
                        this.e.onSuccess((Uri)var1_1);
                        break block6;
lbl20:
                        // 1 sources

                        this.e.onError(new Throwable("Uri equal null"));
                    }
                    catch (IOException var1_2) {
                        this.e.onError(var1_2);
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmap(Bitmap bitmap, Context context, OnSaveBitmapCallback callback) {
        void var2_2;
        Bitmap bitmap2;
        void var1_1;
        PoolProvider.postBitmapTask(new Runnable((Context)var1_1, bitmap2, (OnSaveBitmapCallback)var2_2){
            final /* synthetic */ Context a;
            final /* synthetic */ Bitmap b;
            final /* synthetic */ OnSaveBitmapCallback c;
            {
                this.a = context;
                this.b = bitmap;
                this.c = onSaveBitmapCallback;
            }

            @Override
            public void run() {
                BufferedOutputStream bufferedOutputStream;
                File file;
                Object object = DiskUtils.getInstabugDirectory(this.a);
                File file2 = file;
                file = new File((File)object, "bug_" + System.currentTimeMillis() + "_.jpg");
                InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + file2.toString());
                object = bufferedOutputStream;
                ((BufferedOutputStream)object)(new FileOutputStream(file2));
                this.b.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object);
                bufferedOutputStream.close();
                object = Uri.fromFile((File)file);
                try {
                    new Handler(Looper.getMainLooper()).post(new Runnable((Uri)object){
                        final /* synthetic */ Uri a;
                        {
                            this.a = uri;
                        }

                        @Override
                        public void run() {
                            Uri uri = this.a;
                            if (uri != null) {
                                c.onSuccess(uri);
                            } else {
                                c.onError(new Throwable("Uri equal null"));
                            }
                        }
                    });
                }
                catch (IOException iOException) {
                    this.c.onError(iOException);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void saveDrawableBitmap(Drawable drawable2, long currentTime, OnSaveBitmapCallback callback) {
        void var3_2;
        Drawable drawable3;
        void var1_1;
        if (drawable2 == null) {
            return;
        }
        PoolProvider.postBitmapTask(new Runnable((long)var1_1, drawable3, (OnSaveBitmapCallback)var3_2){
            final /* synthetic */ long a;
            final /* synthetic */ Drawable b;
            final /* synthetic */ OnSaveBitmapCallback c;
            {
                this.a = l2;
                this.b = drawable2;
                this.c = onSaveBitmapCallback;
            }

            @Override
            public void run() {
                d d2 = this;
                d d3 = d2;
                final File file = BitmapUtils.getIconTargetDirectory(d2.a);
                try {
                    InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + file.getPath());
                    BitmapUtils.access$100(d3.b, new OnBitmapReady(){

                        /*
                         * Loose catch block
                         * WARNING - void declaration
                         */
                        @Override
                        public void onBitmapReady(Bitmap bitmap) {
                            void var0_3;
                            BufferedOutputStream bufferedOutputStream;
                            block17: {
                                block18: {
                                    block16: {
                                        BufferedOutputStream bufferedOutputStream2;
                                        Object var2_5 = null;
                                        bufferedOutputStream = bufferedOutputStream2;
                                        Bitmap bitmap2 = bitmap;
                                        bufferedOutputStream(new FileOutputStream(file));
                                        bitmap2.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bufferedOutputStream);
                                        bufferedOutputStream2.close();
                                        catch (IOException iOException) {
                                            break block16;
                                        }
                                        catch (Throwable throwable) {
                                            bufferedOutputStream = var2_5;
                                            break block17;
                                        }
                                        catch (IOException iOException) {
                                            bufferedOutputStream = var2_5;
                                        }
                                    }
                                    InstabugSDKLogger.e(BitmapUtils.TAG, "can't compress bitmap");
                                    if (bufferedOutputStream == null) break block18;
                                    try {
                                        bufferedOutputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        InstabugSDKLogger.e(BitmapUtils.TAG, "can't close BufferedOutputStream");
                                    }
                                }
                                bitmap = Uri.fromFile((File)file);
                                if (bitmap != null) {
                                    c.onSuccess((Uri)bitmap);
                                } else {
                                    c.onError(new Throwable("Uri equal null"));
                                }
                                return;
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            if (bufferedOutputStream != null) {
                                try {
                                    bufferedOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    InstabugSDKLogger.e(BitmapUtils.TAG, "can't close BufferedOutputStream");
                                }
                            }
                            throw var0_3;
                        }

                        @Override
                        public void onBitmapFailedToLoad() {
                        }
                    });
                }
                catch (Exception exception) {
                    this.c.onError(exception);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static void loadBitmapForAsset(Context context, String fileUrl, AssetEntity.AssetType type, OnBitmapReady onBitmapReady) {
        if (context != null) {
            void var3_3;
            AssetsCacheManager.OnDownloadFinished onDownloadFinished;
            void var2_2;
            AssetsCacheManager.OnDownloadFinished onDownloadFinished2;
            Object object;
            Context context2 = object;
            object = AssetsCacheManager.createEmptyEntity(context2, (String)((Object)onDownloadFinished2), (AssetEntity.AssetType)var2_2);
            onDownloadFinished2 = onDownloadFinished;
            onDownloadFinished = new AssetsCacheManager.OnDownloadFinished((OnBitmapReady)var3_3){
                final /* synthetic */ OnBitmapReady a;
                {
                    this.a = onBitmapReady;
                }

                @Override
                public void onSuccess(final AssetEntity assetEntity) {
                    InstabugSDKLogger.d(this, "Asset Entity downloaded: " + assetEntity.getFile().getPath());
                    if (com.instabug.library.util.threading.e.a()) {
                        PoolProvider.postBitmapTask(new Runnable(){

                            @Override
                            public void run() {
                                BitmapUtils.access$200(assetEntity, a);
                            }
                        });
                    } else {
                        BitmapUtils.access$200(assetEntity, this.a);
                    }
                }

                @Override
                public void onFailed(Throwable throwable) {
                    e e2 = this;
                    InstabugSDKLogger.e(e2, "Asset Entity downloading got error", throwable);
                    e2.a.onBitmapFailedToLoad();
                }
            };
            AssetsCacheManager.getAssetEntity(context2, (AssetEntity)object, onDownloadFinished2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private static void decodeBitmap(AssetEntity assetEntity, OnBitmapReady onBitmapReady) {
        try {
            AssetEntity assetEntity2;
            onBitmapReady.onBitmapReady(BitmapFactory.decodeStream((InputStream)new FileInputStream(assetEntity2.getFile())));
        }
        catch (FileNotFoundException fileNotFoundException) {
            void var1_2;
            InstabugSDKLogger.e(TAG, "Asset Entity downloading got FileNotFoundException error", fileNotFoundException);
            var1_2.onBitmapFailedToLoad();
        }
    }

    @WorkerThread
    @NonNull
    public static File getIconTargetDirectory(long currentTime) {
        long l2;
        File file = VisualUserStepsHelper.getVisualUserStepsDirectory(Instabug.getApplicationContext());
        return new File(file, "icon_" + l2 + ".png");
    }

    /*
     * WARNING - void declaration
     */
    private static void drawableToBitmap(Drawable drawable2, OnBitmapReady onBitmapReady) {
        void var1_1;
        Drawable drawable3;
        Context context;
        if (drawable2 instanceof BitmapDrawable && (context = ((BitmapDrawable)drawable3).getBitmap()) != null) {
            var1_1.onBitmapReady(BitmapUtils.resizeBitmap((Bitmap)context, 24.0f, 24.0f));
            return;
        }
        context = Instabug.getApplicationContext();
        if (context != null) {
            int n2 = DisplayUtils.dpToPx(context.getResources(), 72);
            final int n3 = drawable3.getIntrinsicWidth();
            final int n4 = drawable3.getIntrinsicHeight();
            if (n3 <= n2 && n4 <= n2) {
                Canvas canvas;
                Bitmap bitmap = Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                final Canvas canvas2 = canvas;
                canvas = new Canvas(bitmap);
                if (drawable3.getConstantState() != null) {
                    drawable3 = drawable3.getConstantState().newDrawable();
                }
                PoolProvider.postMainThreadTask(new Runnable((OnBitmapReady)var1_1, bitmap){
                    final /* synthetic */ OnBitmapReady e;
                    final /* synthetic */ Bitmap f;
                    {
                        this.e = onBitmapReady;
                        this.f = bitmap;
                    }

                    @Override
                    public void run() {
                        f f2 = this;
                        f f3 = this;
                        int n2 = f3.canvas2.getWidth();
                        int n32 = f3.canvas2.getHeight();
                        f2.drawable3.setBounds(0, 0, n2, n32);
                        f2.drawable3.draw(canvas2);
                        PoolProvider.postBitmapTask(new Runnable(){

                            @Override
                            public void run() {
                                a a2 = object;
                                Object object = a2.this;
                                object = BitmapUtils.access$300(object.n3, object.n4);
                                f f2 = a2.this;
                                Object object2 = object;
                                Object object3 = object2[0];
                                f2.e.onBitmapReady(BitmapUtils.resizeBitmap(f2.f, (float)object3, (float)object2[1]));
                            }
                        });
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static float[] getTargetDimensions(int realWidth, int realHeight) {
        void var1_1;
        int n2;
        float f2 = 24.0f;
        float[] fArray = new float[2];
        float[] fArray2 = fArray;
        fArray[0] = f2;
        fArray[1] = f2;
        if (realHeight > n2) {
            fArray2[0] = (float)n2 / (float)var1_1 * f2;
        } else if (var1_1 < n2) {
            fArray2[1] = (float)var1_1 / (float)n2 * f2;
        }
        return fArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap resizeBitmap(Bitmap bitmap, float targetWidth, float targetHeight) {
        Paint paint;
        Matrix matrix;
        Canvas canvas;
        Bitmap bitmap2;
        void var2_3;
        void var1_1;
        if (bitmap == null) {
            return null;
        }
        if (var1_1 == 0.0f && var2_3 == 0.0f) {
            return bitmap2;
        }
        Bitmap bitmap3 = Bitmap.createBitmap((int)((int)var1_1), (int)((int)var2_3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap2.getWidth() < bitmap2.getHeight() && var1_1 > var2_3) {
            return bitmap2;
        }
        if (bitmap2.getWidth() > bitmap2.getHeight() && var1_1 < var2_3) {
            return bitmap2;
        }
        Canvas canvas2 = canvas;
        canvas = new Canvas(bitmap3);
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        if (bitmap2.getWidth() < bitmap2.getHeight()) {
            matrix2.setScale((float)(var1_1 /= (float)bitmap2.getWidth()), (float)(var2_3 / (float)bitmap2.getHeight()));
        } else {
            void v2 = var1_1;
            var1_1 = var2_3 / (float)bitmap2.getHeight();
            matrix2.setScale((float)var1_1, (float)(v2 / (float)bitmap2.getWidth()));
        }
        Paint paint2 = paint;
        paint = new Paint();
        canvas2.drawBitmap(bitmap2, matrix2, paint2);
        return bitmap3;
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmap(Bitmap bitmap, Uri imageUri, Context context, OnSaveBitmapCallback callback) {
        void var3_3;
        void var2_2;
        Bitmap bitmap2;
        void var1_1;
        PoolProvider.postBitmapTask(new Runnable((Uri)var1_1, bitmap2, (Context)var2_2, (OnSaveBitmapCallback)var3_3){
            final /* synthetic */ Uri a;
            final /* synthetic */ Bitmap b;
            final /* synthetic */ Context c;
            final /* synthetic */ OnSaveBitmapCallback d;
            {
                this.a = uri;
                this.b = bitmap;
                this.c = context;
                this.d = onSaveBitmapCallback;
            }

            @Override
            public void run() {
                g g2 = this;
                final Uri uri = Uri.fromFile((File)new File(this.a.getPath()));
                Bitmap bitmap = g2.b;
                Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
                int bl = 100;
                final boolean bl2 = bitmap.compress(compressFormat, bl, this.c.getContentResolver().openOutputStream(uri));
                try {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            OnSaveBitmapCallback onSaveBitmapCallback;
                            if (bl2 && (onSaveBitmapCallback = d) != null) {
                                onSaveBitmapCallback.onSuccess(uri);
                            }
                        }
                    });
                }
                catch (FileNotFoundException fileNotFoundException) {
                    InstabugSDKLogger.e(BitmapUtils.TAG, fileNotFoundException.getMessage(), fileNotFoundException);
                }
            }
        });
    }

    public static void maskBitmap(Bitmap bitmap, SettingsManager settingsManager, @Nullable Canvas canvas) {
        Canvas canvas2;
        if (canvas == null) {
            Object object;
            Canvas canvas3;
            canvas2 = canvas3;
            canvas3 = new Canvas((Bitmap)object);
        }
        for (View view : SettingsManager.getInstance().getPrivateViews()) {
            if (view == null || !ScreenshotTaker.isVisible(view)) continue;
            View view2 = view;
            view2.getLocationOnScreen(new int[2]);
            canvas2.drawRect(ScreenshotTaker.getVisibleRect(view2), new Paint());
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(Drawable x0, OnBitmapReady x1) {
        void var1_1;
        BitmapUtils.drawableToBitmap(x0, (OnBitmapReady)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(AssetEntity x0, OnBitmapReady x1) {
        void var1_1;
        BitmapUtils.decodeBitmap(x0, (OnBitmapReady)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ float[] access$300(int x0, int x1) {
        void var1_1;
        return BitmapUtils.getTargetDimensions(x0, (int)var1_1);
    }

    @Keep
    public static interface OnBitmapReady {
        public void onBitmapReady(Bitmap var1);

        public void onBitmapFailedToLoad();
    }

    public static interface OnSaveBitmapCallback {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

