/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import com.instabug.library.Feature;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.model.l;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.a;
import com.instabug.library.tracking.d;
import com.instabug.library.tracking.e;
import com.instabug.library.tracking.g;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.h;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class InstabugInternalTrackingDelegate {
    public static final String TAG = "InstabugInternalTrackingDelegate";
    private static InstabugInternalTrackingDelegate INSTANCE;
    @Nullable
    private WeakReference<Activity> currentActivity;
    private final g navigableViewsTrackingDelegate;

    public static void init(@Nullable Application application) {
        if (INSTANCE == null) {
            Application application2;
            INSTANCE = new InstabugInternalTrackingDelegate(application2);
        }
    }

    public static InstabugInternalTrackingDelegate getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private InstabugInternalTrackingDelegate(@Nullable Application application) {
        g g2;
        if (application != null) {
            void var1_1;
            ((InstabugInternalTrackingDelegate)((Object)g3)).registerActivityLifecycleListener((Application)var1_1);
        }
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = g3;
        g g3 = g2;
        g2 = new g();
        instabugInternalTrackingDelegate.navigableViewsTrackingDelegate = g3;
    }

    private void registerActivityLifecycleListener(Application application) {
        a a2;
        Application application2 = application;
        InstabugSDKLogger.d(TAG, "Registering activity lifecycle listener");
        a a3 = a2;
        a2 = new a();
        application2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)a3);
        application2.registerComponentCallbacks((ComponentCallbacks)a3);
    }

    private boolean isUserTrackingStepsEnable() {
        return com.instabug.library.d.c().a((Object)Feature.TRACK_USER_STEPS) == Feature.State.ENABLED;
    }

    private boolean isReproStepsEnable() {
        return com.instabug.library.d.c().a((Object)Feature.REPRO_STEPS) == Feature.State.ENABLED;
    }

    private boolean isNotInstabugActivity(Activity activity) {
        return activity instanceof _InstabugActivity ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public void onApplicationCreated(Application application) {
        if (this.isUserTrackingStepsEnable()) {
            void var1_1;
            InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " created");
            e.c().a(var1_1.getClass().getName(), l.a.APPLICATION_CREATED);
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityCreatedEvent(Activity activity) {
        void var1_1;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)var1_1)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " created");
                e.c().a(var1_1.getClass().getName(), l.a.ACTIVITY_CREATED);
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
                void v0 = var1_1;
                String this_ = v0.getClass().getSimpleName();
                h.d().a(l.a.ACTIVITY_CREATED, this_, v0.getClass().getName(), null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.CREATED);
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityStartedEvent(Activity activity) {
        void var1_1;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)var1_1)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " started");
                e.c().a(var1_1.getClass().getName(), l.a.ACTIVITY_STARTED);
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
                void v0 = var1_1;
                String this_ = v0.getClass().getSimpleName();
                h.d().a(l.a.ACTIVITY_STARTED, this_, v0.getClass().getName(), null);
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STARTED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityResumedEvent(Activity activity) {
        void var1_1;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)var1_1)) {
            ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity = new WeakReference<void>(var1_1);
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " resumed");
                e.c().a(var1_1.getClass().getName(), l.a.ACTIVITY_RESUMED);
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
                void v1 = var1_1;
                String this_ = v1.getClass().getSimpleName();
                h.d().a(l.a.ACTIVITY_RESUMED, this_, v1.getClass().getName(), null);
                instabugInternalTrackingDelegate.navigableViewsTrackingDelegate.b((Activity)var1_1);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.RESUMED);
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityPausedEvent(Activity activity) {
        void var1_1;
        Object object = null;
        WeakReference<Activity> weakReference = this.currentActivity;
        if (weakReference != null) {
            object = (Activity)weakReference.get();
        }
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            if (object == null) {
                InstabugSDKLogger.w(TAG, "No activity was set earlier than this call. Doing nothing");
                return;
            }
            if (!var1_1.equals(object)) {
                InstabugSDKLogger.w(TAG, "You're trying to pause an activity that is not the current activity! Please make sure you're calling onCurrentActivityPaused and onCurrentActivityResumed on every activity");
                return;
            }
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " paused");
                e.c().a(var1_1.getClass().getName(), l.a.ACTIVITY_PAUSED);
            }
            if (this.isReproStepsEnable()) {
                void v0 = var1_1;
                object = v0.getClass().getSimpleName();
                h.d().a(l.a.ACTIVITY_PAUSED, (String)object, v0.getClass().getName(), null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.PAUSED);
        }
        this.navigableViewsTrackingDelegate.a((Activity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityStoppedEvent(Activity activity) {
        void var1_1;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)var1_1)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " stopped");
                e.c().a(var1_1.getClass().getName(), l.a.ACTIVITY_STOPPED);
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
                void v0 = var1_1;
                String this_ = v0.getClass().getSimpleName();
                h.d().a(l.a.ACTIVITY_STOPPED, this_, v0.getClass().getName(), null);
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STOPPED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityDestroyedEvent(Activity activity) {
        void var1_1;
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            Object object;
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " destroyed");
                e.c().a(var1_1.getClass().getName(), l.a.ACTIVITY_DESTROYED);
            }
            if (this.isReproStepsEnable()) {
                void v0 = var1_1;
                object = v0.getClass().getSimpleName();
                h.d().a(l.a.ACTIVITY_DESTROYED, (String)object, v0.getClass().getName(), null);
            }
            if (var1_1 != null && (object = this.currentActivity) != null && ((Reference)object).get() != null && var1_1 == this.currentActivity.get()) {
                this.currentActivity.clear();
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.DESTROYED);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentAttached(Fragment fragment) {
        void var1_1;
        Activity activity = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), activity.getClass().getName(), l.a.FRAGMENT_ATTACHED);
            }
        }
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
            void v1 = var1_1;
            String this_ = v1.getClass().getSimpleName();
            h.d().a(l.a.FRAGMENT_ATTACHED, this_, v1.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentViewCreated(Fragment fragment) {
        void var1_1;
        Activity activity = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), activity.getClass().getName(), l.a.FRAGMENT_VIEW_CREATED);
            }
        }
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            void v2 = var1_1;
            String this_ = v2.getClass().getSimpleName();
            h.d().a(l.a.FRAGMENT_VIEW_CREATED, this_, v2.getClass().getName(), null);
            instabugInternalTrackingDelegate.navigableViewsTrackingDelegate.b((Fragment)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentStarted(Fragment fragment) {
        void var1_1;
        Activity activity = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), activity.getClass().getName(), l.a.FRAGMENT_STARTED);
            }
        }
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
            void v1 = var1_1;
            String this_ = v1.getClass().getSimpleName();
            h.d().a(l.a.FRAGMENT_STARTED, this_, v1.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentResumed(Fragment fragment) {
        void var1_1;
        Object object = ((InstabugInternalTrackingDelegate)this_).currentActivity;
        if (object != null && object.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            object = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), object.getClass().getName(), l.a.FRAGMENT_RESUMED);
            }
        }
        if (((InstabugInternalTrackingDelegate)this_).isReproStepsEnable() && var1_1.getUserVisibleHint()) {
            Object this_ = h.d();
            object = var1_1 instanceof DialogFragment ? l.a.DIALOG_FRAGMENT_RESUMED : l.a.FRAGMENT_RESUMED;
            Object object2 = this_;
            void v2 = var1_1;
            this_ = v2.getClass().getSimpleName();
            ((h)object2).a((l.a)((Object)object), (String)this_, v2.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentPaused(Fragment fragment) {
        void var1_1;
        Activity activity = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), activity.getClass().getName(), l.a.FRAGMENT_PAUSED);
            }
        }
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
            void v1 = var1_1;
            String this_ = v1.getClass().getSimpleName();
            h.d().a(l.a.FRAGMENT_PAUSED, this_, v1.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentStopped(Fragment fragment) {
        void var1_1;
        Activity activity = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), activity.getClass().getName(), l.a.FRAGMENT_STOPPED);
            }
        }
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
            void v1 = var1_1;
            String this_ = v1.getClass().getSimpleName();
            h.d().a(l.a.FRAGMENT_STOPPED, this_, v1.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentDetached(Fragment fragment) {
        void var1_1;
        Object object = this.currentActivity;
        if (object != null && ((Reference)object).get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
            object = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                e.c().a(var1_1.getClass().getName(), object.getClass().getName(), l.a.FRAGMENT_DETACHED);
            }
        }
        if (this.isReproStepsEnable()) {
            void v1 = var1_1;
            object = v1.getClass().getSimpleName();
            h.d().a(l.a.FRAGMENT_DETACHED, (String)object, v1.getClass().getName(), null);
        }
        this.navigableViewsTrackingDelegate.a((Fragment)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void onFragmentVisibilityChanged(boolean isVisible, Fragment fragment) {
        void var2_2;
        Activity activity = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                void var1_1;
                e.c().a(var2_2.getClass().getName(), activity.getClass().getName(), "Fragment visibility: " + (boolean)var1_1, l.a.FRAGMENT_VISIBILITY_CHANGED);
            }
        }
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
            void v1 = var2_2;
            String this_ = v1.getClass().getSimpleName();
            h.d().a(l.a.FRAGMENT_VISIBILITY_CHANGED, this_, v1.getClass().getName(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void trackTouchEvent(MotionEvent event) {
        void var1_1;
        d.a().a((MotionEvent)var1_1);
    }

    @Nullable
    public Activity getCurrentActivity() {
        WeakReference<Activity> this_ = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        return this_ == null ? null : (Activity)this_.get();
    }

    @Nullable
    public Activity getTargetActivity() {
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
        InstabugInternalTrackingDelegate this_ = null;
        Activity activity = null;
        WeakReference<Activity> weakReference = instabugInternalTrackingDelegate.currentActivity;
        if (weakReference != null) {
            activity = (Activity)weakReference.get();
        }
        if (activity != null && activity.getParent() != null) {
            this_ = activity.getParent();
            while (this_.getParent() != null) {
                this_ = this_.getParent();
            }
        } else if (activity != null) {
            this_ = activity;
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    void handleConfigurationChanged(Configuration newConfig) {
        void var1_1;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).getTargetActivity() == null) {
            return;
        }
        com.instabug.library.core.eventbus.a this_ = com.instabug.library.core.eventbus.a.getInstance();
        this_.a((Configuration)var1_1);
        com.instabug.library.core.eventbus.a.getInstance().post(this_);
    }
}

