/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.AttachmentsDbHelper;
import com.instabug.library.model.Attachment;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class AttachmentsUtility {
    public static final String TAG = "AttachmentsUtility";
    private static final double MAX_FILE_SIZE_IN_MB = 5.0;

    public static File getVideoFile(Context context) {
        SimpleDateFormat simpleDateFormat;
        Object object = AttachmentsUtility.getNewDirectory(context, "videos");
        Object object2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        object2 = "video-" + ((DateFormat)object2).format(new Date()) + ".mp4";
        return new File((File)object, (String)object2);
    }

    public static File getFilesAttachmentDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "attachments");
    }

    /*
     * WARNING - void declaration
     */
    public static File getNewDirectory(Context context, String directoryName) {
        void var1_1;
        Context context2;
        File file;
        File file2 = file;
        if (!new File(DiskUtils.getInstabugDirectory(context2) + "/" + (String)var1_1 + "/").exists() && file2.mkdirs()) {
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "frames");
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static Pair<String, String> getFileNameAndSize(Context context, Uri uri) {
        Context context2;
        block10: {
            String string2;
            context2 = context.getContentResolver().query((Uri)string2, null, null, null, null);
            if (context2 != null) {
                Pair pair;
                if (!context2.moveToFirst()) break block10;
                Context context3 = context2;
                Context context4 = context3;
                Context context5 = context3;
                Context context6 = context3;
                string2 = context3.getString(context3.getColumnIndex("_display_name"));
                String string3 = context6.getString(context5.getColumnIndex("_size"));
                Pair pair2 = pair;
                try {
                    pair = new Pair((Object)string2, (Object)string3);
                    return pair2;
                }
                finally {
                    if (context4 != null) {
                        context2.close();
                    }
                }
            }
        }
        if (context2 != null) {
            context2.close();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @RequiresApi(api=19)
    public static InputStream getFileInputStreamFileFromUri(Context context, Uri fileUri) {
        try {
            void var1_1;
            return context.getContentResolver().openInputStream((Uri)var1_1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        void var1_2;
        Cursor cursor = new String[1];
        Cursor cursor2 = cursor;
        cursor[0] = "_data";
        if ((cursor2 = activity.managedQuery((Uri)var1_2, (String[])cursor2, null, null, null)) != null) {
            Cursor cursor3 = cursor2;
            int n2 = cursor3.getColumnIndexOrThrow("_data");
            cursor3.moveToFirst();
            return cursor3.getString(n2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileAttachmentUri(Context context, Uri originalUri, @Nullable String fileNameWithExtension) {
        File file;
        block6: {
            File file2;
            Context context2;
            void var1_2;
            if (originalUri == null) {
                return null;
            }
            Object object = var1_2.getLastPathSegment();
            File file3 = AttachmentsUtility.getFilesAttachmentDirectory(context2);
            object = object == null ? "" : ((String)object).toLowerCase();
            if (file != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(var1_2)) {
                object = file;
            }
            file = file2;
            if (new File(file3, (String)object).exists()) {
                File file4;
                file = file4;
                file4 = new File(file3, System.currentTimeMillis() + "_" + (String)object);
            }
            try {
                DiskUtils.copyFromUriIntoFile(context2, (Uri)var1_2, file);
                if (AttachmentsUtility.validateFileSize(file, 5.0)) break block6;
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(TAG, iOException.getMessage(), iOException);
                return null;
            }
            InstabugSDKLogger.w(TAG, "Attachment file size exceeds than the limit 5.0");
            return null;
        }
        return Uri.fromFile((File)file);
    }

    /*
     * WARNING - void declaration
     */
    public static Uri getNewFileAttachmentUri(Context context, Uri originalUri) {
        void var1_1;
        return AttachmentsUtility.getNewFileAttachmentUri(context, (Uri)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static File getAttachmentFile(Context context, String fileName) {
        void var1_1;
        File file;
        Object object = AttachmentsUtility.getFilesAttachmentDirectory(context);
        File file2 = file;
        if (new File((File)object, (String)var1_1).exists()) {
            File file3;
            file2 = file3;
            file3 = new File((File)object, String.valueOf(System.currentTimeMillis()) + "_" + (String)var1_1);
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    public static Uri getUriFromBytes(Context context, byte[] data, String fileName) {
        void var2_2;
        Object object;
        object = AttachmentsUtility.getAttachmentFile(object, (String)var2_2);
        try {
            AttachmentsUtility.saveBytesToFile(data, (File)object);
        }
        catch (IOException iOException) {
            object = iOException;
            InstabugSDKLogger.e(TAG, iOException.getMessage(), (Throwable)object);
            return null;
        }
        return Uri.fromFile((File)object);
    }

    /*
     * WARNING - void declaration
     */
    private static void saveBytesToFile(byte[] data, File file) throws IOException {
        byte[] byArray;
        void var1_1;
        FileOutputStream fileOutputStream;
        FileOutputStream fileOutputStream2 = fileOutputStream;
        fileOutputStream = new FileOutputStream((File)var1_1);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream2);
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static File saveInputStreamToFile(Context context, InputStream inputStream, String fileName) {
        var3_5 = v0;
        v0 = new File(AttachmentsUtility.getFilesAttachmentDirectory((Context)var0), (String)var2_4);
        var0 = v1;
        try {
            v1 = new FileOutputStream(var3_5);
            var2_4 = new byte[1024];
lbl7:
            // 2 sources

            while ((var4_6 = var1_3.read(var2_4)) != -1) {
                ** GOTO lbl-1000
            }
            ** GOTO lbl18
        }
        catch (Exception var0_1) {
            InstabugSDKLogger.e("AttachmentsUtility", var0_1.getMessage(), var0_1);
            return null;
        }
        catch (IOException var0_2) {
            InstabugSDKLogger.e("AttachmentsUtility", "IO exception: " + var0_2.getMessage(), var0_2);
            return null;
        }
lbl-1000:
        // 1 sources

        {
            var0.write(var2_4, 0, var4_6);
            ** GOTO lbl7
lbl18:
            // 1 sources

            v2 = var0;
            var1_3.close();
            v2.flush();
            v2.close();
            return var3_5;
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(api=19)
    public static File getFileFromContentProvider(Context context, Uri uri, String fileName) {
        InputStream inputStream;
        if ((inputStream = AttachmentsUtility.getFileInputStreamFileFromUri(context, (Uri)inputStream)) != null) {
            void var2_2;
            Context context2;
            return AttachmentsUtility.saveInputStreamToFile(context2, inputStream, (String)var2_2);
        }
        InstabugSDKLogger.e(TAG, "Inputstream is null");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean validateFileSize(File file, double maxFileSize) {
        void var1_1;
        double d2;
        long l2 = file.length();
        double d3 = (double)l2 / 1048576.0;
        if (d2 > var1_1) {
            InstabugSDKLogger.w(TAG, "External attachment file size is " + l2 + " bytes or " + d3 + " MBs > maxFileSize " + (double)var1_1);
            return false;
        }
        return true;
    }

    public static void encryptAttachments(List<Attachment> attachments) {
        InstabugSDKLogger.d(TAG, "encryptAttachments");
        if (attachments != null) {
            Iterator<Attachment> iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Attachment attachment = (Attachment)iterator.next();
                if (attachment.isEncrypted() || attachment.getLocalPath() == null) continue;
                Attachment attachment2 = attachment;
                attachment2.setEncrypted(InstabugCore.encrypt(attachment2.getLocalPath()));
            }
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void encryptAttachmentsAndUpdateDb(List<Attachment> attachments) {
        InstabugSDKLogger.d(TAG, "encryptAttachmentsAndUpdateDb");
        if (attachments != null) {
            Iterator<Attachment> iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ContentValues contentValues;
                Attachment attachment = (Attachment)iterator.next();
                if (attachment.isEncrypted()) continue;
                Attachment attachment2 = attachment;
                boolean bl = InstabugCore.encrypt(attachment2.getLocalPath());
                attachment2.setEncrypted(bl);
                ContentValues contentValues2 = contentValues;
                contentValues2();
                contentValues.put("encrypted", Boolean.valueOf(bl));
                AttachmentsDbHelper.update(attachment2.getId(), contentValues2);
            }
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static boolean decryptAttachmentAndUpdateDb(Attachment attachment) {
        InstabugSDKLogger.d(TAG, "decryptAttachmentAndUpdateDb");
        if (attachment.isEncrypted()) {
            ContentValues contentValues;
            Attachment attachment2;
            boolean bl = InstabugCore.decrypt(attachment2.getLocalPath());
            Attachment attachment3 = attachment2;
            attachment3.setEncrypted(bl ^ true);
            attachment2 = contentValues;
            attachment2();
            String string2 = "encrypted";
            contentValues.put(string2, Boolean.valueOf(bl ^ true));
            AttachmentsDbHelper.update(attachment3.getId(), (ContentValues)attachment2);
            return bl;
        }
        return true;
    }
}

