/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AttachmentManager {
    public static final String TAG = "AttachmentManager";
    private static final double MAX_FILE_SIZE_IN_MB = 50.0;

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static File getAttachmentDirectory(Context context) {
        File file;
        Object object;
        if (context == null && Instabug.isBuilt()) {
            object = Instabug.getApplicationContext();
        }
        if (object == null) {
            return null;
        }
        if (object.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                object = object.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {
                object = AttachmentManager.getInternalStoragePath(object);
            }
        } else {
            object = AttachmentManager.getInternalStoragePath(object);
        }
        File file2 = file;
        if (!new File((String)object + "/instabug/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    public static File getNewDirectory(Context context, String directoryName) {
        void var1_1;
        Context context2;
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context2) + "/" + (String)var1_1 + "/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getVideoFile(Context context) {
        SimpleDateFormat simpleDateFormat;
        Object object = AttachmentManager.getVideoRecordingVideosDirectory(context);
        Object object2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.getDefault());
        object2 = "video-" + ((DateFormat)object2).format(new Date()) + ".mp4";
        return new File((File)object, (String)object2);
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        Context context2;
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context2) + "/frames/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getVideoRecordingVideosDirectory(Context context) {
        Context context2;
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context2) + "/videos/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getAutoScreenRecordingVideosDirectory(Context context) {
        Context context2;
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context2) + "/auto_recording/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getAutoScreenRecordingFile(Context context) {
        SimpleDateFormat simpleDateFormat;
        Object object = AttachmentManager.getAutoScreenRecordingVideosDirectory(context);
        Object object2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        object2 = "auto-recording-" + ((DateFormat)object2).format(new Date()) + ".mp4";
        return new File((File)object, (String)object2);
    }

    private static String getInternalStoragePath(Context context) {
        InstabugSDKLogger.w(TAG, "External storage not available, saving file to internal storage.");
        return context.getFilesDir().getAbsolutePath();
    }

    /*
     * WARNING - void declaration
     */
    private static void saveBytesToFile(byte[] data, File file) throws IOException {
        byte[] byArray;
        void var1_1;
        FileOutputStream fileOutputStream;
        FileOutputStream fileOutputStream2 = fileOutputStream;
        fileOutputStream = new FileOutputStream((File)var1_1);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream2);
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    /*
     * WARNING - void declaration
     */
    private static File getAttachmentFile(Context context, String fileName) {
        void var1_1;
        File file;
        Object object = AttachmentManager.getAttachmentDirectory(context);
        File file2 = file;
        if (new File((File)object, (String)var1_1).exists()) {
            File file3;
            file2 = file3;
            file3 = new File((File)object, String.valueOf(System.currentTimeMillis()) + "_" + (String)var1_1);
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    public static Uri getUriFromBytes(Context context, byte[] data, String fileName) {
        void var2_2;
        Object object;
        object = AttachmentManager.getAttachmentFile(object, (String)var2_2);
        try {
            AttachmentManager.saveBytesToFile(data, (File)object);
        }
        catch (IOException iOException) {
            object = iOException;
            InstabugSDKLogger.e(TAG, iOException.getMessage(), (Throwable)object);
            return null;
        }
        return Uri.fromFile((File)object);
    }

    /*
     * WARNING - void declaration
     */
    public static void copyFromUriIntoFile(Context context, Uri source, File target) throws IOException {
        int n2;
        BufferedOutputStream bufferedOutputStream;
        void var2_2;
        BufferedOutputStream bufferedOutputStream2;
        Object object;
        BufferedInputStream bufferedInputStream;
        BufferedInputStream bufferedInputStream2 = bufferedInputStream;
        bufferedInputStream = new BufferedInputStream(object.getContentResolver().openInputStream((Uri)bufferedOutputStream2));
        InstabugSDKLogger.d(TAG, "Target file path: " + var2_2.getPath());
        bufferedOutputStream2 = bufferedOutputStream;
        bufferedOutputStream = new BufferedOutputStream(object.getContentResolver().openOutputStream(Uri.fromFile((File)var2_2)));
        object = new byte[32768];
        while ((n2 = bufferedInputStream2.read((byte[])object)) > 0) {
            bufferedOutputStream2.write((byte[])object, 0, n2);
        }
        bufferedOutputStream2.close();
        bufferedInputStream2.close();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        void var1_2;
        if (activity != null && var1_2 != null) {
            Cursor cursor;
            Cursor cursor2 = cursor;
            Cursor cursor3 = new String[1];
            cursor = cursor3;
            cursor3[0] = "_data";
            if ((cursor = cursor2.managedQuery((Uri)var1_2, (String[])cursor, null, null, null)) != null) {
                Cursor cursor4 = cursor;
                int n2 = cursor4.getColumnIndexOrThrow("_data");
                cursor4.moveToFirst();
                return cursor4.getString(n2);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileUri(Context context, Uri originalUri, @Nullable String fileNameWithExtension) {
        Object object;
        block4: {
            void var2_3;
            void var1_2;
            if (originalUri == null) {
                return null;
            }
            String string = var1_2.getLastPathSegment().toLowerCase();
            if (var2_3 != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(var1_2)) {
                string = var2_3;
            }
            Context context2 = object;
            object = AttachmentManager.getAttachmentFile(object, string);
            try {
                AttachmentManager.copyFromUriIntoFile(context2, (Uri)var1_2, (File)object);
                if (AttachmentManager.validateFileSize((Uri)var1_2, (File)object)) break block4;
                return null;
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(TAG, iOException.getMessage(), iOException);
                return null;
            }
        }
        return Uri.fromFile((File)object);
    }

    /*
     * WARNING - void declaration
     */
    public static Uri getNewFileUri(Context context, Uri originalUri) {
        void var1_1;
        return AttachmentManager.getNewFileUri(context, (Uri)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean validateFileSize(Uri uri, File attachmentFile) {
        Uri uri2;
        if (SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(uri2)) {
            double d2;
            void var1_2;
            double d3 = (double)var1_2.length() / 1048576.0;
            if (d2 > 50.0) {
                InstabugSDKLogger.w(TAG, "Attachment size is" + d3 + ", exceeds " + 50.0 + " MBs file size limit, ignoring attachment");
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static void saveBitmap(Bitmap bitmap, Context context, a callback) {
        block5: {
            var1_2 = AttachmentManager.getAttachmentDirectory(context);
            var3_4 = v0;
            v0 = new File((File)var1_2, "bug_" + System.currentTimeMillis() + "_.jpg");
            InstabugSDKLogger.v("AttachmentManager", "image path: " + var3_4.toString());
            var1_2 = v1;
            var1_2(new FileOutputStream(var3_4));
            var0.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)var1_2);
            v1.close();
            var0 = Uri.fromFile((File)v0);
            if (var0 == null) ** GOTO lbl17
            try {
                var2_3.onSuccess((Uri)var0);
                break block5;
lbl17:
                // 1 sources

                var2_3.onError(new Throwable("Uri equal null"));
            }
            catch (IOException var0_1) {
                var2_3.onError(var0_1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void saveBitmap(Bitmap bitmap, File attachmentDirectory, a callback) {
        block11: {
            block12: {
                block10: {
                    var3_4 = v0;
                    v0 = new File((File)var1_2, "frame_" + System.currentTimeMillis() + "_.jpg");
                    InstabugSDKLogger.v("AttachmentManager", "video frame path: " + var3_4.toString());
                    var1_2 = v1;
                    v1 = new BufferedOutputStream(new FileOutputStream(var3_4));
                    if (bitmap.getWidth() <= var0.getHeight()) break block10;
                    v2 = var0.getWidth();
lbl10:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
                }
                v2 = var0.getHeight();
                ** continue;
                var4_5 = v2;
                if (var4_5 <= 640) break block12;
                v3 = AttachmentManager.resizeBitmap(var0, 640).compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)var1_2);
lbl20:
                // 2 sources

                while (true) {
                    ** GOTO lbl26
                    break;
                }
            }
            v3 = AttachmentManager.resizeBitmap(var0, 320).compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)var1_2);
            ** continue;
lbl26:
            // 1 sources

            var1_2.close();
            var0 = Uri.fromFile((File)var3_4);
            if (var0 == null) ** GOTO lbl32
            try {
                var2_3.onSuccess((Uri)var0);
                break block11;
lbl32:
                // 1 sources

                var2_3.onError(new Throwable("Uri equal null"));
            }
            catch (IOException var0_1) {
                var2_3.onError(var0_1);
            }
        }
    }

    private static Bitmap resizeBitmap(Bitmap image, int maxSize) {
        Bitmap bitmap;
        int n2;
        int n3;
        float f2;
        Bitmap bitmap2 = image;
        int n4 = bitmap2.getWidth();
        float f3 = (float)n4 / (float)bitmap2.getHeight();
        if (f2 > 1.0f) {
            n2 = (int)((float)n3 / f3);
            void v2 = n3;
            n3 = n2;
            n2 = v2;
        } else {
            n2 = (int)((float)n3 * f3);
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n3, (boolean)false);
    }

    public static void deleteRecursive(File fileOrDirectory) {
        File file;
        if (fileOrDirectory.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                int n2 = fileArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    AttachmentManager.deleteRecursive(fileArray[i2]);
                }
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    public static interface a {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

