/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.R;
import com.instabug.library.settings.SettingsManager;

public class StatusBarUtils {
    public static void setStatusBar(Activity activity) {
        Activity activity2;
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity2.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(SettingsManager.getInstance().getStatusBarColor());
        }
        if (Build.VERSION.SDK_INT >= 23) {
            activity2 = activity2.getWindow().getDecorView();
            if (Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                activity2.setSystemUiVisibility(8192);
            } else {
                activity2.setSystemUiVisibility(0);
            }
        }
    }

    public static void setStatusBarForDialog(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 19) {
            Activity activity2;
            Activity activity3 = activity2;
            activity3.getWindow().setFlags(512, 512);
            activity3.getWindow().getDecorView().setSystemUiVisibility(4096);
        }
    }

    public static void darkenStatusBarColor(@NonNull Activity activity, int color2) {
        Activity activity2;
        int n;
        n = Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight ? StatusBarUtils.darkenColor(n) : StatusBarUtils.darkenColor(ContextCompat.getColor((Context)activity2, (int)R.color.instabug_toolbar_color_dark));
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity2.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(n);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            activity2.getWindow().getDecorView().setSystemUiVisibility(0);
        }
    }

    private static int darkenColor(int color2) {
        float[] fArray = new float[3];
        Color.colorToHSV((int)color2, (float[])fArray);
        fArray[2] = fArray[2] * 0.8f;
        return Color.HSVToColor((float[])fArray);
    }
}

