/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.util.InstabugSDKLogger;

public class InstabugAppData {
    @NonNull
    private final Context context;
    @NonNull
    private final PackageManager pm;
    @Nullable
    private ApplicationInfo applicationInfo;

    public InstabugAppData(@NonNull Context context) {
        InstabugAppData instabugAppData = this_;
        ((InstabugAppData)((Object)this_)).context = context;
        ((InstabugAppData)((Object)this_)).pm = context.getPackageManager();
        String this_ = context.getPackageName();
        try {
            instabugAppData.applicationInfo = instabugAppData.pm.getApplicationInfo(this_, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            InstabugSDKLogger.e("InstabugAppData", nameNotFoundException.getMessage(), nameNotFoundException);
        }
    }

    public String getAppName() {
        ApplicationInfo applicationInfo = this.applicationInfo;
        return applicationInfo != null ? this.pm.getApplicationLabel(applicationInfo) : "(unknown)";
    }

    public int getAppIcon() {
        InstabugAppData this_ = this_.applicationInfo;
        return this_ == null ? 0 : ((ApplicationInfo)this_).icon;
    }

    public Intent getMainIntent() {
        return this.pm.getLaunchIntentForPackage(this.context.getPackageName());
    }
}

