/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom.pagerindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.instabug.library.R;
import com.instabug.library.view.ViewUtils;

public final class Dot
extends RelativeLayout {
    private static final int DEFAULT_INACTIVE_DIAMETER_DP = 6;
    private static final int DEFAULT_ACTIVE_DIAMETER_DP = 9;
    private static final int DEFAULT_INACTIVE_COLOR = -1;
    private static final int DEFAULT_ACTIVE_COLOR = -1;
    private static final int DEFAULT_TRANSITION_DURATION_MS = 200;
    private static final boolean DEFAULT_INITIALLY_ACTIVE = false;
    private static final String TAG = "DOT";
    private int inactiveDiameterPx;
    private int activeDiameterPx;
    private int inactiveColor;
    private int activeColor;
    private int transitionDurationMs;
    private State state;
    private ShapeDrawable shape;
    private ImageView drawableHolder;
    private AnimatorSet currentAnimator;

    public Dot(Context context) {
        Dot dot = this;
        super(context);
        dot.currentAnimator = null;
        dot.init(null, 0, 0);
    }

    public Dot(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.currentAnimator = null;
        this.init(attrs, 0, 0);
    }

    public Dot(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.currentAnimator = null;
        this.init(attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public Dot(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.currentAnimator = null;
        this.init(attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - void declaration
     */
    private void init(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        void var1_1;
        attrs = this.getContext().obtainStyledAttributes(attrs, R.styleable.IBDot, defStyleAttr, defStyleRes);
        Dot dot = this;
        defStyleAttr = ViewUtils.convertDpToPx(dot.getContext(), 9.0f);
        this.inactiveDiameterPx = attrs.getDimensionPixelSize(R.styleable.IBDot_ibViewPagerInactiveDiameter, ViewUtils.convertDpToPx(dot.getContext(), 6.0f));
        this.activeDiameterPx = attrs.getDimensionPixelSize(R.styleable.IBDot_ibViewPagerActiveDiameter, defStyleAttr);
        this.inactiveColor = attrs.getColor(R.styleable.IBDot_ibViewPagerInactiveColor, -1);
        this.activeColor = attrs.getColor(R.styleable.IBDot_ibViewPagerActiveColor, -1);
        this.transitionDurationMs = attrs.getInt(R.styleable.IBDot_ibViewPagerTransitionDuration, 200);
        State state = attrs.getBoolean(R.styleable.IBDot_ibViewPagerInitiallyActive, false) ? State.ACTIVE : State.INACTIVE;
        this.state = state;
        var1_1.recycle();
        this.reflectParametersInView();
    }

    private void reflectParametersInView() {
        int n;
        Dot dot = this;
        dot.removeAllViews();
        int n2 = n = Math.max(dot.inactiveDiameterPx, this.activeDiameterPx);
        dot.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n2, n2));
        dot.setGravity(17);
        n = dot.state == State.ACTIVE ? this.activeDiameterPx : this.inactiveDiameterPx;
        int n3 = this.state == State.ACTIVE ? this.activeColor : this.inactiveColor;
        Dot dot2 = this;
        dot2.shape = new ShapeDrawable((Shape)new OvalShape());
        dot2.shape.setIntrinsicWidth(n);
        dot2.shape.setIntrinsicHeight(n);
        dot2.shape.getPaint().setColor(n3);
        dot2.drawableHolder = new ImageView(this.getContext());
        dot2.drawableHolder.setImageDrawable(null);
        dot2.drawableHolder.setImageDrawable((Drawable)this.shape);
        dot2.addView((View)dot2.drawableHolder);
    }

    /*
     * WARNING - void declaration
     */
    private void animateDotChange(int startSize, int endSize, int startColor, int endColor, int duration) {
        if (startSize >= 0) {
            void var2_3;
            if (var2_3 >= 0) {
                void var5_7;
                if (var5_7 >= 0) {
                    void var3_5;
                    void var1_1;
                    void var4_6;
                    AnimatorSet animatorSet = this.currentAnimator;
                    if (animatorSet != null) {
                        animatorSet.cancel();
                    }
                    Dot dot = this;
                    dot.currentAnimator = new AnimatorSet();
                    dot.currentAnimator.setDuration((long)var5_7);
                    dot.currentAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter((int)var2_3, (int)var4_6, (int)var1_1, (int)var3_5){
                        final /* synthetic */ int val$endSize;
                        final /* synthetic */ int val$endColor;
                        final /* synthetic */ int val$startSize;
                        final /* synthetic */ int val$startColor;
                        {
                            this.val$endSize = n;
                            this.val$endColor = n2;
                            this.val$startSize = n3;
                            this.val$startColor = n4;
                        }

                        public void onAnimationStart(Animator animation) {
                            if (Dot.this.state == State.INACTIVE) {
                                Dot.access$002(Dot.this, State.TRANSITIONING_TO_ACTIVE);
                            } else if (Dot.this.state == State.ACTIVE) {
                                Dot.access$002(Dot.this, State.TRANSITIONING_TO_INACTIVE);
                            }
                        }

                        public void onAnimationEnd(Animator animation) {
                            if (!Dot.this.state.isStable()) {
                                Dot dot = Dot.this;
                                Dot.access$002(dot, dot.state.transitioningTo());
                            }
                            1 v1 = this;
                            v1.Dot.this.changeSize(this.val$endSize);
                            v1.Dot.this.changeColor(this.val$endColor);
                            Dot.access$302(v1.Dot.this, null);
                        }

                        public void onAnimationCancel(Animator animation) {
                            if (!Dot.this.state.isStable()) {
                                Dot dot = Dot.this;
                                Dot.access$002(dot, dot.state.transitioningFrom());
                            }
                            1 v1 = this;
                            v1.Dot.this.changeSize(this.val$startSize);
                            v1.Dot.this.changeColor(this.val$startColor);
                            Dot.access$302(v1.Dot.this, null);
                        }
                    });
                    ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{var1_1, var2_3});
                    valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            int this_ = (Integer)animation.getAnimatedValue();
                            this_.Dot.this.changeSize(this_);
                        }
                    });
                    ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                    valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((int)var4_6){
                        final /* synthetic */ int val$endColor;
                        {
                            this.val$endColor = n;
                        }

                        public void onAnimationUpdate(ValueAnimator animation) {
                            Dot.this.changeColor(this.val$endColor);
                        }
                    });
                    dot.currentAnimator.playTogether(new Animator[]{valueAnimator, valueAnimator2});
                    dot.currentAnimator.start();
                    return;
                }
                throw new IllegalArgumentException("duration cannot be less than 0");
            }
            throw new IllegalArgumentException("endSize cannot be less than 0");
        }
        throw new IllegalArgumentException("startSize cannot be less than 0");
    }

    private void changeSize(int newSizePx) {
        Dot dot = this;
        dot.shape.setIntrinsicWidth(newSizePx);
        dot.shape.setIntrinsicHeight(newSizePx);
        dot.drawableHolder.setImageDrawable(null);
        dot.drawableHolder.setImageDrawable((Drawable)this.shape);
    }

    private void changeColor(int newColor) {
        this.shape.getPaint().setColor(newColor);
    }

    static /* synthetic */ State access$002(Dot x0, State x1) {
        x0.state = x1;
        return x1;
    }

    static /* synthetic */ AnimatorSet access$302(Dot x0, AnimatorSet x1) {
        x0.currentAnimator = x1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    public Dot setInactiveDiameterPx(int inactiveDiameterPx) {
        if (inactiveDiameterPx >= 0) {
            void var1_1;
            Dot dot = this;
            dot.inactiveDiameterPx = var1_1;
            dot.reflectParametersInView();
            return dot;
        }
        throw new IllegalArgumentException("inactiveDiameterPx cannot be less than 0");
    }

    /*
     * WARNING - void declaration
     */
    public Dot setInactiveDiameterDp(int inactiveDiameterDp) {
        if (inactiveDiameterDp >= 0) {
            void var1_1;
            Dot dot = this;
            dot.setInactiveDiameterPx(ViewUtils.convertDpToPx(dot.getContext(), (float)var1_1));
            return dot;
        }
        throw new IllegalArgumentException("inactiveDiameterDp cannot be less than 0");
    }

    public int getInactiveDiameter() {
        return this.inactiveDiameterPx;
    }

    /*
     * WARNING - void declaration
     */
    public Dot setActiveDiameterPx(int activeDiameterPx) {
        if (activeDiameterPx >= 0) {
            void var1_1;
            Dot dot = this;
            dot.activeDiameterPx = var1_1;
            dot.reflectParametersInView();
            return dot;
        }
        throw new IllegalArgumentException("activeDiameterPx cannot be less than 0");
    }

    /*
     * WARNING - void declaration
     */
    public Dot setActiveDiameterDp(int activeDiameterDp) {
        if (activeDiameterDp >= 0) {
            void var1_1;
            Dot dot = this;
            dot.setActiveDiameterPx((int)var1_1);
            return dot;
        }
        throw new IllegalArgumentException("activeDiameterDp cannot be less than 0");
    }

    public int getActiveDiameter() {
        return this.activeDiameterPx;
    }

    public int getInactiveColor() {
        return this.inactiveColor;
    }

    public Dot setInactiveColor(int inactiveColor) {
        Dot dot = this;
        dot.inactiveColor = inactiveColor;
        dot.reflectParametersInView();
        return dot;
    }

    public int getActiveColor() {
        return this.activeColor;
    }

    public Dot setActiveColor(int activeColor) {
        Dot dot = this;
        dot.activeColor = activeColor;
        dot.reflectParametersInView();
        return dot;
    }

    public int getTransitionDuration() {
        return this.transitionDurationMs;
    }

    /*
     * WARNING - void declaration
     */
    public Dot setTransitionDuration(int transitionDurationMs) {
        if (transitionDurationMs >= 0) {
            void var1_1;
            this.transitionDurationMs = var1_1;
            return this;
        }
        throw new IllegalArgumentException("transitionDurationMs cannot be less than 0");
    }

    /*
     * WARNING - void declaration
     */
    public void toggleState(boolean animate) {
        void var1_1;
        Object object = this.currentAnimator;
        if (object != null) {
            object.cancel();
        }
        if ((object = this.state) != State.ACTIVE) {
            this.setActive((boolean)var1_1);
        } else if (object != State.INACTIVE) {
            this.setInactive((boolean)var1_1);
        } else {
            Log.e((String)TAG, (String)"[Animation trying to start from illegal state]");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setInactive(boolean animate) {
        void var1_1;
        AnimatorSet animatorSet = this.currentAnimator;
        if (animatorSet != null) {
            animatorSet.cancel();
        }
        if (var1_1 != false && this.state != State.INACTIVE && this.transitionDurationMs > 0) {
            Dot dot = this;
            dot.animateDotChange(dot.activeDiameterPx, this.inactiveDiameterPx, this.activeColor, this.inactiveColor, this.transitionDurationMs);
        } else {
            Dot dot = this;
            dot.changeSize(dot.inactiveDiameterPx);
            dot.changeColor(dot.inactiveColor);
            dot.state = State.INACTIVE;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setActive(boolean animate) {
        void var1_1;
        AnimatorSet animatorSet = this.currentAnimator;
        if (animatorSet != null) {
            animatorSet.cancel();
        }
        if (var1_1 != false && this.state != State.ACTIVE && this.transitionDurationMs > 0) {
            Dot dot = this;
            dot.animateDotChange(dot.inactiveDiameterPx, this.activeDiameterPx, this.inactiveColor, this.activeColor, this.transitionDurationMs);
        } else {
            Dot dot = this;
            dot.changeSize(dot.activeDiameterPx);
            dot.changeColor(dot.activeColor);
            dot.state = State.ACTIVE;
        }
    }

    protected static final class State
    extends Enum<State> {
        public static final /* enum */ State INACTIVE = new State(true, null, null);
        public static final /* enum */ State ACTIVE;
        public static final /* enum */ State TRANSITIONING_TO_ACTIVE;
        public static final /* enum */ State TRANSITIONING_TO_INACTIVE;
        private static final /* synthetic */ State[] $VALUES;
        private final boolean isStable;
        private final State to;
        private final State from;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        private State(boolean isStable, State to, State from) {
            this.isStable = isStable;
            this.to = to;
            this.from = from;
        }

        static {
            State state = ACTIVE = new State(true, null, null);
            State state2 = INACTIVE;
            TRANSITIONING_TO_ACTIVE = new State(false, state, state2);
            state = INACTIVE;
            state2 = ACTIVE;
            TRANSITIONING_TO_INACTIVE = new State(false, state, state2);
            $VALUES = new State[]{INACTIVE, ACTIVE, TRANSITIONING_TO_ACTIVE, TRANSITIONING_TO_INACTIVE};
        }

        public boolean isStable() {
            return this.isStable;
        }

        public State transitioningTo() {
            return this.to;
        }

        public State transitioningFrom() {
            return this.from;
        }
    }
}

